# vim: ts=4
###
#
# Listen is the legal property of mehdi abaakouk <theli48@gmail.com>
# Copyright (c) 2006 Mehdi Abaakouk
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as
# published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
###

import time

import utils

from song import *

from helper import helper

PL_MASTER, PL_NORMAL,PL_SMART, PL_PODCAST, PL_IRADIO = range(0,5)

class LibraryWrapper:
    def __init__(self):
        self.librarys = []
    
    def change_songs(self,songs):
        changed = []
        for library in self.librarys:
            songs = library.change_songs(songs,False)
            changed.extend([song for song in songs  if song not in changed])

        helper.change_songs(changed)
        return changed
    
    def add(self,library):
        self.librarys.append(library)

    def delete(self,library):
        if library in self.librarys:
            del self.librarys[self.librarys.index(library)]
            
    def get_entries_for_tag(self,tag):
        entries = set()
        songs = []
        for library in self.librarys:    
            songs.extend(library.songs.values())
        for song in songs:
            entries.add(song.get_str(tag))
        return entries

    def get_song(self,uri):
        #print uri
        #print len(self.librarys)
        for library in self.librarys:
            song = library.get_song(uri)
            if song:
                return song
        #print "W: Library: Media unknown"
        song = Song()
        song["uri"] = uri
        if song.get_protocol()=="file://":
            song.set_type(sType.LOCAL_FILE)
        #FIXME: Need found better way to detect remote file
        if song.get_protocol() in ["http://","ftp://","smb://","sftp://","ssh://","https://"]:
            song.set_type(sType.REMOTE_FILE)
            
        song.async_read_from_file()
        return song
        """if song.read_from_file():
            return song
        else: 
            print "W:Failed to read",uri
            return None"""
    
    def save(self):
        for library in self.librarys:    
            library.save()
            
    def get_library(self,name):
        for l in self.librarys:
            if l.codeName == name:
                return l
            
library_wrapper = LibraryWrapper()

class Library(object):
    def __init__(self,codeName):
        library_wrapper.add(self)
        self.songs = {}
        self.playlists = []
        self.codeName = codeName
        self.albums_cache = None
        self.is_loaded = False
        
    def load(self):
        if len(filter(lambda pl:pl.is_master(),self.playlists))==0:
            self.playlists.append(Playlist(self,"Master",PL_MASTER))
        if len(filter(lambda pl:pl.is_podcast(),self.playlists))==0:
            self.playlists.append(Playlist(self,"Podcast",PL_PODCAST))
        if len(filter(lambda pl:pl.is_iradio(),self.playlists))==0:
            self.playlists.append(Playlist(self,"iRadio",PL_IRADIO))
            
        
        #reattach the library
        for pl in self.playlists:
            pl.library = self
        self.is_loaded = True
        
    def build_cache(self):
        self.albums_cache = {}
        self.artist_cache = {}
        for uri,song in self.songs.iteritems():
            self.add_to_cache(song)
            
    def add_to_cache(self,song):
        album = song.get_str("album")
        artist = song.get_str("artist")
        album_item = self.albums_cache.setdefault(album,([],0,0,""))
        uris = album_item[0]
        uri_to_add = song.get("uri")
        if uri_to_add not in uris:
            uris.append(uri_to_add)
            playcount = album_item[1]
            playcount += song.get("#playcount")
            duration = album_item[2]
            duration += song.get("#duration")
            
            self.albums_cache[album] = (uris,playcount,duration,song.get("artist"))
        
        
    def remove_from_cache(self,song):
        album = song.get_str("album")
        if self.albums_cache.has_key(album):
            album_item = self.albums_cache[album]
            uris = album_item[0]
            uri_to_remove = song.get("uri")
            if uri_to_remove in uris:
                uris.remove(uri_to_remove)
                playcount = album_item[1]
                playcount -= song.get("#playcount")
                duration = album_item[2]
                duration -= song.get("#duration")
                if len(uris)>0:
                    self.albums_cache[album] = (uris,playcount,duration, album_item[3])
                else:
                    del self.albums_cache[album]
        
        
    def prepare_save(self):
        #Unref the library, only useful for pickle db write
        for pl in self.playlists:
            #pl.cleanup()
            pl.library = None  
            
    def save(self):
        if not self.is_loaded: return
        else: pass
        
    def get_pl_normal(self):
        return [pl for pl in self.playlists if pl.is_normal()]
            
    def get_pl_master(self): 
        for pl in self.playlists:
            if pl.is_master(): return pl
            
    def get_pl_podcast(self): 
        for pl in self.playlists:
            if pl.is_podcast(): return pl
            
    def get_pl_iradio(self): 
        for pl in self.playlists:
            if pl.is_iradio(): return pl
    
    def have_song(self,song): return self.songs.has_key(song.get("uri"))
        
    def get_song(self,uri):
        #print "find",uri
        if self.songs.has_key(uri):
            return self.songs[uri]
        else:
            return None
    
    def add_songs(self,songs):
        added = []
        for song in songs:
            uri = song["uri"]
            if not self.songs.has_key(uri) :
                self.songs[uri]=song
                added.append(song)
                
                if self.albums_cache!=None:
                    self.add_to_cache(song)
                
        if len(added)>0: helper.add_songs(added)
        self.check_for_smart_playlist_add(added)
        return songs
    
    def delete_songs(self,songs):
        deleted = [s for s in songs if self.songs.has_key(s.get("uri"))]
        
        def delete(s): 
            del self.songs[s.get("uri")]
            if self.albums_cache!=None:
                self.remove_from_cache(s) 
            
        map(delete,deleted)

        for pl in self.playlists:
            if not pl.is_smart():
                pl.remove_songs(deleted)
        if len(deleted)>0: helper.delete_songs(deleted)
        self.check_for_smart_playlist_change(deleted)
        return deleted
            
    def change_songs(self,songs,emit_signal=True):
        changed = []        
        for song in songs:
            if self.have_song(song) :
                self.songs[song["uri"]] = song
                changed.append(song)
                      
                if self.albums_cache!=None:
                    self.remove_from_cache(song) 
                    self.add_to_cache(song)   
                    
        if len(changed)>0 and emit_signal: helper.change_songs(changed)
        self.check_for_smart_playlist_change(changed)
        return changed
    

    def check_for_smart_playlist_change(self,songs):
        sp = [p for p in self.playlists if p.is_smart()]
        sp_to_refresh = set()
        for s in songs:
            for p in sp:    
                if s.get("uri") in p.songs:
                   sp_to_refresh.add(p)
        for sp in sp_to_refresh:
            sp.refresh_rules()
            
    def check_for_smart_playlist_add(self,songs):
        sp = [p for p in self.playlists if p.is_smart()]
        sp_to_refresh = set()
        for s in songs:
            for p in sp:
                if p.match_rules(s):
                   sp_to_refresh.add(p)

        for sp in sp_to_refresh:
            sp.refresh_rules()
               
               
    def add_playlist(self,playlist):
        playlist.codeName = self.codeName
        self.playlists.append(playlist)
        helper.playlist_added(playlist)
            
    def delete_playlist(self,playlist):
        if playlist in self.playlists:
            del self.playlists[self.playlists.index(playlist)]
        helper.playlist_removed(playlist)


class PlaylistFunctionException(Exception):
    def __init__(self):
        print "This type of playlist can't use this function"
    
class SongNotExist(Exception):
    def __init__(self):    
        print "Song not exist in the library or the playlist"
        
class SMART:
    LIMIT_TYPE_TITLE, \
    LIMIT_TYPE_MO, \
    LIMIT_TYPE_GO , \
    LIMIT_TYPE_LENGHT= range(0,4)
    
    """
    For string 
    EQUAL = like
    MIN = not like
    MAX = same
    For duration same as String but
    MAX is not allowed
    """
    ACTION_EQUAL, \
    ACTION_MIN, \
    ACTION_MAX = range(0,3)
    
    RULES_TYPE_STRING, \
    RULES_TYPE_INT, \
    RULES_TYPE_DATE, \
    RULES_TYPE_DURATION  = range(0,4)
    
    FIELD_TYPE = {
                   "title":RULES_TYPE_STRING,
                   "album":RULES_TYPE_STRING,
                   "artist":RULES_TYPE_STRING,
                   "genre":RULES_TYPE_STRING,
                   "#duration":RULES_TYPE_DURATION,
                   "#lastplayed":RULES_TYPE_DATE,
                   "#track":RULES_TYPE_INT,
                   "uri":RULES_TYPE_STRING,
                   "#playcount":RULES_TYPE_INT  ,
                   "#date":RULES_TYPE_DATE
                   }
    DATE_TYPE_SECOND = 1 
    DATE_TYPE_MINUTE = 60
    DATE_TYPE_HOUR = 60*60
    DATE_TYPE_DAY = 60*60*25
    DATE_TYPE_WEEK =  60*60*25*7

class SmartRule:
    def __init__(self):
        self.value1 = ""
        self.value2 = None
        self.action = SMART.ACTION_EQUAL
        self.set_field("title")
        
    def set_field(self,field,dont_delete_value=False):
        self.field = field
        self.set_type(SMART.FIELD_TYPE[field],dont_delete_value)    
        
    def set_type(self,type,dont_delete_value):
        self.type = type
        if dont_delete_value:
            return
        if type == SMART.RULES_TYPE_STRING:
            self.value1 = ""
            self.value2 = None
        elif type == SMART.RULES_TYPE_INT:
            self.value1 = 0
            self.value2 = None
        elif type == SMART.RULES_TYPE_DATE:
            self.value1 = 0
            self.value2 = 0
        elif type == SMART.RULES_TYPE_DURATION:
            self.value1 = 0
            self.value2 = 0
    
    def set_value(self,v1,v2=None):
        self.value1 = v1   
        if type == SMART.RULES_TYPE_DATE:
            self.value2 = v2
        elif type == SMART.RULES_TYPE_DURATION:
            self.value2 = 0
    
    def match(self,song):
        if self.type == SMART.RULES_TYPE_STRING:
            value = self.value1.lower().strip()
            if self.action == SMART.ACTION_EQUAL:
                return song.get_str(self.field).lower().rfind(value) != -1    
            elif  self.action == SMART.ACTION_MIN:     
                return  song.get_str(self.field).lower().rfind(value) == -1  
            elif  self.action == SMART.ACTION_MAX:  
                return value == song.get_str(self.field).lower()
            else:
                print _("E:Smart Rules Action unsupported."),self.action
              
        elif self.type == SMART.RULES_TYPE_INT:
            value = self.value1
            if song.get(self.field) == None: return False
            if self.action == SMART.ACTION_EQUAL:
                return value == song.get(self.field)
            elif  self.action == SMART.ACTION_MIN:     
                return value < song.get(self.field)
            elif  self.action == SMART.ACTION_MAX:  
                return value > song.get(self.field)
            else:
                print _("E:Smart Rules Action unsupported."),self.action
            
        elif self.type == SMART.RULES_TYPE_DURATION:
            timestamp1 = time.strptime("%d:%d"%(self.value1,self.value2),"%M:%S")
            timestamp2 = time.strptime(duration_to_string(song.get(self.field)),"%M:%S")
            if self.action == SMART.ACTION_EQUAL:
                return timestamp1 == timestamp2
            elif  self.action == SMART.ACTION_MIN:     
                return timestamp1 < timestamp2
            elif  self.action == SMART.ACTION_MAX:
                return timestamp1 > timestamp2
            else:
                print _("E:Smart Rules Action unsupported."),self.action
            
        elif self.type == SMART.RULES_TYPE_DATE:
            if self.action == SMART.ACTION_EQUAL: 
                return self.value1*self.value2 <= song.get(self.field)
            elif  self.action == SMART.ACTION_MIN:  
                return self.value1*self.value2 >= song.get(self.field)    
            else:
                print _("E:Smart Rules Action unsupported."),self.action
        else:
            print _("E:Smart Rules Type unsupported."),type
        
        return False
    
class Playlist:
    def __init__(self,library,name = None, playlist_type=PL_NORMAL):
        self.songs = []
        self.playlist_type = playlist_type #master,normal,podcast,iradio
        self.library = library
        self.name = name
        
        #For smart playlist
        self.rules = []
        self.rules_union = True
        self.has_limit = False
        self.limit=0
        self.limit_type=SMART.LIMIT_TYPE_TITLE;
        self.order_by="title"
        self.inverse_order_by=False
        
            
        
    def print_rules(self):
        for r in self.rules:
            print "-----------------"    
            print "v1:" ,r.value1
            print "v2:" ,r.value2
            print "action:" ,r.action
            print "field:" ,r.field 
            print "type:" ,r.type
        
        print "-----------------"
        print "Union:", self.rules_union
        print "limit:", self.limit
        print "limit_type:", self.limit_type
        print "order_by:", self.order_by
        print "inverse_order_by:", self.inverse_order_by
        
    def refresh_rules(self):
        if not self.is_smart(): raise PlaylistFunctionException
        self.songs = []
        tmp = [(s.get(self.order_by),s.sort_key,s.get("#size"),s.get("#duration"),s.get("uri")) for s in self.library.get_pl_master().get_songs() if self.match_rules(s)]
        tmp.sort()
        if self.inverse_order_by:
            tmp.reverse()
        print "NB tmp Song in pl:",len(tmp)
            
        if self.has_limit:
            if self.limit_type == SMART.LIMIT_TYPE_TITLE:
                tmp = tmp[:self.limit]
                self.songs = [uri for sort_field,sort_key,size,duration,uri in tmp]
                
            elif self.limit_type == SMART.LIMIT_TYPE_LENGHT:
                total_duration = 0
                for order_field,sort_key,size,duration,uri in tmp:
                    total_duration += duration   
                    print total_duration 
                    if total_duration < self.limit*60*1000:
                        self.songs.append(uri)
                    else:
                        break;
                        
            elif self.limit_type == SMART.LIMIT_TYPE_MO:
                total_size = 0
                for order_field,sort_key,size,duration,uri in tmp:
                    total_size += size     
                    if total_size < self.limit*1024*1024:
                        self.songs.append(uri) 
                    else:
                        break;  
                        
            elif self.limit_type == SMART.LIMIT_TYPE_GO:
                total_size = 0
                for order_field,sort_key,size,duration,uri in tmp:
                    total_size += size         
                    if total_size < self.limit*1024*1024*1024:
                        self.songs.append(uri)
                    else:
                        break;
            else:
                print _("E:Smart LIMIT Type unsupported."),self.limit_type    
        else:
            self.songs = [uri for sort_field,sort_key,size,duration,uri in tmp]
            
        print "NB Song in pl:",len(self.songs)
        helper.pl_smart_populate(self,self.get_songs())
        
        
    def match_rules(self,song):
        if self.rules_union:
            for rule in self.rules:
                if not rule.match(song):
                        return False
            return True
        else:
            for rule in self.rules:
                if rule.match(song):
                        return True
            return False
    
    def cleanup(self):
        uris = self.library.songs.keys()
        self.songs = [ uri for uri in self.songs if uri in uris ]

    
    def __hash__(self):
        return self.library.playlists.index(self)
        
    def is_master(self): return self.playlist_type == PL_MASTER
    def is_podcast(self): return self.playlist_type == PL_PODCAST 
    def is_iradio(self): return self.playlist_type == PL_IRADIO  
    def is_normal(self): return self.playlist_type == PL_NORMAL  
    def is_smart(self): return self.playlist_type == PL_SMART

    def get_songs(self):
        """if self.is_smart():
            raise NotImplemented
        else:"""
        return [self.library.songs[uri] for uri in self.songs] 
        
    def have_song(self,song):
        return song.get("uri") in self.songs
    
    def append(self,songs):
        return Playlist.insert(self,songs,None)
                    
    def insert(self,songs,init_pos):
        if self.is_smart(): raise PlaylistFunctionException
        else :
            added = []   
            songs = self.library.add_songs(songs)
            
            if self.is_master():
                songs = [s for s in songs \
                          if (not self.library.get_pl_podcast() or not self.library.get_pl_podcast().have_song(s)) \
                              and (not self.library.get_pl_iradio() or not self.library.get_pl_iradio().have_song(s))]
            if self.is_normal() or self.is_smart():
                self.library.get_pl_master().append(songs)
                
            songs = [s for s in songs if self.library.have_song(s)]
            pos = init_pos
            for song in songs:
                if not self.is_master() or (self.is_master() and not self.have_song(song)):   
                    if init_pos!=None: 
                        self.songs.insert(pos,song.get("uri"))
                    else:
                        self.songs.append(song.get("uri"))    
                    added.append(song)
                    if init_pos!=None: pos += 1
                    
            if init_pos==None:
                helper.pl_add_songs(self,added)
            else:
                helper.pl_insert_songs(self,added,init_pos)
            
            return added
        
    def remove_pos(self,positions):
        removed = []
        for pos in positions:
            removed.append(self.library.get_song(self.songs[pos]))
            del self.songs[pos]
            
        if len(removed)>0: helper.pl_remove_songs(self,removed,positions)
        
        
    def remove_songs(self,songs):
        if self.is_smart(): raise PlaylistFunctionException
        else :
            uris = [s.get("uri") for s in songs]
            self.songs = [uri for uri in self.songs if uri not in uris]
            """for song in songs:
                uri = song.get("uri")
                while uri in self.songs:
                    del self.songs[self.songs.index(uri)]"""
                    
        #Hum return all song!
        return songs
    
    def clear(self):
        self.songs = []



class SimpleLibrary(Library):
    def __init__(self,codeName):
        super(SimpleLibrary,self).__init__(codeName)
        mpl = Playlist(self,"Master",PL_MASTER)
        self.add_playlist(mpl)
        
    def auto_gen_playlist(self,name,songs):
        pl = Playlist(self,name)  
        self.add_playlist(pl)
        pl.append(songs)
        return pl  
        
    def delete_auto_gen_playlist(self,name):  
        for pl in self.get_pl_normal():
            if pl.name == name:
                self.delete_playlist(pl)
                
        
        

