/*
 * STMP PINCTRL Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___PINCTRL_H
#define __ARCH_ARM___PINCTRL_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_PINCTRL_BASE (REGS_BASE + 0x18000)
#define REGS_PINCTRL_BASE_PHYS (0x80018000)
#define REGS_PINCTRL_SIZE 0x00002000
HW_REGISTER(HW_PINCTRL_CTRL, REGS_PINCTRL_BASE, 0x00000000)
#define HW_PINCTRL_CTRL_ADDR (REGS_PINCTRL_BASE + 0x00000000)
#define BM_PINCTRL_CTRL_SFTRST 0x80000000
#define BM_PINCTRL_CTRL_CLKGATE 0x40000000
#define BM_PINCTRL_CTRL_PRESENT3 0x08000000
#define BM_PINCTRL_CTRL_PRESENT2 0x04000000
#define BM_PINCTRL_CTRL_PRESENT1 0x02000000
#define BM_PINCTRL_CTRL_PRESENT0 0x01000000
#define BM_PINCTRL_CTRL_IRQOUT2 0x00000004
#define BM_PINCTRL_CTRL_IRQOUT1 0x00000002
#define BM_PINCTRL_CTRL_IRQOUT0 0x00000001
HW_REGISTER(HW_PINCTRL_MUXSEL0, REGS_PINCTRL_BASE, 0x00000100)
#define HW_PINCTRL_MUXSEL0_ADDR (REGS_PINCTRL_BASE + 0x00000100)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN15      30
#define BM_PINCTRL_MUXSEL0_BANK0_PIN15 0xC0000000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN15(v) \
	(((v) << 30) & BM_PINCTRL_MUXSEL0_BANK0_PIN15)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN14      28
#define BM_PINCTRL_MUXSEL0_BANK0_PIN14 0x30000000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN14(v)  \
	(((v) << 28) & BM_PINCTRL_MUXSEL0_BANK0_PIN14)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN13      26
#define BM_PINCTRL_MUXSEL0_BANK0_PIN13 0x0C000000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN13(v)  \
	(((v) << 26) & BM_PINCTRL_MUXSEL0_BANK0_PIN13)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN12      24
#define BM_PINCTRL_MUXSEL0_BANK0_PIN12 0x03000000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN12(v)  \
	(((v) << 24) & BM_PINCTRL_MUXSEL0_BANK0_PIN12)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN11      22
#define BM_PINCTRL_MUXSEL0_BANK0_PIN11 0x00C00000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN11(v)  \
	(((v) << 22) & BM_PINCTRL_MUXSEL0_BANK0_PIN11)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN10      20
#define BM_PINCTRL_MUXSEL0_BANK0_PIN10 0x00300000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN10(v)  \
	(((v) << 20) & BM_PINCTRL_MUXSEL0_BANK0_PIN10)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN09      18
#define BM_PINCTRL_MUXSEL0_BANK0_PIN09 0x000C0000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN09(v)  \
	(((v) << 18) & BM_PINCTRL_MUXSEL0_BANK0_PIN09)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN08      16
#define BM_PINCTRL_MUXSEL0_BANK0_PIN08 0x00030000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN08(v)  \
	(((v) << 16) & BM_PINCTRL_MUXSEL0_BANK0_PIN08)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN07      14
#define BM_PINCTRL_MUXSEL0_BANK0_PIN07 0x0000C000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN07(v)  \
	(((v) << 14) & BM_PINCTRL_MUXSEL0_BANK0_PIN07)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN06      12
#define BM_PINCTRL_MUXSEL0_BANK0_PIN06 0x00003000
#define BF_PINCTRL_MUXSEL0_BANK0_PIN06(v)  \
	(((v) << 12) & BM_PINCTRL_MUXSEL0_BANK0_PIN06)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN05      10
#define BM_PINCTRL_MUXSEL0_BANK0_PIN05 0x00000C00
#define BF_PINCTRL_MUXSEL0_BANK0_PIN05(v)  \
	(((v) << 10) & BM_PINCTRL_MUXSEL0_BANK0_PIN05)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN04      8
#define BM_PINCTRL_MUXSEL0_BANK0_PIN04 0x00000300
#define BF_PINCTRL_MUXSEL0_BANK0_PIN04(v)  \
	(((v) << 8) & BM_PINCTRL_MUXSEL0_BANK0_PIN04)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN03      6
#define BM_PINCTRL_MUXSEL0_BANK0_PIN03 0x000000C0
#define BF_PINCTRL_MUXSEL0_BANK0_PIN03(v)  \
	(((v) << 6) & BM_PINCTRL_MUXSEL0_BANK0_PIN03)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN02      4
#define BM_PINCTRL_MUXSEL0_BANK0_PIN02 0x00000030
#define BF_PINCTRL_MUXSEL0_BANK0_PIN02(v)  \
	(((v) << 4) & BM_PINCTRL_MUXSEL0_BANK0_PIN02)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN01      2
#define BM_PINCTRL_MUXSEL0_BANK0_PIN01 0x0000000C
#define BF_PINCTRL_MUXSEL0_BANK0_PIN01(v)  \
	(((v) << 2) & BM_PINCTRL_MUXSEL0_BANK0_PIN01)
#define BP_PINCTRL_MUXSEL0_BANK0_PIN00      0
#define BM_PINCTRL_MUXSEL0_BANK0_PIN00 0x00000003
#define BF_PINCTRL_MUXSEL0_BANK0_PIN00(v)  \
	(((v) << 0) & BM_PINCTRL_MUXSEL0_BANK0_PIN00)
HW_REGISTER(HW_PINCTRL_MUXSEL1, REGS_PINCTRL_BASE, 0x00000110)
#define HW_PINCTRL_MUXSEL1_ADDR (REGS_PINCTRL_BASE + 0x00000110)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN31      30
#define BM_PINCTRL_MUXSEL1_BANK0_PIN31 0xC0000000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN31(v) \
	(((v) << 30) & BM_PINCTRL_MUXSEL1_BANK0_PIN31)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN30      28
#define BM_PINCTRL_MUXSEL1_BANK0_PIN30 0x30000000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN30(v)  \
	(((v) << 28) & BM_PINCTRL_MUXSEL1_BANK0_PIN30)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN29      26
#define BM_PINCTRL_MUXSEL1_BANK0_PIN29 0x0C000000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN29(v)  \
	(((v) << 26) & BM_PINCTRL_MUXSEL1_BANK0_PIN29)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN28      24
#define BM_PINCTRL_MUXSEL1_BANK0_PIN28 0x03000000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN28(v)  \
	(((v) << 24) & BM_PINCTRL_MUXSEL1_BANK0_PIN28)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN27      22
#define BM_PINCTRL_MUXSEL1_BANK0_PIN27 0x00C00000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN27(v)  \
	(((v) << 22) & BM_PINCTRL_MUXSEL1_BANK0_PIN27)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN26      20
#define BM_PINCTRL_MUXSEL1_BANK0_PIN26 0x00300000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN26(v)  \
	(((v) << 20) & BM_PINCTRL_MUXSEL1_BANK0_PIN26)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN25      18
#define BM_PINCTRL_MUXSEL1_BANK0_PIN25 0x000C0000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN25(v)  \
	(((v) << 18) & BM_PINCTRL_MUXSEL1_BANK0_PIN25)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN24      16
#define BM_PINCTRL_MUXSEL1_BANK0_PIN24 0x00030000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN24(v)  \
	(((v) << 16) & BM_PINCTRL_MUXSEL1_BANK0_PIN24)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN23      14
#define BM_PINCTRL_MUXSEL1_BANK0_PIN23 0x0000C000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN23(v)  \
	(((v) << 14) & BM_PINCTRL_MUXSEL1_BANK0_PIN23)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN22      12
#define BM_PINCTRL_MUXSEL1_BANK0_PIN22 0x00003000
#define BF_PINCTRL_MUXSEL1_BANK0_PIN22(v)  \
	(((v) << 12) & BM_PINCTRL_MUXSEL1_BANK0_PIN22)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN21      10
#define BM_PINCTRL_MUXSEL1_BANK0_PIN21 0x00000C00
#define BF_PINCTRL_MUXSEL1_BANK0_PIN21(v)  \
	(((v) << 10) & BM_PINCTRL_MUXSEL1_BANK0_PIN21)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN20      8
#define BM_PINCTRL_MUXSEL1_BANK0_PIN20 0x00000300
#define BF_PINCTRL_MUXSEL1_BANK0_PIN20(v)  \
	(((v) << 8) & BM_PINCTRL_MUXSEL1_BANK0_PIN20)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN19      6
#define BM_PINCTRL_MUXSEL1_BANK0_PIN19 0x000000C0
#define BF_PINCTRL_MUXSEL1_BANK0_PIN19(v)  \
	(((v) << 6) & BM_PINCTRL_MUXSEL1_BANK0_PIN19)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN18      4
#define BM_PINCTRL_MUXSEL1_BANK0_PIN18 0x00000030
#define BF_PINCTRL_MUXSEL1_BANK0_PIN18(v)  \
	(((v) << 4) & BM_PINCTRL_MUXSEL1_BANK0_PIN18)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN17      2
#define BM_PINCTRL_MUXSEL1_BANK0_PIN17 0x0000000C
#define BF_PINCTRL_MUXSEL1_BANK0_PIN17(v)  \
	(((v) << 2) & BM_PINCTRL_MUXSEL1_BANK0_PIN17)
#define BP_PINCTRL_MUXSEL1_BANK0_PIN16      0
#define BM_PINCTRL_MUXSEL1_BANK0_PIN16 0x00000003
#define BF_PINCTRL_MUXSEL1_BANK0_PIN16(v)  \
	(((v) << 0) & BM_PINCTRL_MUXSEL1_BANK0_PIN16)
HW_REGISTER(HW_PINCTRL_MUXSEL2, REGS_PINCTRL_BASE, 0x00000120)
#define HW_PINCTRL_MUXSEL2_ADDR (REGS_PINCTRL_BASE + 0x00000120)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN15      30
#define BM_PINCTRL_MUXSEL2_BANK1_PIN15 0xC0000000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN15(v) \
	(((v) << 30) & BM_PINCTRL_MUXSEL2_BANK1_PIN15)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN14      28
#define BM_PINCTRL_MUXSEL2_BANK1_PIN14 0x30000000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN14(v)  \
	(((v) << 28) & BM_PINCTRL_MUXSEL2_BANK1_PIN14)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN13      26
#define BM_PINCTRL_MUXSEL2_BANK1_PIN13 0x0C000000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN13(v)  \
	(((v) << 26) & BM_PINCTRL_MUXSEL2_BANK1_PIN13)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN12      24
#define BM_PINCTRL_MUXSEL2_BANK1_PIN12 0x03000000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN12(v)  \
	(((v) << 24) & BM_PINCTRL_MUXSEL2_BANK1_PIN12)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN11      22
#define BM_PINCTRL_MUXSEL2_BANK1_PIN11 0x00C00000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN11(v)  \
	(((v) << 22) & BM_PINCTRL_MUXSEL2_BANK1_PIN11)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN10      20
#define BM_PINCTRL_MUXSEL2_BANK1_PIN10 0x00300000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN10(v)  \
	(((v) << 20) & BM_PINCTRL_MUXSEL2_BANK1_PIN10)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN09      18
#define BM_PINCTRL_MUXSEL2_BANK1_PIN09 0x000C0000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN09(v)  \
	(((v) << 18) & BM_PINCTRL_MUXSEL2_BANK1_PIN09)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN08      16
#define BM_PINCTRL_MUXSEL2_BANK1_PIN08 0x00030000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN08(v)  \
	(((v) << 16) & BM_PINCTRL_MUXSEL2_BANK1_PIN08)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN07      14
#define BM_PINCTRL_MUXSEL2_BANK1_PIN07 0x0000C000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN07(v)  \
	(((v) << 14) & BM_PINCTRL_MUXSEL2_BANK1_PIN07)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN06      12
#define BM_PINCTRL_MUXSEL2_BANK1_PIN06 0x00003000
#define BF_PINCTRL_MUXSEL2_BANK1_PIN06(v)  \
	(((v) << 12) & BM_PINCTRL_MUXSEL2_BANK1_PIN06)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN05      10
#define BM_PINCTRL_MUXSEL2_BANK1_PIN05 0x00000C00
#define BF_PINCTRL_MUXSEL2_BANK1_PIN05(v)  \
	(((v) << 10) & BM_PINCTRL_MUXSEL2_BANK1_PIN05)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN04      8
#define BM_PINCTRL_MUXSEL2_BANK1_PIN04 0x00000300
#define BF_PINCTRL_MUXSEL2_BANK1_PIN04(v)  \
	(((v) << 8) & BM_PINCTRL_MUXSEL2_BANK1_PIN04)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN03      6
#define BM_PINCTRL_MUXSEL2_BANK1_PIN03 0x000000C0
#define BF_PINCTRL_MUXSEL2_BANK1_PIN03(v)  \
	(((v) << 6) & BM_PINCTRL_MUXSEL2_BANK1_PIN03)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN02      4
#define BM_PINCTRL_MUXSEL2_BANK1_PIN02 0x00000030
#define BF_PINCTRL_MUXSEL2_BANK1_PIN02(v)  \
	(((v) << 4) & BM_PINCTRL_MUXSEL2_BANK1_PIN02)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN01      2
#define BM_PINCTRL_MUXSEL2_BANK1_PIN01 0x0000000C
#define BF_PINCTRL_MUXSEL2_BANK1_PIN01(v)  \
	(((v) << 2) & BM_PINCTRL_MUXSEL2_BANK1_PIN01)
#define BP_PINCTRL_MUXSEL2_BANK1_PIN00      0
#define BM_PINCTRL_MUXSEL2_BANK1_PIN00 0x00000003
#define BF_PINCTRL_MUXSEL2_BANK1_PIN00(v)  \
	(((v) << 0) & BM_PINCTRL_MUXSEL2_BANK1_PIN00)
HW_REGISTER(HW_PINCTRL_MUXSEL3, REGS_PINCTRL_BASE, 0x00000130)
#define HW_PINCTRL_MUXSEL3_ADDR (REGS_PINCTRL_BASE + 0x00000130)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN30      28
#define BM_PINCTRL_MUXSEL3_BANK1_PIN30 0x30000000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN30(v)  \
	(((v) << 28) & BM_PINCTRL_MUXSEL3_BANK1_PIN30)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN29      26
#define BM_PINCTRL_MUXSEL3_BANK1_PIN29 0x0C000000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN29(v)  \
	(((v) << 26) & BM_PINCTRL_MUXSEL3_BANK1_PIN29)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN28      24
#define BM_PINCTRL_MUXSEL3_BANK1_PIN28 0x03000000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN28(v)  \
	(((v) << 24) & BM_PINCTRL_MUXSEL3_BANK1_PIN28)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN27      22
#define BM_PINCTRL_MUXSEL3_BANK1_PIN27 0x00C00000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN27(v)  \
	(((v) << 22) & BM_PINCTRL_MUXSEL3_BANK1_PIN27)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN26      20
#define BM_PINCTRL_MUXSEL3_BANK1_PIN26 0x00300000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN26(v)  \
	(((v) << 20) & BM_PINCTRL_MUXSEL3_BANK1_PIN26)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN25      18
#define BM_PINCTRL_MUXSEL3_BANK1_PIN25 0x000C0000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN25(v)  \
	(((v) << 18) & BM_PINCTRL_MUXSEL3_BANK1_PIN25)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN24      16
#define BM_PINCTRL_MUXSEL3_BANK1_PIN24 0x00030000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN24(v)  \
	(((v) << 16) & BM_PINCTRL_MUXSEL3_BANK1_PIN24)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN23      14
#define BM_PINCTRL_MUXSEL3_BANK1_PIN23 0x0000C000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN23(v)  \
	(((v) << 14) & BM_PINCTRL_MUXSEL3_BANK1_PIN23)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN22      12
#define BM_PINCTRL_MUXSEL3_BANK1_PIN22 0x00003000
#define BF_PINCTRL_MUXSEL3_BANK1_PIN22(v)  \
	(((v) << 12) & BM_PINCTRL_MUXSEL3_BANK1_PIN22)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN21      10
#define BM_PINCTRL_MUXSEL3_BANK1_PIN21 0x00000C00
#define BF_PINCTRL_MUXSEL3_BANK1_PIN21(v)  \
	(((v) << 10) & BM_PINCTRL_MUXSEL3_BANK1_PIN21)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN20      8
#define BM_PINCTRL_MUXSEL3_BANK1_PIN20 0x00000300
#define BF_PINCTRL_MUXSEL3_BANK1_PIN20(v)  \
	(((v) << 8) & BM_PINCTRL_MUXSEL3_BANK1_PIN20)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN19      6
#define BM_PINCTRL_MUXSEL3_BANK1_PIN19 0x000000C0
#define BF_PINCTRL_MUXSEL3_BANK1_PIN19(v)  \
	(((v) << 6) & BM_PINCTRL_MUXSEL3_BANK1_PIN19)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN18      4
#define BM_PINCTRL_MUXSEL3_BANK1_PIN18 0x00000030
#define BF_PINCTRL_MUXSEL3_BANK1_PIN18(v)  \
	(((v) << 4) & BM_PINCTRL_MUXSEL3_BANK1_PIN18)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN17      2
#define BM_PINCTRL_MUXSEL3_BANK1_PIN17 0x0000000C
#define BF_PINCTRL_MUXSEL3_BANK1_PIN17(v)  \
	(((v) << 2) & BM_PINCTRL_MUXSEL3_BANK1_PIN17)
#define BP_PINCTRL_MUXSEL3_BANK1_PIN16      0
#define BM_PINCTRL_MUXSEL3_BANK1_PIN16 0x00000003
#define BF_PINCTRL_MUXSEL3_BANK1_PIN16(v)  \
	(((v) << 0) & BM_PINCTRL_MUXSEL3_BANK1_PIN16)
HW_REGISTER(HW_PINCTRL_MUXSEL4, REGS_PINCTRL_BASE, 0x00000140)
#define HW_PINCTRL_MUXSEL4_ADDR (REGS_PINCTRL_BASE + 0x00000140)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN15      30
#define BM_PINCTRL_MUXSEL4_BANK2_PIN15 0xC0000000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN15(v) \
	(((v) << 30) & BM_PINCTRL_MUXSEL4_BANK2_PIN15)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN14      28
#define BM_PINCTRL_MUXSEL4_BANK2_PIN14 0x30000000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN14(v)  \
	(((v) << 28) & BM_PINCTRL_MUXSEL4_BANK2_PIN14)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN13      26
#define BM_PINCTRL_MUXSEL4_BANK2_PIN13 0x0C000000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN13(v)  \
	(((v) << 26) & BM_PINCTRL_MUXSEL4_BANK2_PIN13)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN12      24
#define BM_PINCTRL_MUXSEL4_BANK2_PIN12 0x03000000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN12(v)  \
	(((v) << 24) & BM_PINCTRL_MUXSEL4_BANK2_PIN12)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN11      22
#define BM_PINCTRL_MUXSEL4_BANK2_PIN11 0x00C00000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN11(v)  \
	(((v) << 22) & BM_PINCTRL_MUXSEL4_BANK2_PIN11)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN10      20
#define BM_PINCTRL_MUXSEL4_BANK2_PIN10 0x00300000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN10(v)  \
	(((v) << 20) & BM_PINCTRL_MUXSEL4_BANK2_PIN10)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN09      18
#define BM_PINCTRL_MUXSEL4_BANK2_PIN09 0x000C0000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN09(v)  \
	(((v) << 18) & BM_PINCTRL_MUXSEL4_BANK2_PIN09)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN08      16
#define BM_PINCTRL_MUXSEL4_BANK2_PIN08 0x00030000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN08(v)  \
	(((v) << 16) & BM_PINCTRL_MUXSEL4_BANK2_PIN08)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN07      14
#define BM_PINCTRL_MUXSEL4_BANK2_PIN07 0x0000C000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN07(v)  \
	(((v) << 14) & BM_PINCTRL_MUXSEL4_BANK2_PIN07)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN06      12
#define BM_PINCTRL_MUXSEL4_BANK2_PIN06 0x00003000
#define BF_PINCTRL_MUXSEL4_BANK2_PIN06(v)  \
	(((v) << 12) & BM_PINCTRL_MUXSEL4_BANK2_PIN06)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN05      10
#define BM_PINCTRL_MUXSEL4_BANK2_PIN05 0x00000C00
#define BF_PINCTRL_MUXSEL4_BANK2_PIN05(v)  \
	(((v) << 10) & BM_PINCTRL_MUXSEL4_BANK2_PIN05)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN04      8
#define BM_PINCTRL_MUXSEL4_BANK2_PIN04 0x00000300
#define BF_PINCTRL_MUXSEL4_BANK2_PIN04(v)  \
	(((v) << 8) & BM_PINCTRL_MUXSEL4_BANK2_PIN04)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN03      6
#define BM_PINCTRL_MUXSEL4_BANK2_PIN03 0x000000C0
#define BF_PINCTRL_MUXSEL4_BANK2_PIN03(v)  \
	(((v) << 6) & BM_PINCTRL_MUXSEL4_BANK2_PIN03)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN02      4
#define BM_PINCTRL_MUXSEL4_BANK2_PIN02 0x00000030
#define BF_PINCTRL_MUXSEL4_BANK2_PIN02(v)  \
	(((v) << 4) & BM_PINCTRL_MUXSEL4_BANK2_PIN02)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN01      2
#define BM_PINCTRL_MUXSEL4_BANK2_PIN01 0x0000000C
#define BF_PINCTRL_MUXSEL4_BANK2_PIN01(v)  \
	(((v) << 2) & BM_PINCTRL_MUXSEL4_BANK2_PIN01)
#define BP_PINCTRL_MUXSEL4_BANK2_PIN00      0
#define BM_PINCTRL_MUXSEL4_BANK2_PIN00 0x00000003
#define BF_PINCTRL_MUXSEL4_BANK2_PIN00(v)  \
	(((v) << 0) & BM_PINCTRL_MUXSEL4_BANK2_PIN00)
HW_REGISTER(HW_PINCTRL_MUXSEL5, REGS_PINCTRL_BASE, 0x00000150)
#define HW_PINCTRL_MUXSEL5_ADDR (REGS_PINCTRL_BASE + 0x00000150)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN31      30
#define BM_PINCTRL_MUXSEL5_BANK2_PIN31 0xC0000000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN31(v) \
	(((v) << 30) & BM_PINCTRL_MUXSEL5_BANK2_PIN31)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN30      28
#define BM_PINCTRL_MUXSEL5_BANK2_PIN30 0x30000000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN30(v)  \
	(((v) << 28) & BM_PINCTRL_MUXSEL5_BANK2_PIN30)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN29      26
#define BM_PINCTRL_MUXSEL5_BANK2_PIN29 0x0C000000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN29(v)  \
	(((v) << 26) & BM_PINCTRL_MUXSEL5_BANK2_PIN29)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN28      24
#define BM_PINCTRL_MUXSEL5_BANK2_PIN28 0x03000000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN28(v)  \
	(((v) << 24) & BM_PINCTRL_MUXSEL5_BANK2_PIN28)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN27      22
#define BM_PINCTRL_MUXSEL5_BANK2_PIN27 0x00C00000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN27(v)  \
	(((v) << 22) & BM_PINCTRL_MUXSEL5_BANK2_PIN27)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN26      20
#define BM_PINCTRL_MUXSEL5_BANK2_PIN26 0x00300000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN26(v)  \
	(((v) << 20) & BM_PINCTRL_MUXSEL5_BANK2_PIN26)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN25      18
#define BM_PINCTRL_MUXSEL5_BANK2_PIN25 0x000C0000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN25(v)  \
	(((v) << 18) & BM_PINCTRL_MUXSEL5_BANK2_PIN25)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN24      16
#define BM_PINCTRL_MUXSEL5_BANK2_PIN24 0x00030000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN24(v)  \
	(((v) << 16) & BM_PINCTRL_MUXSEL5_BANK2_PIN24)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN23      14
#define BM_PINCTRL_MUXSEL5_BANK2_PIN23 0x0000C000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN23(v)  \
	(((v) << 14) & BM_PINCTRL_MUXSEL5_BANK2_PIN23)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN22      12
#define BM_PINCTRL_MUXSEL5_BANK2_PIN22 0x00003000
#define BF_PINCTRL_MUXSEL5_BANK2_PIN22(v)  \
	(((v) << 12) & BM_PINCTRL_MUXSEL5_BANK2_PIN22)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN21      10
#define BM_PINCTRL_MUXSEL5_BANK2_PIN21 0x00000C00
#define BF_PINCTRL_MUXSEL5_BANK2_PIN21(v)  \
	(((v) << 10) & BM_PINCTRL_MUXSEL5_BANK2_PIN21)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN20      8
#define BM_PINCTRL_MUXSEL5_BANK2_PIN20 0x00000300
#define BF_PINCTRL_MUXSEL5_BANK2_PIN20(v)  \
	(((v) << 8) & BM_PINCTRL_MUXSEL5_BANK2_PIN20)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN19      6
#define BM_PINCTRL_MUXSEL5_BANK2_PIN19 0x000000C0
#define BF_PINCTRL_MUXSEL5_BANK2_PIN19(v)  \
	(((v) << 6) & BM_PINCTRL_MUXSEL5_BANK2_PIN19)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN18      4
#define BM_PINCTRL_MUXSEL5_BANK2_PIN18 0x00000030
#define BF_PINCTRL_MUXSEL5_BANK2_PIN18(v)  \
	(((v) << 4) & BM_PINCTRL_MUXSEL5_BANK2_PIN18)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN17      2
#define BM_PINCTRL_MUXSEL5_BANK2_PIN17 0x0000000C
#define BF_PINCTRL_MUXSEL5_BANK2_PIN17(v)  \
	(((v) << 2) & BM_PINCTRL_MUXSEL5_BANK2_PIN17)
#define BP_PINCTRL_MUXSEL5_BANK2_PIN16      0
#define BM_PINCTRL_MUXSEL5_BANK2_PIN16 0x00000003
#define BF_PINCTRL_MUXSEL5_BANK2_PIN16(v)  \
	(((v) << 0) & BM_PINCTRL_MUXSEL5_BANK2_PIN16)
HW_REGISTER(HW_PINCTRL_MUXSEL6, REGS_PINCTRL_BASE, 0x00000160)
#define HW_PINCTRL_MUXSEL6_ADDR (REGS_PINCTRL_BASE + 0x00000160)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN15      30
#define BM_PINCTRL_MUXSEL6_BANK3_PIN15 0xC0000000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN15(v) \
	(((v) << 30) & BM_PINCTRL_MUXSEL6_BANK3_PIN15)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN14      28
#define BM_PINCTRL_MUXSEL6_BANK3_PIN14 0x30000000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN14(v)  \
	(((v) << 28) & BM_PINCTRL_MUXSEL6_BANK3_PIN14)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN13      26
#define BM_PINCTRL_MUXSEL6_BANK3_PIN13 0x0C000000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN13(v)  \
	(((v) << 26) & BM_PINCTRL_MUXSEL6_BANK3_PIN13)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN12      24
#define BM_PINCTRL_MUXSEL6_BANK3_PIN12 0x03000000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN12(v)  \
	(((v) << 24) & BM_PINCTRL_MUXSEL6_BANK3_PIN12)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN11      22
#define BM_PINCTRL_MUXSEL6_BANK3_PIN11 0x00C00000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN11(v)  \
	(((v) << 22) & BM_PINCTRL_MUXSEL6_BANK3_PIN11)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN10      20
#define BM_PINCTRL_MUXSEL6_BANK3_PIN10 0x00300000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN10(v)  \
	(((v) << 20) & BM_PINCTRL_MUXSEL6_BANK3_PIN10)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN09      18
#define BM_PINCTRL_MUXSEL6_BANK3_PIN09 0x000C0000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN09(v)  \
	(((v) << 18) & BM_PINCTRL_MUXSEL6_BANK3_PIN09)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN08      16
#define BM_PINCTRL_MUXSEL6_BANK3_PIN08 0x00030000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN08(v)  \
	(((v) << 16) & BM_PINCTRL_MUXSEL6_BANK3_PIN08)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN07      14
#define BM_PINCTRL_MUXSEL6_BANK3_PIN07 0x0000C000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN07(v)  \
	(((v) << 14) & BM_PINCTRL_MUXSEL6_BANK3_PIN07)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN06      12
#define BM_PINCTRL_MUXSEL6_BANK3_PIN06 0x00003000
#define BF_PINCTRL_MUXSEL6_BANK3_PIN06(v)  \
	(((v) << 12) & BM_PINCTRL_MUXSEL6_BANK3_PIN06)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN05      10
#define BM_PINCTRL_MUXSEL6_BANK3_PIN05 0x00000C00
#define BF_PINCTRL_MUXSEL6_BANK3_PIN05(v)  \
	(((v) << 10) & BM_PINCTRL_MUXSEL6_BANK3_PIN05)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN04      8
#define BM_PINCTRL_MUXSEL6_BANK3_PIN04 0x00000300
#define BF_PINCTRL_MUXSEL6_BANK3_PIN04(v)  \
	(((v) << 8) & BM_PINCTRL_MUXSEL6_BANK3_PIN04)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN03      6
#define BM_PINCTRL_MUXSEL6_BANK3_PIN03 0x000000C0
#define BF_PINCTRL_MUXSEL6_BANK3_PIN03(v)  \
	(((v) << 6) & BM_PINCTRL_MUXSEL6_BANK3_PIN03)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN02      4
#define BM_PINCTRL_MUXSEL6_BANK3_PIN02 0x00000030
#define BF_PINCTRL_MUXSEL6_BANK3_PIN02(v)  \
	(((v) << 4) & BM_PINCTRL_MUXSEL6_BANK3_PIN02)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN01      2
#define BM_PINCTRL_MUXSEL6_BANK3_PIN01 0x0000000C
#define BF_PINCTRL_MUXSEL6_BANK3_PIN01(v)  \
	(((v) << 2) & BM_PINCTRL_MUXSEL6_BANK3_PIN01)
#define BP_PINCTRL_MUXSEL6_BANK3_PIN00      0
#define BM_PINCTRL_MUXSEL6_BANK3_PIN00 0x00000003
#define BF_PINCTRL_MUXSEL6_BANK3_PIN00(v)  \
	(((v) << 0) & BM_PINCTRL_MUXSEL6_BANK3_PIN00)
HW_REGISTER(HW_PINCTRL_MUXSEL7, REGS_PINCTRL_BASE, 0x00000170)
#define HW_PINCTRL_MUXSEL7_ADDR (REGS_PINCTRL_BASE + 0x00000170)
#define BP_PINCTRL_MUXSEL7_BANK3_PIN21      10
#define BM_PINCTRL_MUXSEL7_BANK3_PIN21 0x00000C00
#define BF_PINCTRL_MUXSEL7_BANK3_PIN21(v)  \
	(((v) << 10) & BM_PINCTRL_MUXSEL7_BANK3_PIN21)
#define BP_PINCTRL_MUXSEL7_BANK3_PIN20      8
#define BM_PINCTRL_MUXSEL7_BANK3_PIN20 0x00000300
#define BF_PINCTRL_MUXSEL7_BANK3_PIN20(v)  \
	(((v) << 8) & BM_PINCTRL_MUXSEL7_BANK3_PIN20)
#define BP_PINCTRL_MUXSEL7_BANK3_PIN19      6
#define BM_PINCTRL_MUXSEL7_BANK3_PIN19 0x000000C0
#define BF_PINCTRL_MUXSEL7_BANK3_PIN19(v)  \
	(((v) << 6) & BM_PINCTRL_MUXSEL7_BANK3_PIN19)
#define BP_PINCTRL_MUXSEL7_BANK3_PIN18      4
#define BM_PINCTRL_MUXSEL7_BANK3_PIN18 0x00000030
#define BF_PINCTRL_MUXSEL7_BANK3_PIN18(v)  \
	(((v) << 4) & BM_PINCTRL_MUXSEL7_BANK3_PIN18)
#define BP_PINCTRL_MUXSEL7_BANK3_PIN17      2
#define BM_PINCTRL_MUXSEL7_BANK3_PIN17 0x0000000C
#define BF_PINCTRL_MUXSEL7_BANK3_PIN17(v)  \
	(((v) << 2) & BM_PINCTRL_MUXSEL7_BANK3_PIN17)
#define BP_PINCTRL_MUXSEL7_BANK3_PIN16      0
#define BM_PINCTRL_MUXSEL7_BANK3_PIN16 0x00000003
#define BF_PINCTRL_MUXSEL7_BANK3_PIN16(v)  \
	(((v) << 0) & BM_PINCTRL_MUXSEL7_BANK3_PIN16)
HW_REGISTER(HW_PINCTRL_DRIVE0, REGS_PINCTRL_BASE, 0x00000200)
#define HW_PINCTRL_DRIVE0_ADDR (REGS_PINCTRL_BASE + 0x00000200)
#define BP_PINCTRL_DRIVE0_BANK0_PIN07_MA      28
#define BM_PINCTRL_DRIVE0_BANK0_PIN07_MA 0x30000000
#define BF_PINCTRL_DRIVE0_BANK0_PIN07_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE0_BANK0_PIN07_MA)
#define BP_PINCTRL_DRIVE0_BANK0_PIN06_MA      24
#define BM_PINCTRL_DRIVE0_BANK0_PIN06_MA 0x03000000
#define BF_PINCTRL_DRIVE0_BANK0_PIN06_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE0_BANK0_PIN06_MA)
#define BP_PINCTRL_DRIVE0_BANK0_PIN05_MA      20
#define BM_PINCTRL_DRIVE0_BANK0_PIN05_MA 0x00300000
#define BF_PINCTRL_DRIVE0_BANK0_PIN05_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE0_BANK0_PIN05_MA)
#define BP_PINCTRL_DRIVE0_BANK0_PIN04_MA      16
#define BM_PINCTRL_DRIVE0_BANK0_PIN04_MA 0x00030000
#define BF_PINCTRL_DRIVE0_BANK0_PIN04_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE0_BANK0_PIN04_MA)
#define BP_PINCTRL_DRIVE0_BANK0_PIN03_MA      12
#define BM_PINCTRL_DRIVE0_BANK0_PIN03_MA 0x00003000
#define BF_PINCTRL_DRIVE0_BANK0_PIN03_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE0_BANK0_PIN03_MA)
#define BP_PINCTRL_DRIVE0_BANK0_PIN02_MA      8
#define BM_PINCTRL_DRIVE0_BANK0_PIN02_MA 0x00000300
#define BF_PINCTRL_DRIVE0_BANK0_PIN02_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE0_BANK0_PIN02_MA)
#define BP_PINCTRL_DRIVE0_BANK0_PIN01_MA      4
#define BM_PINCTRL_DRIVE0_BANK0_PIN01_MA 0x00000030
#define BF_PINCTRL_DRIVE0_BANK0_PIN01_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE0_BANK0_PIN01_MA)
#define BP_PINCTRL_DRIVE0_BANK0_PIN00_MA      0
#define BM_PINCTRL_DRIVE0_BANK0_PIN00_MA 0x00000003
#define BF_PINCTRL_DRIVE0_BANK0_PIN00_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE0_BANK0_PIN00_MA)
HW_REGISTER(HW_PINCTRL_DRIVE1, REGS_PINCTRL_BASE, 0x00000210)
#define HW_PINCTRL_DRIVE1_ADDR (REGS_PINCTRL_BASE + 0x00000210)
#define BP_PINCTRL_DRIVE1_BANK0_PIN15_MA      28
#define BM_PINCTRL_DRIVE1_BANK0_PIN15_MA 0x30000000
#define BF_PINCTRL_DRIVE1_BANK0_PIN15_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE1_BANK0_PIN15_MA)
#define BP_PINCTRL_DRIVE1_BANK0_PIN14_MA      24
#define BM_PINCTRL_DRIVE1_BANK0_PIN14_MA 0x03000000
#define BF_PINCTRL_DRIVE1_BANK0_PIN14_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE1_BANK0_PIN14_MA)
#define BP_PINCTRL_DRIVE1_BANK0_PIN13_MA      20
#define BM_PINCTRL_DRIVE1_BANK0_PIN13_MA 0x00300000
#define BF_PINCTRL_DRIVE1_BANK0_PIN13_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE1_BANK0_PIN13_MA)
#define BP_PINCTRL_DRIVE1_BANK0_PIN12_MA      16
#define BM_PINCTRL_DRIVE1_BANK0_PIN12_MA 0x00030000
#define BF_PINCTRL_DRIVE1_BANK0_PIN12_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE1_BANK0_PIN12_MA)
#define BP_PINCTRL_DRIVE1_BANK0_PIN11_MA      12
#define BM_PINCTRL_DRIVE1_BANK0_PIN11_MA 0x00003000
#define BF_PINCTRL_DRIVE1_BANK0_PIN11_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE1_BANK0_PIN11_MA)
#define BP_PINCTRL_DRIVE1_BANK0_PIN10_MA      8
#define BM_PINCTRL_DRIVE1_BANK0_PIN10_MA 0x00000300
#define BF_PINCTRL_DRIVE1_BANK0_PIN10_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE1_BANK0_PIN10_MA)
#define BP_PINCTRL_DRIVE1_BANK0_PIN09_MA      4
#define BM_PINCTRL_DRIVE1_BANK0_PIN09_MA 0x00000030
#define BF_PINCTRL_DRIVE1_BANK0_PIN09_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE1_BANK0_PIN09_MA)
#define BP_PINCTRL_DRIVE1_BANK0_PIN08_MA      0
#define BM_PINCTRL_DRIVE1_BANK0_PIN08_MA 0x00000003
#define BF_PINCTRL_DRIVE1_BANK0_PIN08_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE1_BANK0_PIN08_MA)
HW_REGISTER(HW_PINCTRL_DRIVE2, REGS_PINCTRL_BASE, 0x00000220)
#define HW_PINCTRL_DRIVE2_ADDR (REGS_PINCTRL_BASE + 0x00000220)
#define BP_PINCTRL_DRIVE2_BANK0_PIN23_MA      28
#define BM_PINCTRL_DRIVE2_BANK0_PIN23_MA 0x30000000
#define BF_PINCTRL_DRIVE2_BANK0_PIN23_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE2_BANK0_PIN23_MA)
#define BP_PINCTRL_DRIVE2_BANK0_PIN22_MA      24
#define BM_PINCTRL_DRIVE2_BANK0_PIN22_MA 0x03000000
#define BF_PINCTRL_DRIVE2_BANK0_PIN22_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE2_BANK0_PIN22_MA)
#define BP_PINCTRL_DRIVE2_BANK0_PIN21_MA      20
#define BM_PINCTRL_DRIVE2_BANK0_PIN21_MA 0x00300000
#define BF_PINCTRL_DRIVE2_BANK0_PIN21_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE2_BANK0_PIN21_MA)
#define BP_PINCTRL_DRIVE2_BANK0_PIN20_MA      16
#define BM_PINCTRL_DRIVE2_BANK0_PIN20_MA 0x00030000
#define BF_PINCTRL_DRIVE2_BANK0_PIN20_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE2_BANK0_PIN20_MA)
#define BP_PINCTRL_DRIVE2_BANK0_PIN19_MA      12
#define BM_PINCTRL_DRIVE2_BANK0_PIN19_MA 0x00003000
#define BF_PINCTRL_DRIVE2_BANK0_PIN19_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE2_BANK0_PIN19_MA)
#define BP_PINCTRL_DRIVE2_BANK0_PIN18_MA      8
#define BM_PINCTRL_DRIVE2_BANK0_PIN18_MA 0x00000300
#define BF_PINCTRL_DRIVE2_BANK0_PIN18_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE2_BANK0_PIN18_MA)
#define BP_PINCTRL_DRIVE2_BANK0_PIN17_MA      4
#define BM_PINCTRL_DRIVE2_BANK0_PIN17_MA 0x00000030
#define BF_PINCTRL_DRIVE2_BANK0_PIN17_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE2_BANK0_PIN17_MA)
#define BP_PINCTRL_DRIVE2_BANK0_PIN16_MA      0
#define BM_PINCTRL_DRIVE2_BANK0_PIN16_MA 0x00000003
#define BF_PINCTRL_DRIVE2_BANK0_PIN16_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE2_BANK0_PIN16_MA)
HW_REGISTER(HW_PINCTRL_DRIVE3, REGS_PINCTRL_BASE, 0x00000230)
#define HW_PINCTRL_DRIVE3_ADDR (REGS_PINCTRL_BASE + 0x00000230)
#define BP_PINCTRL_DRIVE3_BANK0_PIN31_MA      28
#define BM_PINCTRL_DRIVE3_BANK0_PIN31_MA 0x30000000
#define BF_PINCTRL_DRIVE3_BANK0_PIN31_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE3_BANK0_PIN31_MA)
#define BP_PINCTRL_DRIVE3_BANK0_PIN30_MA      24
#define BM_PINCTRL_DRIVE3_BANK0_PIN30_MA 0x03000000
#define BF_PINCTRL_DRIVE3_BANK0_PIN30_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE3_BANK0_PIN30_MA)
#define BP_PINCTRL_DRIVE3_BANK0_PIN29_MA      20
#define BM_PINCTRL_DRIVE3_BANK0_PIN29_MA 0x00300000
#define BF_PINCTRL_DRIVE3_BANK0_PIN29_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE3_BANK0_PIN29_MA)
#define BP_PINCTRL_DRIVE3_BANK0_PIN28_MA      16
#define BM_PINCTRL_DRIVE3_BANK0_PIN28_MA 0x00030000
#define BF_PINCTRL_DRIVE3_BANK0_PIN28_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE3_BANK0_PIN28_MA)
#define BP_PINCTRL_DRIVE3_BANK0_PIN27_MA      12
#define BM_PINCTRL_DRIVE3_BANK0_PIN27_MA 0x00003000
#define BF_PINCTRL_DRIVE3_BANK0_PIN27_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE3_BANK0_PIN27_MA)
#define BP_PINCTRL_DRIVE3_BANK0_PIN26_MA      8
#define BM_PINCTRL_DRIVE3_BANK0_PIN26_MA 0x00000300
#define BF_PINCTRL_DRIVE3_BANK0_PIN26_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE3_BANK0_PIN26_MA)
#define BP_PINCTRL_DRIVE3_BANK0_PIN25_MA      4
#define BM_PINCTRL_DRIVE3_BANK0_PIN25_MA 0x00000030
#define BF_PINCTRL_DRIVE3_BANK0_PIN25_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE3_BANK0_PIN25_MA)
#define BP_PINCTRL_DRIVE3_BANK0_PIN24_MA      0
#define BM_PINCTRL_DRIVE3_BANK0_PIN24_MA 0x00000003
#define BF_PINCTRL_DRIVE3_BANK0_PIN24_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE3_BANK0_PIN24_MA)
HW_REGISTER(HW_PINCTRL_DRIVE4, REGS_PINCTRL_BASE, 0x00000240)
#define HW_PINCTRL_DRIVE4_ADDR (REGS_PINCTRL_BASE + 0x00000240)
#define BP_PINCTRL_DRIVE4_BANK1_PIN07_MA      28
#define BM_PINCTRL_DRIVE4_BANK1_PIN07_MA 0x30000000
#define BF_PINCTRL_DRIVE4_BANK1_PIN07_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE4_BANK1_PIN07_MA)
#define BP_PINCTRL_DRIVE4_BANK1_PIN06_MA      24
#define BM_PINCTRL_DRIVE4_BANK1_PIN06_MA 0x03000000
#define BF_PINCTRL_DRIVE4_BANK1_PIN06_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE4_BANK1_PIN06_MA)
#define BP_PINCTRL_DRIVE4_BANK1_PIN05_MA      20
#define BM_PINCTRL_DRIVE4_BANK1_PIN05_MA 0x00300000
#define BF_PINCTRL_DRIVE4_BANK1_PIN05_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE4_BANK1_PIN05_MA)
#define BP_PINCTRL_DRIVE4_BANK1_PIN04_MA      16
#define BM_PINCTRL_DRIVE4_BANK1_PIN04_MA 0x00030000
#define BF_PINCTRL_DRIVE4_BANK1_PIN04_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE4_BANK1_PIN04_MA)
#define BP_PINCTRL_DRIVE4_BANK1_PIN03_MA      12
#define BM_PINCTRL_DRIVE4_BANK1_PIN03_MA 0x00003000
#define BF_PINCTRL_DRIVE4_BANK1_PIN03_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE4_BANK1_PIN03_MA)
#define BP_PINCTRL_DRIVE4_BANK1_PIN02_MA      8
#define BM_PINCTRL_DRIVE4_BANK1_PIN02_MA 0x00000300
#define BF_PINCTRL_DRIVE4_BANK1_PIN02_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE4_BANK1_PIN02_MA)
#define BP_PINCTRL_DRIVE4_BANK1_PIN01_MA      4
#define BM_PINCTRL_DRIVE4_BANK1_PIN01_MA 0x00000030
#define BF_PINCTRL_DRIVE4_BANK1_PIN01_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE4_BANK1_PIN01_MA)
#define BP_PINCTRL_DRIVE4_BANK1_PIN00_MA      0
#define BM_PINCTRL_DRIVE4_BANK1_PIN00_MA 0x00000003
#define BF_PINCTRL_DRIVE4_BANK1_PIN00_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE4_BANK1_PIN00_MA)
HW_REGISTER(HW_PINCTRL_DRIVE5, REGS_PINCTRL_BASE, 0x00000250)
#define HW_PINCTRL_DRIVE5_ADDR (REGS_PINCTRL_BASE + 0x00000250)
#define BP_PINCTRL_DRIVE5_BANK1_PIN15_MA      28
#define BM_PINCTRL_DRIVE5_BANK1_PIN15_MA 0x30000000
#define BF_PINCTRL_DRIVE5_BANK1_PIN15_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE5_BANK1_PIN15_MA)
#define BP_PINCTRL_DRIVE5_BANK1_PIN14_MA      24
#define BM_PINCTRL_DRIVE5_BANK1_PIN14_MA 0x03000000
#define BF_PINCTRL_DRIVE5_BANK1_PIN14_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE5_BANK1_PIN14_MA)
#define BP_PINCTRL_DRIVE5_BANK1_PIN13_MA      20
#define BM_PINCTRL_DRIVE5_BANK1_PIN13_MA 0x00300000
#define BF_PINCTRL_DRIVE5_BANK1_PIN13_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE5_BANK1_PIN13_MA)
#define BP_PINCTRL_DRIVE5_BANK1_PIN12_MA      16
#define BM_PINCTRL_DRIVE5_BANK1_PIN12_MA 0x00030000
#define BF_PINCTRL_DRIVE5_BANK1_PIN12_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE5_BANK1_PIN12_MA)
#define BP_PINCTRL_DRIVE5_BANK1_PIN11_MA      12
#define BM_PINCTRL_DRIVE5_BANK1_PIN11_MA 0x00003000
#define BF_PINCTRL_DRIVE5_BANK1_PIN11_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE5_BANK1_PIN11_MA)
#define BP_PINCTRL_DRIVE5_BANK1_PIN10_MA      8
#define BM_PINCTRL_DRIVE5_BANK1_PIN10_MA 0x00000300
#define BF_PINCTRL_DRIVE5_BANK1_PIN10_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE5_BANK1_PIN10_MA)
#define BP_PINCTRL_DRIVE5_BANK1_PIN09_MA      4
#define BM_PINCTRL_DRIVE5_BANK1_PIN09_MA 0x00000030
#define BF_PINCTRL_DRIVE5_BANK1_PIN09_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE5_BANK1_PIN09_MA)
#define BP_PINCTRL_DRIVE5_BANK1_PIN08_MA      0
#define BM_PINCTRL_DRIVE5_BANK1_PIN08_MA 0x00000003
#define BF_PINCTRL_DRIVE5_BANK1_PIN08_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE5_BANK1_PIN08_MA)
HW_REGISTER(HW_PINCTRL_DRIVE6, REGS_PINCTRL_BASE, 0x00000260)
#define HW_PINCTRL_DRIVE6_ADDR (REGS_PINCTRL_BASE + 0x00000260)
#define BP_PINCTRL_DRIVE6_BANK1_PIN23_MA      28
#define BM_PINCTRL_DRIVE6_BANK1_PIN23_MA 0x30000000
#define BF_PINCTRL_DRIVE6_BANK1_PIN23_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE6_BANK1_PIN23_MA)
#define BP_PINCTRL_DRIVE6_BANK1_PIN22_MA      24
#define BM_PINCTRL_DRIVE6_BANK1_PIN22_MA 0x03000000
#define BF_PINCTRL_DRIVE6_BANK1_PIN22_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE6_BANK1_PIN22_MA)
#define BP_PINCTRL_DRIVE6_BANK1_PIN21_MA      20
#define BM_PINCTRL_DRIVE6_BANK1_PIN21_MA 0x00300000
#define BF_PINCTRL_DRIVE6_BANK1_PIN21_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE6_BANK1_PIN21_MA)
#define BP_PINCTRL_DRIVE6_BANK1_PIN20_MA      16
#define BM_PINCTRL_DRIVE6_BANK1_PIN20_MA 0x00030000
#define BF_PINCTRL_DRIVE6_BANK1_PIN20_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE6_BANK1_PIN20_MA)
#define BP_PINCTRL_DRIVE6_BANK1_PIN19_MA      12
#define BM_PINCTRL_DRIVE6_BANK1_PIN19_MA 0x00003000
#define BF_PINCTRL_DRIVE6_BANK1_PIN19_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE6_BANK1_PIN19_MA)
#define BP_PINCTRL_DRIVE6_BANK1_PIN18_MA      8
#define BM_PINCTRL_DRIVE6_BANK1_PIN18_MA 0x00000300
#define BF_PINCTRL_DRIVE6_BANK1_PIN18_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE6_BANK1_PIN18_MA)
#define BP_PINCTRL_DRIVE6_BANK1_PIN17_MA      4
#define BM_PINCTRL_DRIVE6_BANK1_PIN17_MA 0x00000030
#define BF_PINCTRL_DRIVE6_BANK1_PIN17_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE6_BANK1_PIN17_MA)
#define BP_PINCTRL_DRIVE6_BANK1_PIN16_MA      0
#define BM_PINCTRL_DRIVE6_BANK1_PIN16_MA 0x00000003
#define BF_PINCTRL_DRIVE6_BANK1_PIN16_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE6_BANK1_PIN16_MA)
HW_REGISTER(HW_PINCTRL_DRIVE7, REGS_PINCTRL_BASE, 0x00000270)
#define HW_PINCTRL_DRIVE7_ADDR (REGS_PINCTRL_BASE + 0x00000270)
#define BP_PINCTRL_DRIVE7_BANK1_PIN30_MA      24
#define BM_PINCTRL_DRIVE7_BANK1_PIN30_MA 0x03000000
#define BF_PINCTRL_DRIVE7_BANK1_PIN30_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE7_BANK1_PIN30_MA)
#define BP_PINCTRL_DRIVE7_BANK1_PIN29_MA      20
#define BM_PINCTRL_DRIVE7_BANK1_PIN29_MA 0x00300000
#define BF_PINCTRL_DRIVE7_BANK1_PIN29_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE7_BANK1_PIN29_MA)
#define BP_PINCTRL_DRIVE7_BANK1_PIN28_MA      16
#define BM_PINCTRL_DRIVE7_BANK1_PIN28_MA 0x00030000
#define BF_PINCTRL_DRIVE7_BANK1_PIN28_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE7_BANK1_PIN28_MA)
#define BP_PINCTRL_DRIVE7_BANK1_PIN27_MA      12
#define BM_PINCTRL_DRIVE7_BANK1_PIN27_MA 0x00003000
#define BF_PINCTRL_DRIVE7_BANK1_PIN27_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE7_BANK1_PIN27_MA)
#define BP_PINCTRL_DRIVE7_BANK1_PIN26_MA      8
#define BM_PINCTRL_DRIVE7_BANK1_PIN26_MA 0x00000300
#define BF_PINCTRL_DRIVE7_BANK1_PIN26_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE7_BANK1_PIN26_MA)
#define BP_PINCTRL_DRIVE7_BANK1_PIN25_MA      4
#define BM_PINCTRL_DRIVE7_BANK1_PIN25_MA 0x00000030
#define BF_PINCTRL_DRIVE7_BANK1_PIN25_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE7_BANK1_PIN25_MA)
#define BP_PINCTRL_DRIVE7_BANK1_PIN24_MA      0
#define BM_PINCTRL_DRIVE7_BANK1_PIN24_MA 0x00000003
#define BF_PINCTRL_DRIVE7_BANK1_PIN24_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE7_BANK1_PIN24_MA)
HW_REGISTER(HW_PINCTRL_DRIVE8, REGS_PINCTRL_BASE, 0x00000280)
#define HW_PINCTRL_DRIVE8_ADDR (REGS_PINCTRL_BASE + 0x00000280)
#define BP_PINCTRL_DRIVE8_BANK2_PIN07_MA      28
#define BM_PINCTRL_DRIVE8_BANK2_PIN07_MA 0x30000000
#define BF_PINCTRL_DRIVE8_BANK2_PIN07_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE8_BANK2_PIN07_MA)
#define BP_PINCTRL_DRIVE8_BANK2_PIN06_MA      24
#define BM_PINCTRL_DRIVE8_BANK2_PIN06_MA 0x03000000
#define BF_PINCTRL_DRIVE8_BANK2_PIN06_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE8_BANK2_PIN06_MA)
#define BP_PINCTRL_DRIVE8_BANK2_PIN05_MA      20
#define BM_PINCTRL_DRIVE8_BANK2_PIN05_MA 0x00300000
#define BF_PINCTRL_DRIVE8_BANK2_PIN05_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE8_BANK2_PIN05_MA)
#define BP_PINCTRL_DRIVE8_BANK2_PIN04_MA      16
#define BM_PINCTRL_DRIVE8_BANK2_PIN04_MA 0x00030000
#define BF_PINCTRL_DRIVE8_BANK2_PIN04_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE8_BANK2_PIN04_MA)
#define BP_PINCTRL_DRIVE8_BANK2_PIN03_MA      12
#define BM_PINCTRL_DRIVE8_BANK2_PIN03_MA 0x00003000
#define BF_PINCTRL_DRIVE8_BANK2_PIN03_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE8_BANK2_PIN03_MA)
#define BP_PINCTRL_DRIVE8_BANK2_PIN02_MA      8
#define BM_PINCTRL_DRIVE8_BANK2_PIN02_MA 0x00000300
#define BF_PINCTRL_DRIVE8_BANK2_PIN02_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE8_BANK2_PIN02_MA)
#define BP_PINCTRL_DRIVE8_BANK2_PIN01_MA      4
#define BM_PINCTRL_DRIVE8_BANK2_PIN01_MA 0x00000030
#define BF_PINCTRL_DRIVE8_BANK2_PIN01_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE8_BANK2_PIN01_MA)
#define BP_PINCTRL_DRIVE8_BANK2_PIN00_MA      0
#define BM_PINCTRL_DRIVE8_BANK2_PIN00_MA 0x00000003
#define BF_PINCTRL_DRIVE8_BANK2_PIN00_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE8_BANK2_PIN00_MA)
HW_REGISTER(HW_PINCTRL_DRIVE9, REGS_PINCTRL_BASE, 0x00000290)
#define HW_PINCTRL_DRIVE9_ADDR (REGS_PINCTRL_BASE + 0x00000290)
#define BM_PINCTRL_DRIVE9_BANK2_PIN15_V 0x40000000
#define BP_PINCTRL_DRIVE9_BANK2_PIN15_MA      28
#define BM_PINCTRL_DRIVE9_BANK2_PIN15_MA 0x30000000
#define BF_PINCTRL_DRIVE9_BANK2_PIN15_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE9_BANK2_PIN15_MA)
#define BM_PINCTRL_DRIVE9_BANK2_PIN14_V 0x04000000
#define BP_PINCTRL_DRIVE9_BANK2_PIN14_MA      24
#define BM_PINCTRL_DRIVE9_BANK2_PIN14_MA 0x03000000
#define BF_PINCTRL_DRIVE9_BANK2_PIN14_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE9_BANK2_PIN14_MA)
#define BM_PINCTRL_DRIVE9_BANK2_PIN13_V 0x00400000
#define BP_PINCTRL_DRIVE9_BANK2_PIN13_MA      20
#define BM_PINCTRL_DRIVE9_BANK2_PIN13_MA 0x00300000
#define BF_PINCTRL_DRIVE9_BANK2_PIN13_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE9_BANK2_PIN13_MA)
#define BM_PINCTRL_DRIVE9_BANK2_PIN12_V 0x00040000
#define BP_PINCTRL_DRIVE9_BANK2_PIN12_MA      16
#define BM_PINCTRL_DRIVE9_BANK2_PIN12_MA 0x00030000
#define BF_PINCTRL_DRIVE9_BANK2_PIN12_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE9_BANK2_PIN12_MA)
#define BM_PINCTRL_DRIVE9_BANK2_PIN11_V 0x00004000
#define BP_PINCTRL_DRIVE9_BANK2_PIN11_MA      12
#define BM_PINCTRL_DRIVE9_BANK2_PIN11_MA 0x00003000
#define BF_PINCTRL_DRIVE9_BANK2_PIN11_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE9_BANK2_PIN11_MA)
#define BM_PINCTRL_DRIVE9_BANK2_PIN10_V 0x00000400
#define BP_PINCTRL_DRIVE9_BANK2_PIN10_MA      8
#define BM_PINCTRL_DRIVE9_BANK2_PIN10_MA 0x00000300
#define BF_PINCTRL_DRIVE9_BANK2_PIN10_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE9_BANK2_PIN10_MA)
#define BM_PINCTRL_DRIVE9_BANK2_PIN09_V 0x00000040
#define BP_PINCTRL_DRIVE9_BANK2_PIN09_MA      4
#define BM_PINCTRL_DRIVE9_BANK2_PIN09_MA 0x00000030
#define BF_PINCTRL_DRIVE9_BANK2_PIN09_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE9_BANK2_PIN09_MA)
#define BP_PINCTRL_DRIVE9_BANK2_PIN08_MA      0
#define BM_PINCTRL_DRIVE9_BANK2_PIN08_MA 0x00000003
#define BF_PINCTRL_DRIVE9_BANK2_PIN08_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE9_BANK2_PIN08_MA)
HW_REGISTER(HW_PINCTRL_DRIVE10, REGS_PINCTRL_BASE, 0x000002a0)
#define HW_PINCTRL_DRIVE10_ADDR (REGS_PINCTRL_BASE + 0x000002a0)
#define BM_PINCTRL_DRIVE10_BANK2_PIN23_V 0x40000000
#define BP_PINCTRL_DRIVE10_BANK2_PIN23_MA      28
#define BM_PINCTRL_DRIVE10_BANK2_PIN23_MA 0x30000000
#define BF_PINCTRL_DRIVE10_BANK2_PIN23_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE10_BANK2_PIN23_MA)
#define BM_PINCTRL_DRIVE10_BANK2_PIN22_V 0x04000000
#define BP_PINCTRL_DRIVE10_BANK2_PIN22_MA      24
#define BM_PINCTRL_DRIVE10_BANK2_PIN22_MA 0x03000000
#define BF_PINCTRL_DRIVE10_BANK2_PIN22_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE10_BANK2_PIN22_MA)
#define BM_PINCTRL_DRIVE10_BANK2_PIN21_V 0x00400000
#define BP_PINCTRL_DRIVE10_BANK2_PIN21_MA      20
#define BM_PINCTRL_DRIVE10_BANK2_PIN21_MA 0x00300000
#define BF_PINCTRL_DRIVE10_BANK2_PIN21_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE10_BANK2_PIN21_MA)
#define BM_PINCTRL_DRIVE10_BANK2_PIN20_V 0x00040000
#define BP_PINCTRL_DRIVE10_BANK2_PIN20_MA      16
#define BM_PINCTRL_DRIVE10_BANK2_PIN20_MA 0x00030000
#define BF_PINCTRL_DRIVE10_BANK2_PIN20_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE10_BANK2_PIN20_MA)
#define BM_PINCTRL_DRIVE10_BANK2_PIN19_V 0x00004000
#define BP_PINCTRL_DRIVE10_BANK2_PIN19_MA      12
#define BM_PINCTRL_DRIVE10_BANK2_PIN19_MA 0x00003000
#define BF_PINCTRL_DRIVE10_BANK2_PIN19_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE10_BANK2_PIN19_MA)
#define BM_PINCTRL_DRIVE10_BANK2_PIN18_V 0x00000400
#define BP_PINCTRL_DRIVE10_BANK2_PIN18_MA      8
#define BM_PINCTRL_DRIVE10_BANK2_PIN18_MA 0x00000300
#define BF_PINCTRL_DRIVE10_BANK2_PIN18_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE10_BANK2_PIN18_MA)
#define BM_PINCTRL_DRIVE10_BANK2_PIN17_V 0x00000040
#define BP_PINCTRL_DRIVE10_BANK2_PIN17_MA      4
#define BM_PINCTRL_DRIVE10_BANK2_PIN17_MA 0x00000030
#define BF_PINCTRL_DRIVE10_BANK2_PIN17_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE10_BANK2_PIN17_MA)
#define BM_PINCTRL_DRIVE10_BANK2_PIN16_V 0x00000004
#define BP_PINCTRL_DRIVE10_BANK2_PIN16_MA      0
#define BM_PINCTRL_DRIVE10_BANK2_PIN16_MA 0x00000003
#define BF_PINCTRL_DRIVE10_BANK2_PIN16_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE10_BANK2_PIN16_MA)
HW_REGISTER(HW_PINCTRL_DRIVE11, REGS_PINCTRL_BASE, 0x000002b0)
#define HW_PINCTRL_DRIVE11_ADDR (REGS_PINCTRL_BASE + 0x000002b0)
#define BM_PINCTRL_DRIVE11_BANK2_PIN31_V 0x40000000
#define BP_PINCTRL_DRIVE11_BANK2_PIN31_MA      28
#define BM_PINCTRL_DRIVE11_BANK2_PIN31_MA 0x30000000
#define BF_PINCTRL_DRIVE11_BANK2_PIN31_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE11_BANK2_PIN31_MA)
#define BM_PINCTRL_DRIVE11_BANK2_PIN30_V 0x04000000
#define BP_PINCTRL_DRIVE11_BANK2_PIN30_MA      24
#define BM_PINCTRL_DRIVE11_BANK2_PIN30_MA 0x03000000
#define BF_PINCTRL_DRIVE11_BANK2_PIN30_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE11_BANK2_PIN30_MA)
#define BM_PINCTRL_DRIVE11_BANK2_PIN29_V 0x00400000
#define BP_PINCTRL_DRIVE11_BANK2_PIN29_MA      20
#define BM_PINCTRL_DRIVE11_BANK2_PIN29_MA 0x00300000
#define BF_PINCTRL_DRIVE11_BANK2_PIN29_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE11_BANK2_PIN29_MA)
#define BP_PINCTRL_DRIVE11_BANK2_PIN28_MA      16
#define BM_PINCTRL_DRIVE11_BANK2_PIN28_MA 0x00030000
#define BF_PINCTRL_DRIVE11_BANK2_PIN28_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE11_BANK2_PIN28_MA)
#define BP_PINCTRL_DRIVE11_BANK2_PIN27_MA      12
#define BM_PINCTRL_DRIVE11_BANK2_PIN27_MA 0x00003000
#define BF_PINCTRL_DRIVE11_BANK2_PIN27_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE11_BANK2_PIN27_MA)
#define BM_PINCTRL_DRIVE11_BANK2_PIN26_V 0x00000400
#define BP_PINCTRL_DRIVE11_BANK2_PIN26_MA      8
#define BM_PINCTRL_DRIVE11_BANK2_PIN26_MA 0x00000300
#define BF_PINCTRL_DRIVE11_BANK2_PIN26_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE11_BANK2_PIN26_MA)
#define BM_PINCTRL_DRIVE11_BANK2_PIN25_V 0x00000040
#define BP_PINCTRL_DRIVE11_BANK2_PIN25_MA      4
#define BM_PINCTRL_DRIVE11_BANK2_PIN25_MA 0x00000030
#define BF_PINCTRL_DRIVE11_BANK2_PIN25_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE11_BANK2_PIN25_MA)
#define BM_PINCTRL_DRIVE11_BANK2_PIN24_V 0x00000004
#define BP_PINCTRL_DRIVE11_BANK2_PIN24_MA      0
#define BM_PINCTRL_DRIVE11_BANK2_PIN24_MA 0x00000003
#define BF_PINCTRL_DRIVE11_BANK2_PIN24_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE11_BANK2_PIN24_MA)
HW_REGISTER(HW_PINCTRL_DRIVE12, REGS_PINCTRL_BASE, 0x000002c0)
#define HW_PINCTRL_DRIVE12_ADDR (REGS_PINCTRL_BASE + 0x000002c0)
#define BM_PINCTRL_DRIVE12_BANK3_PIN07_V 0x40000000
#define BP_PINCTRL_DRIVE12_BANK3_PIN07_MA      28
#define BM_PINCTRL_DRIVE12_BANK3_PIN07_MA 0x30000000
#define BF_PINCTRL_DRIVE12_BANK3_PIN07_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE12_BANK3_PIN07_MA)
#define BM_PINCTRL_DRIVE12_BANK3_PIN06_V 0x04000000
#define BP_PINCTRL_DRIVE12_BANK3_PIN06_MA      24
#define BM_PINCTRL_DRIVE12_BANK3_PIN06_MA 0x03000000
#define BF_PINCTRL_DRIVE12_BANK3_PIN06_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE12_BANK3_PIN06_MA)
#define BM_PINCTRL_DRIVE12_BANK3_PIN05_V 0x00400000
#define BP_PINCTRL_DRIVE12_BANK3_PIN05_MA      20
#define BM_PINCTRL_DRIVE12_BANK3_PIN05_MA 0x00300000
#define BF_PINCTRL_DRIVE12_BANK3_PIN05_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE12_BANK3_PIN05_MA)
#define BM_PINCTRL_DRIVE12_BANK3_PIN04_V 0x00040000
#define BP_PINCTRL_DRIVE12_BANK3_PIN04_MA      16
#define BM_PINCTRL_DRIVE12_BANK3_PIN04_MA 0x00030000
#define BF_PINCTRL_DRIVE12_BANK3_PIN04_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE12_BANK3_PIN04_MA)
#define BM_PINCTRL_DRIVE12_BANK3_PIN03_V 0x00004000
#define BP_PINCTRL_DRIVE12_BANK3_PIN03_MA      12
#define BM_PINCTRL_DRIVE12_BANK3_PIN03_MA 0x00003000
#define BF_PINCTRL_DRIVE12_BANK3_PIN03_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE12_BANK3_PIN03_MA)
#define BM_PINCTRL_DRIVE12_BANK3_PIN02_V 0x00000400
#define BP_PINCTRL_DRIVE12_BANK3_PIN02_MA      8
#define BM_PINCTRL_DRIVE12_BANK3_PIN02_MA 0x00000300
#define BF_PINCTRL_DRIVE12_BANK3_PIN02_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE12_BANK3_PIN02_MA)
#define BM_PINCTRL_DRIVE12_BANK3_PIN01_V 0x00000040
#define BP_PINCTRL_DRIVE12_BANK3_PIN01_MA      4
#define BM_PINCTRL_DRIVE12_BANK3_PIN01_MA 0x00000030
#define BF_PINCTRL_DRIVE12_BANK3_PIN01_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE12_BANK3_PIN01_MA)
#define BM_PINCTRL_DRIVE12_BANK3_PIN00_V 0x00000004
#define BP_PINCTRL_DRIVE12_BANK3_PIN00_MA      0
#define BM_PINCTRL_DRIVE12_BANK3_PIN00_MA 0x00000003
#define BF_PINCTRL_DRIVE12_BANK3_PIN00_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE12_BANK3_PIN00_MA)
HW_REGISTER(HW_PINCTRL_DRIVE13, REGS_PINCTRL_BASE, 0x000002d0)
#define HW_PINCTRL_DRIVE13_ADDR (REGS_PINCTRL_BASE + 0x000002d0)
#define BM_PINCTRL_DRIVE13_BANK3_PIN15_V 0x40000000
#define BP_PINCTRL_DRIVE13_BANK3_PIN15_MA      28
#define BM_PINCTRL_DRIVE13_BANK3_PIN15_MA 0x30000000
#define BF_PINCTRL_DRIVE13_BANK3_PIN15_MA(v)  \
	(((v) << 28) & BM_PINCTRL_DRIVE13_BANK3_PIN15_MA)
#define BM_PINCTRL_DRIVE13_BANK3_PIN14_V 0x04000000
#define BP_PINCTRL_DRIVE13_BANK3_PIN14_MA      24
#define BM_PINCTRL_DRIVE13_BANK3_PIN14_MA 0x03000000
#define BF_PINCTRL_DRIVE13_BANK3_PIN14_MA(v)  \
	(((v) << 24) & BM_PINCTRL_DRIVE13_BANK3_PIN14_MA)
#define BM_PINCTRL_DRIVE13_BANK3_PIN13_V 0x00400000
#define BP_PINCTRL_DRIVE13_BANK3_PIN13_MA      20
#define BM_PINCTRL_DRIVE13_BANK3_PIN13_MA 0x00300000
#define BF_PINCTRL_DRIVE13_BANK3_PIN13_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE13_BANK3_PIN13_MA)
#define BM_PINCTRL_DRIVE13_BANK3_PIN12_V 0x00040000
#define BP_PINCTRL_DRIVE13_BANK3_PIN12_MA      16
#define BM_PINCTRL_DRIVE13_BANK3_PIN12_MA 0x00030000
#define BF_PINCTRL_DRIVE13_BANK3_PIN12_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE13_BANK3_PIN12_MA)
#define BM_PINCTRL_DRIVE13_BANK3_PIN11_V 0x00004000
#define BP_PINCTRL_DRIVE13_BANK3_PIN11_MA      12
#define BM_PINCTRL_DRIVE13_BANK3_PIN11_MA 0x00003000
#define BF_PINCTRL_DRIVE13_BANK3_PIN11_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE13_BANK3_PIN11_MA)
#define BM_PINCTRL_DRIVE13_BANK3_PIN10_V 0x00000400
#define BP_PINCTRL_DRIVE13_BANK3_PIN10_MA      8
#define BM_PINCTRL_DRIVE13_BANK3_PIN10_MA 0x00000300
#define BF_PINCTRL_DRIVE13_BANK3_PIN10_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE13_BANK3_PIN10_MA)
#define BM_PINCTRL_DRIVE13_BANK3_PIN09_V 0x00000040
#define BP_PINCTRL_DRIVE13_BANK3_PIN09_MA      4
#define BM_PINCTRL_DRIVE13_BANK3_PIN09_MA 0x00000030
#define BF_PINCTRL_DRIVE13_BANK3_PIN09_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE13_BANK3_PIN09_MA)
#define BM_PINCTRL_DRIVE13_BANK3_PIN08_V 0x00000004
#define BP_PINCTRL_DRIVE13_BANK3_PIN08_MA      0
#define BM_PINCTRL_DRIVE13_BANK3_PIN08_MA 0x00000003
#define BF_PINCTRL_DRIVE13_BANK3_PIN08_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE13_BANK3_PIN08_MA)
HW_REGISTER(HW_PINCTRL_DRIVE14, REGS_PINCTRL_BASE, 0x000002e0)
#define HW_PINCTRL_DRIVE14_ADDR (REGS_PINCTRL_BASE + 0x000002e0)
#define BM_PINCTRL_DRIVE14_BANK3_PIN21_V 0x00400000
#define BP_PINCTRL_DRIVE14_BANK3_PIN21_MA      20
#define BM_PINCTRL_DRIVE14_BANK3_PIN21_MA 0x00300000
#define BF_PINCTRL_DRIVE14_BANK3_PIN21_MA(v)  \
	(((v) << 20) & BM_PINCTRL_DRIVE14_BANK3_PIN21_MA)
#define BM_PINCTRL_DRIVE14_BANK3_PIN20_V 0x00040000
#define BP_PINCTRL_DRIVE14_BANK3_PIN20_MA      16
#define BM_PINCTRL_DRIVE14_BANK3_PIN20_MA 0x00030000
#define BF_PINCTRL_DRIVE14_BANK3_PIN20_MA(v)  \
	(((v) << 16) & BM_PINCTRL_DRIVE14_BANK3_PIN20_MA)
#define BM_PINCTRL_DRIVE14_BANK3_PIN19_V 0x00004000
#define BP_PINCTRL_DRIVE14_BANK3_PIN19_MA      12
#define BM_PINCTRL_DRIVE14_BANK3_PIN19_MA 0x00003000
#define BF_PINCTRL_DRIVE14_BANK3_PIN19_MA(v)  \
	(((v) << 12) & BM_PINCTRL_DRIVE14_BANK3_PIN19_MA)
#define BM_PINCTRL_DRIVE14_BANK3_PIN18_V 0x00000400
#define BP_PINCTRL_DRIVE14_BANK3_PIN18_MA      8
#define BM_PINCTRL_DRIVE14_BANK3_PIN18_MA 0x00000300
#define BF_PINCTRL_DRIVE14_BANK3_PIN18_MA(v)  \
	(((v) << 8) & BM_PINCTRL_DRIVE14_BANK3_PIN18_MA)
#define BM_PINCTRL_DRIVE14_BANK3_PIN17_V 0x00000040
#define BP_PINCTRL_DRIVE14_BANK3_PIN17_MA      4
#define BM_PINCTRL_DRIVE14_BANK3_PIN17_MA 0x00000030
#define BF_PINCTRL_DRIVE14_BANK3_PIN17_MA(v)  \
	(((v) << 4) & BM_PINCTRL_DRIVE14_BANK3_PIN17_MA)
#define BM_PINCTRL_DRIVE14_BANK3_PIN16_V 0x00000004
#define BP_PINCTRL_DRIVE14_BANK3_PIN16_MA      0
#define BM_PINCTRL_DRIVE14_BANK3_PIN16_MA 0x00000003
#define BF_PINCTRL_DRIVE14_BANK3_PIN16_MA(v)  \
	(((v) << 0) & BM_PINCTRL_DRIVE14_BANK3_PIN16_MA)
HW_REGISTER(HW_PINCTRL_PULL0, REGS_PINCTRL_BASE, 0x00000400)
#define HW_PINCTRL_PULL0_ADDR (REGS_PINCTRL_BASE + 0x00000400)
#define BM_PINCTRL_PULL0_BANK0_PIN31 0x80000000
#define BM_PINCTRL_PULL0_BANK0_PIN30 0x40000000
#define BM_PINCTRL_PULL0_BANK0_PIN29 0x20000000
#define BM_PINCTRL_PULL0_BANK0_PIN28 0x10000000
#define BM_PINCTRL_PULL0_BANK0_PIN27 0x08000000
#define BM_PINCTRL_PULL0_BANK0_PIN26 0x04000000
#define BM_PINCTRL_PULL0_BANK0_PIN22 0x00400000
#define BM_PINCTRL_PULL0_BANK0_PIN21 0x00200000
#define BM_PINCTRL_PULL0_BANK0_PIN20 0x00100000
#define BM_PINCTRL_PULL0_BANK0_PIN19 0x00080000
#define BM_PINCTRL_PULL0_BANK0_PIN18 0x00040000
#define BM_PINCTRL_PULL0_BANK0_PIN15 0x00008000
#define BM_PINCTRL_PULL0_BANK0_PIN11 0x00000800
#define BM_PINCTRL_PULL0_BANK0_PIN10 0x00000400
#define BM_PINCTRL_PULL0_BANK0_PIN09 0x00000200
#define BM_PINCTRL_PULL0_BANK0_PIN08 0x00000100
#define BM_PINCTRL_PULL0_BANK0_PIN07 0x00000080
#define BM_PINCTRL_PULL0_BANK0_PIN06 0x00000040
#define BM_PINCTRL_PULL0_BANK0_PIN05 0x00000020
#define BM_PINCTRL_PULL0_BANK0_PIN04 0x00000010
#define BM_PINCTRL_PULL0_BANK0_PIN03 0x00000008
#define BM_PINCTRL_PULL0_BANK0_PIN02 0x00000004
#define BM_PINCTRL_PULL0_BANK0_PIN01 0x00000002
#define BM_PINCTRL_PULL0_BANK0_PIN00 0x00000001
HW_REGISTER(HW_PINCTRL_PULL1, REGS_PINCTRL_BASE, 0x00000410)
#define HW_PINCTRL_PULL1_ADDR (REGS_PINCTRL_BASE + 0x00000410)
#define BM_PINCTRL_PULL1_BANK1_PIN28 0x10000000
#define BM_PINCTRL_PULL1_BANK1_PIN22 0x00400000
#define BM_PINCTRL_PULL1_BANK1_PIN18 0x00040000
HW_REGISTER(HW_PINCTRL_PULL2, REGS_PINCTRL_BASE, 0x00000420)
#define HW_PINCTRL_PULL2_ADDR (REGS_PINCTRL_BASE + 0x00000420)
#define BM_PINCTRL_PULL2_BANK2_PIN28 0x10000000
#define BM_PINCTRL_PULL2_BANK2_PIN27 0x08000000
#define BM_PINCTRL_PULL2_BANK2_PIN08 0x00000100
#define BM_PINCTRL_PULL2_BANK2_PIN05 0x00000020
#define BM_PINCTRL_PULL2_BANK2_PIN04 0x00000010
#define BM_PINCTRL_PULL2_BANK2_PIN03 0x00000008
#define BM_PINCTRL_PULL2_BANK2_PIN02 0x00000004
#define BM_PINCTRL_PULL2_BANK2_PIN01 0x00000002
#define BM_PINCTRL_PULL2_BANK2_PIN00 0x00000001
HW_REGISTER(HW_PINCTRL_PULL3, REGS_PINCTRL_BASE, 0x00000430)
#define HW_PINCTRL_PULL3_ADDR (REGS_PINCTRL_BASE + 0x00000430)
#define BM_PINCTRL_PULL3_BANK3_PIN17 0x00020000
#define BM_PINCTRL_PULL3_BANK3_PIN16 0x00010000
#define BM_PINCTRL_PULL3_BANK3_PIN15 0x00008000
#define BM_PINCTRL_PULL3_BANK3_PIN14 0x00004000
#define BM_PINCTRL_PULL3_BANK3_PIN13 0x00002000
#define BM_PINCTRL_PULL3_BANK3_PIN12 0x00001000
#define BM_PINCTRL_PULL3_BANK3_PIN11 0x00000800
#define BM_PINCTRL_PULL3_BANK3_PIN10 0x00000400
#define BM_PINCTRL_PULL3_BANK3_PIN09 0x00000200
#define BM_PINCTRL_PULL3_BANK3_PIN08 0x00000100
#define BM_PINCTRL_PULL3_BANK3_PIN07 0x00000080
#define BM_PINCTRL_PULL3_BANK3_PIN06 0x00000040
#define BM_PINCTRL_PULL3_BANK3_PIN05 0x00000020
#define BM_PINCTRL_PULL3_BANK3_PIN04 0x00000010
#define BM_PINCTRL_PULL3_BANK3_PIN03 0x00000008
#define BM_PINCTRL_PULL3_BANK3_PIN02 0x00000004
#define BM_PINCTRL_PULL3_BANK3_PIN01 0x00000002
#define BM_PINCTRL_PULL3_BANK3_PIN00 0x00000001
HW_REGISTER(HW_PINCTRL_DOUT0, REGS_PINCTRL_BASE, 0x00000500)
#define HW_PINCTRL_DOUT0_ADDR (REGS_PINCTRL_BASE + 0x00000500)
#define BP_PINCTRL_DOUT0_DOUT      0
#define BM_PINCTRL_DOUT0_DOUT 0xFFFFFFFF
#define BF_PINCTRL_DOUT0_DOUT(v)   (v)
HW_REGISTER(HW_PINCTRL_DOUT1, REGS_PINCTRL_BASE, 0x00000510)
#define HW_PINCTRL_DOUT1_ADDR (REGS_PINCTRL_BASE + 0x00000510)
#define BP_PINCTRL_DOUT1_DOUT      0
#define BM_PINCTRL_DOUT1_DOUT 0x7FFFFFFF
#define BF_PINCTRL_DOUT1_DOUT(v)  \
	(((v) << 0) & BM_PINCTRL_DOUT1_DOUT)
HW_REGISTER(HW_PINCTRL_DOUT2, REGS_PINCTRL_BASE, 0x00000520)
#define HW_PINCTRL_DOUT2_ADDR (REGS_PINCTRL_BASE + 0x00000520)
#define BP_PINCTRL_DOUT2_DOUT      0
#define BM_PINCTRL_DOUT2_DOUT 0xFFFFFFFF
#define BF_PINCTRL_DOUT2_DOUT(v)   (v)
HW_REGISTER(HW_PINCTRL_DIN0, REGS_PINCTRL_BASE, 0x00000600)
#define HW_PINCTRL_DIN0_ADDR (REGS_PINCTRL_BASE + 0x00000600)
#define BP_PINCTRL_DIN0_DIN      0
#define BM_PINCTRL_DIN0_DIN 0xFFFFFFFF
#define BF_PINCTRL_DIN0_DIN(v)   (v)
HW_REGISTER(HW_PINCTRL_DIN1, REGS_PINCTRL_BASE, 0x00000610)
#define HW_PINCTRL_DIN1_ADDR (REGS_PINCTRL_BASE + 0x00000610)
#define BP_PINCTRL_DIN1_DIN      0
#define BM_PINCTRL_DIN1_DIN 0x7FFFFFFF
#define BF_PINCTRL_DIN1_DIN(v)  \
	(((v) << 0) & BM_PINCTRL_DIN1_DIN)
HW_REGISTER(HW_PINCTRL_DIN2, REGS_PINCTRL_BASE, 0x00000620)
#define HW_PINCTRL_DIN2_ADDR (REGS_PINCTRL_BASE + 0x00000620)
#define BP_PINCTRL_DIN2_DIN      0
#define BM_PINCTRL_DIN2_DIN 0xFFFFFFFF
#define BF_PINCTRL_DIN2_DIN(v)   (v)
HW_REGISTER(HW_PINCTRL_DOE0, REGS_PINCTRL_BASE, 0x00000700)
#define HW_PINCTRL_DOE0_ADDR (REGS_PINCTRL_BASE + 0x00000700)
#define BP_PINCTRL_DOE0_DOE      0
#define BM_PINCTRL_DOE0_DOE 0xFFFFFFFF
#define BF_PINCTRL_DOE0_DOE(v)   (v)
HW_REGISTER(HW_PINCTRL_DOE1, REGS_PINCTRL_BASE, 0x00000710)
#define HW_PINCTRL_DOE1_ADDR (REGS_PINCTRL_BASE + 0x00000710)
#define BP_PINCTRL_DOE1_DOE      0
#define BM_PINCTRL_DOE1_DOE 0x7FFFFFFF
#define BF_PINCTRL_DOE1_DOE(v)  \
	(((v) << 0) & BM_PINCTRL_DOE1_DOE)
HW_REGISTER(HW_PINCTRL_DOE2, REGS_PINCTRL_BASE, 0x00000720)
#define HW_PINCTRL_DOE2_ADDR (REGS_PINCTRL_BASE + 0x00000720)
#define BP_PINCTRL_DOE2_DOE      0
#define BM_PINCTRL_DOE2_DOE 0xFFFFFFFF
#define BF_PINCTRL_DOE2_DOE(v)   (v)
HW_REGISTER(HW_PINCTRL_PIN2IRQ0, REGS_PINCTRL_BASE, 0x00000800)
#define HW_PINCTRL_PIN2IRQ0_ADDR (REGS_PINCTRL_BASE + 0x00000800)
#define BP_PINCTRL_PIN2IRQ0_PIN2IRQ      0
#define BM_PINCTRL_PIN2IRQ0_PIN2IRQ 0xFFFFFFFF
#define BF_PINCTRL_PIN2IRQ0_PIN2IRQ(v)   (v)
HW_REGISTER(HW_PINCTRL_PIN2IRQ1, REGS_PINCTRL_BASE, 0x00000810)
#define HW_PINCTRL_PIN2IRQ1_ADDR (REGS_PINCTRL_BASE + 0x00000810)
#define BP_PINCTRL_PIN2IRQ1_PIN2IRQ      0
#define BM_PINCTRL_PIN2IRQ1_PIN2IRQ 0x7FFFFFFF
#define BF_PINCTRL_PIN2IRQ1_PIN2IRQ(v)  \
	(((v) << 0) & BM_PINCTRL_PIN2IRQ1_PIN2IRQ)
HW_REGISTER(HW_PINCTRL_PIN2IRQ2, REGS_PINCTRL_BASE, 0x00000820)
#define HW_PINCTRL_PIN2IRQ2_ADDR (REGS_PINCTRL_BASE + 0x00000820)
#define BP_PINCTRL_PIN2IRQ2_PIN2IRQ      0
#define BM_PINCTRL_PIN2IRQ2_PIN2IRQ 0xFFFFFFFF
#define BF_PINCTRL_PIN2IRQ2_PIN2IRQ(v)   (v)
HW_REGISTER(HW_PINCTRL_IRQEN0, REGS_PINCTRL_BASE, 0x00000900)
#define HW_PINCTRL_IRQEN0_ADDR (REGS_PINCTRL_BASE + 0x00000900)
#define BP_PINCTRL_IRQEN0_IRQEN      0
#define BM_PINCTRL_IRQEN0_IRQEN 0xFFFFFFFF
#define BF_PINCTRL_IRQEN0_IRQEN(v)   (v)
HW_REGISTER(HW_PINCTRL_IRQEN1, REGS_PINCTRL_BASE, 0x00000910)
#define HW_PINCTRL_IRQEN1_ADDR (REGS_PINCTRL_BASE + 0x00000910)
#define BP_PINCTRL_IRQEN1_IRQEN      0
#define BM_PINCTRL_IRQEN1_IRQEN 0x7FFFFFFF
#define BF_PINCTRL_IRQEN1_IRQEN(v)  \
	(((v) << 0) & BM_PINCTRL_IRQEN1_IRQEN)
HW_REGISTER(HW_PINCTRL_IRQEN2, REGS_PINCTRL_BASE, 0x00000920)
#define HW_PINCTRL_IRQEN2_ADDR (REGS_PINCTRL_BASE + 0x00000920)
#define BP_PINCTRL_IRQEN2_IRQEN      0
#define BM_PINCTRL_IRQEN2_IRQEN 0xFFFFFFFF
#define BF_PINCTRL_IRQEN2_IRQEN(v)   (v)
HW_REGISTER(HW_PINCTRL_IRQLEVEL0, REGS_PINCTRL_BASE, 0x00000a00)
#define HW_PINCTRL_IRQLEVEL0_ADDR (REGS_PINCTRL_BASE + 0x00000a00)
#define BP_PINCTRL_IRQLEVEL0_IRQLEVEL      0
#define BM_PINCTRL_IRQLEVEL0_IRQLEVEL 0xFFFFFFFF
#define BF_PINCTRL_IRQLEVEL0_IRQLEVEL(v)   (v)
HW_REGISTER(HW_PINCTRL_IRQLEVEL1, REGS_PINCTRL_BASE, 0x00000a10)
#define HW_PINCTRL_IRQLEVEL1_ADDR (REGS_PINCTRL_BASE + 0x00000a10)
#define BP_PINCTRL_IRQLEVEL1_IRQLEVEL      0
#define BM_PINCTRL_IRQLEVEL1_IRQLEVEL 0x7FFFFFFF
#define BF_PINCTRL_IRQLEVEL1_IRQLEVEL(v)  \
	(((v) << 0) & BM_PINCTRL_IRQLEVEL1_IRQLEVEL)
HW_REGISTER(HW_PINCTRL_IRQLEVEL2, REGS_PINCTRL_BASE, 0x00000a20)
#define HW_PINCTRL_IRQLEVEL2_ADDR (REGS_PINCTRL_BASE + 0x00000a20)
#define BP_PINCTRL_IRQLEVEL2_IRQLEVEL      0
#define BM_PINCTRL_IRQLEVEL2_IRQLEVEL 0xFFFFFFFF
#define BF_PINCTRL_IRQLEVEL2_IRQLEVEL(v)   (v)
HW_REGISTER(HW_PINCTRL_IRQPOL0, REGS_PINCTRL_BASE, 0x00000b00)
#define HW_PINCTRL_IRQPOL0_ADDR (REGS_PINCTRL_BASE + 0x00000b00)
#define BP_PINCTRL_IRQPOL0_IRQPOL      0
#define BM_PINCTRL_IRQPOL0_IRQPOL 0xFFFFFFFF
#define BF_PINCTRL_IRQPOL0_IRQPOL(v)   (v)
HW_REGISTER(HW_PINCTRL_IRQPOL1, REGS_PINCTRL_BASE, 0x00000b10)
#define HW_PINCTRL_IRQPOL1_ADDR (REGS_PINCTRL_BASE + 0x00000b10)
#define BP_PINCTRL_IRQPOL1_IRQPOL      0
#define BM_PINCTRL_IRQPOL1_IRQPOL 0x7FFFFFFF
#define BF_PINCTRL_IRQPOL1_IRQPOL(v)  \
	(((v) << 0) & BM_PINCTRL_IRQPOL1_IRQPOL)
HW_REGISTER(HW_PINCTRL_IRQPOL2, REGS_PINCTRL_BASE, 0x00000b20)
#define HW_PINCTRL_IRQPOL2_ADDR (REGS_PINCTRL_BASE + 0x00000b20)
#define BP_PINCTRL_IRQPOL2_IRQPOL      0
#define BM_PINCTRL_IRQPOL2_IRQPOL 0xFFFFFFFF
#define BF_PINCTRL_IRQPOL2_IRQPOL(v)   (v)
HW_REGISTER(HW_PINCTRL_IRQSTAT0, REGS_PINCTRL_BASE, 0x00000c00)
#define HW_PINCTRL_IRQSTAT0_ADDR (REGS_PINCTRL_BASE + 0x00000c00)
#define BP_PINCTRL_IRQSTAT0_IRQSTAT      0
#define BM_PINCTRL_IRQSTAT0_IRQSTAT 0xFFFFFFFF
#define BF_PINCTRL_IRQSTAT0_IRQSTAT(v)   (v)
HW_REGISTER(HW_PINCTRL_IRQSTAT1, REGS_PINCTRL_BASE, 0x00000c10)
#define HW_PINCTRL_IRQSTAT1_ADDR (REGS_PINCTRL_BASE + 0x00000c10)
#define BP_PINCTRL_IRQSTAT1_IRQSTAT      0
#define BM_PINCTRL_IRQSTAT1_IRQSTAT 0x7FFFFFFF
#define BF_PINCTRL_IRQSTAT1_IRQSTAT(v)  \
	(((v) << 0) & BM_PINCTRL_IRQSTAT1_IRQSTAT)
HW_REGISTER(HW_PINCTRL_IRQSTAT2, REGS_PINCTRL_BASE, 0x00000c20)
#define HW_PINCTRL_IRQSTAT2_ADDR (REGS_PINCTRL_BASE + 0x00000c20)
#define BP_PINCTRL_IRQSTAT2_IRQSTAT      0
#define BM_PINCTRL_IRQSTAT2_IRQSTAT 0xFFFFFFFF
#define BF_PINCTRL_IRQSTAT2_IRQSTAT(v)   (v)
#endif /* __ARCH_ARM___PINCTRL_H */
