/*
 * HID Sensors Driver
 * Copyright (c) 2012, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _HID_SENSORS_IDS_H
#define _HID_SENSORS_IDS_H

/***************************/

#define HID_MAX_PHY_DEVICES					0xFF

/* Accel 3D (200073) */
#define HID_USAGE_SENSOR_ACCEL_3D				0x200073
#define HID_USAGE_SENSOR_DATA_ACCELERATION			0x200452
#define HID_USAGE_SENSOR_ACCEL_X_AXIS				0x200453
#define HID_USAGE_SENSOR_ACCEL_Y_AXIS				0x200454
#define HID_USAGE_SENSOR_ACCEL_Z_AXIS				0x200455

/* ALS (200041) */
#define HID_USAGE_SENSOR_ALS					0x200041
#define HID_USAGE_SENSOR_DATA_LIGHT				0x2004d0
#define HID_USAGE_SENSOR_LIGHT_ILLUM				0x2004d1

/* Gyro 3D: (200076) */
#define HID_USAGE_SENSOR_GYRO_3D				0x200076
#define HID_USAGE_SENSOR_DATA_ANGL_VELOCITY			0x200456
#define HID_USAGE_SENSOR_ANGL_VELOCITY_X_AXIS			0x200457
#define HID_USAGE_SENSOR_ANGL_VELOCITY_Y_AXIS			0x200458
#define HID_USAGE_SENSOR_ANGL_VELOCITY_Z_AXIS			0x200459

/* ORIENTATION: Compass 3D: (200083) */
#define HID_USAGE_SENSOR_COMPASS_3D				0x200083
#define HID_USAGE_SENSOR_DATA_ORIENTATION			0x200470
#define HID_USAGE_SENSOR_ORIENT_MAGN_HEADING			0x200471
#define HID_USAGE_SENSOR_ORIENT_MAGN_HEADING_X			0x200472
#define HID_USAGE_SENSOR_ORIENT_MAGN_HEADING_Y			0x200473
#define HID_USAGE_SENSOR_ORIENT_MAGN_HEADING_Z			0x200474

#define HID_USAGE_SENSOR_ORIENT_COMP_MAGN_NORTH			0x200475
#define HID_USAGE_SENSOR_ORIENT_COMP_TRUE_NORTH			0x200476
#define HID_USAGE_SENSOR_ORIENT_MAGN_NORTH			0x200477
#define HID_USAGE_SENSOR_ORIENT_TRUE_NORTH			0x200478

#define HID_USAGE_SENSOR_ORIENT_DISTANCE			0x200479
#define HID_USAGE_SENSOR_ORIENT_DISTANCE_X			0x20047A
#define HID_USAGE_SENSOR_ORIENT_DISTANCE_Y			0x20047B
#define HID_USAGE_SENSOR_ORIENT_DISTANCE_Z			0x20047C
#define HID_USAGE_SENSOR_ORIENT_DISTANCE_OUT_OF_RANGE		0x20047D

/* ORIENTATION: Inclinometer 3D: (200086) */
#define HID_USAGE_SENSOR_INCLINOMETER_3D			0x200086
#define HID_USAGE_SENSOR_ORIENT_TILT				0x20047E
#define HID_USAGE_SENSOR_ORIENT_TILT_X				0x20047F
#define HID_USAGE_SENSOR_ORIENT_TILT_Y				0x200480
#define HID_USAGE_SENSOR_ORIENT_TILT_Z				0x200481

#define HID_USAGE_SENSOR_ORIENT_ROTATION_MATRIX			0x200482
#define HID_USAGE_SENSOR_ORIENT_QUATERNION			0x200483
#define HID_USAGE_SENSOR_ORIENT_MAGN_FLUX			0x200484

#define HID_USAGE_SENSOR_ORIENT_MAGN_FLUX_X_AXIS		0x200485
#define HID_USAGE_SENSOR_ORIENT_MAGN_FLUX_Y_AXIS		0x200486
#define HID_USAGE_SENSOR_ORIENT_MAGN_FLUX_Z_AXIS		0x200487

/* Time (2000a0) */
#define HID_USAGE_SENSOR_TIME					0x2000a0
#define HID_USAGE_SENSOR_TIME_YEAR				0x200521
#define HID_USAGE_SENSOR_TIME_MONTH				0x200522
#define HID_USAGE_SENSOR_TIME_DAY				0x200523
#define HID_USAGE_SENSOR_TIME_HOUR				0x200525
#define HID_USAGE_SENSOR_TIME_MINUTE				0x200526
#define HID_USAGE_SENSOR_TIME_SECOND				0x200527

/* Units */
#define HID_USAGE_SENSOR_UNITS_NOT_SPECIFIED			0x00
#define HID_USAGE_SENSOR_UNITS_LUX				0x01
#define HID_USAGE_SENSOR_UNITS_KELVIN				0x01000100
#define HID_USAGE_SENSOR_UNITS_FAHRENHEIT			0x03000100
#define HID_USAGE_SENSOR_UNITS_PASCAL				0xF1E1
#define HID_USAGE_SENSOR_UNITS_NEWTON				0x11E1
#define HID_USAGE_SENSOR_UNITS_METERS_PER_SECOND		0x11F0
#define HID_USAGE_SENSOR_UNITS_METERS_PER_SEC_SQRD		0x11E0
#define HID_USAGE_SENSOR_UNITS_FARAD				0xE14F2000
#define HID_USAGE_SENSOR_UNITS_AMPERE				0x01001000
#define HID_USAGE_SENSOR_UNITS_WATT				0x21d1
#define HID_USAGE_SENSOR_UNITS_HENRY				0x21E1E000
#define HID_USAGE_SENSOR_UNITS_OHM				0x21D1E000
#define HID_USAGE_SENSOR_UNITS_VOLT				0x21D1F000
#define HID_USAGE_SENSOR_UNITS_HERTZ				0x01F0
#define HID_USAGE_SENSOR_UNITS_DEGREES_PER_SEC_SQRD		0x14E0
#define HID_USAGE_SENSOR_UNITS_RADIANS				0x12
#define HID_USAGE_SENSOR_UNITS_RADIANS_PER_SECOND		0x12F0
#define HID_USAGE_SENSOR_UNITS_RADIANS_PER_SEC_SQRD		0x12E0
#define HID_USAGE_SENSOR_UNITS_SECOND				0x0110
#define HID_USAGE_SENSOR_UNITS_GAUSS				0x01E1F000
#define HID_USAGE_SENSOR_UNITS_GRAM				0x0101
#define HID_USAGE_SENSOR_UNITS_CENTIMETER			0x11
#define HID_USAGE_SENSOR_UNITS_G				0x1A
#define HID_USAGE_SENSOR_UNITS_MILLISECOND			0x19
#define HID_USAGE_SENSOR_UNITS_PERCENT				0x17
#define HID_USAGE_SENSOR_UNITS_DEGREES				0x14
#define HID_USAGE_SENSOR_UNITS_DEGREES_PER_SECOND		0x15

/* Common selectors */
#define HID_USAGE_SENSOR_PROP_REPORT_INTERVAL			0x20030E
#define HID_USAGE_SENSOR_PROP_SENSITIVITY_ABS			0x20030F
#define HID_USAGE_SENSOR_PROP_SENSITIVITY_RANGE_PCT		0x200310
#define HID_USAGE_SENSOR_PROP_SENSITIVITY_REL_PCT		0x200311
#define HID_USAGE_SENSOR_PROP_ACCURACY				0x200312
#define HID_USAGE_SENSOR_PROP_RESOLUTION			0x200313
#define HID_USAGE_SENSOR_PROP_RANGE_MAXIMUM			0x200314
#define HID_USAGE_SENSOR_PROP_RANGE_MINIMUM			0x200315
#define HID_USAGE_SENSOR_PROP_REPORT_STATE			0x200316
#define HID_USAGE_SENSOR_PROY_POWER_STATE			0x200319

/* Per data field properties */
#define HID_USAGE_SENSOR_DATA_MOD_NONE					0x00
#define HID_USAGE_SENSOR_DATA_MOD_CHANGE_SENSITIVITY_ABS		0x1000

/* Power state enumerations */
#define HID_USAGE_SENSOR_PROP_POWER_STATE_UNDEFINED_ENUM       0x200850
#define HID_USAGE_SENSOR_PROP_POWER_STATE_D0_FULL_POWER_ENUM   0x200851
#define HID_USAGE_SENSOR_PROP_POWER_STATE_D1_LOW_POWER_ENUM    0x200852
#define HID_USAGE_SENSOR_PROP_POWER_STATE_D2_STANDBY_WITH_WAKE_ENUM 0x200853
#define HID_USAGE_SENSOR_PROP_POWER_STATE_D3_SLEEP_WITH_WAKE_ENUM 0x200854
#define HID_USAGE_SENSOR_PROP_POWER_STATE_D4_POWER_OFF_ENUM    0x200855

/* Report State enumerations */
#define HID_USAGE_SENSOR_PROP_REPORTING_STATE_NO_EVENTS_ENUM   0x200840
#define HID_USAGE_SENSOR_PROP_REPORTING_STATE_ALL_EVENTS_ENUM  0x200841

/**************************/


#define HID_USAGE_SENSOR_DATA_ENVIRONMENTAL_RELATIVE_HUMIDITY 0x200433
#define HID_USAGE_SENSOR_DATA_ENVIRONMENTAL_TEMPERATURE 0x200434
#define HID_USAGE_SENSOR_DATA_ENVIRONMENTAL_WIND_DIRECTION 0x200435
#define HID_USAGE_SENSOR_DATA_ENVIRONMENTAL_WIND_SPEED 0x200436
/* property usages (get/set feature report) */
#define HID_USAGE_SENSOR_PROPERTY_ENVIRONMENTAL 0x200440
#define HID_USAGE_SENSOR_PROPERTY_ENVIRONMENTAL_REFERENCE_PRESSURE 0x200441

/* data type motion */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_MOTION 0x200450
#define HID_USAGE_SENSOR_DATA_MOTION_STATE 0x200451
#define HID_USAGE_SENSOR_DATA_MOTION_ACCELERATION 0x200452
#define HID_USAGE_SENSOR_DATA_MOTION_ACCELERATION_X_AXIS 0x200453
#define HID_USAGE_SENSOR_DATA_MOTION_ACCELERATION_Y_AXIS 0x200454
#define HID_USAGE_SENSOR_DATA_MOTION_ACCELERATION_Z_AXIS 0x200455
#define HID_USAGE_SENSOR_DATA_MOTION_ANGULAR_VELOCITY 0x200456
#define HID_USAGE_SENSOR_DATA_MOTION_ANGULAR_VELOCITY_X_AXIS 0x200457
#define HID_USAGE_SENSOR_DATA_MOTION_ANGULAR_VELOCITY_Y_AXIS 0x200458
#define HID_USAGE_SENSOR_DATA_MOTION_ANGULAR_VELOCITY_Z_AXIS 0x200459
#define HID_USAGE_SENSOR_DATA_MOTION_ANGULAR_POSITION 0x20045A
#define HID_USAGE_SENSOR_DATA_MOTION_ANGULAR_POSITION_X_AXIS 0x20045B
#define HID_USAGE_SENSOR_DATA_MOTION_ANGULAR_POSITION_Y_AXIS 0x20045C
#define HID_USAGE_SENSOR_DATA_MOTION_ANGULAR_POSITION_Z_AXIS 0x20045D
#define HID_USAGE_SENSOR_DATA_MOTION_SPEED 0x20045E
#define HID_USAGE_SENSOR_DATA_MOTION_INTENSITY 0x20045F

/* data type orientation */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_ORIENTATION 0x200470
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_HEADING 0x200471
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_HEADING_X 0x200472
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_HEADING_Y 0x200473
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_HEADING_Z 0x200474
#define HID_USAGE_SENSOR_DATA_ORIENTATION_COMPENSATED_MAGNETIC_NORTH 0x200475
#define HID_USAGE_SENSOR_DATA_ORIENTATION_COMPENSATED_TRUE_NORTH 0x200476
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_NORTH 0x200477
#define HID_USAGE_SENSOR_DATA_ORIENTATION_TRUE_NORTH 0x200478
#define HID_USAGE_SENSOR_DATA_ORIENTATION_DISTANCE 0x200479
#define HID_USAGE_SENSOR_DATA_ORIENTATION_DISTANCE_X 0x20047A
#define HID_USAGE_SENSOR_DATA_ORIENTATION_DISTANCE_Y 0x20047B
#define HID_USAGE_SENSOR_DATA_ORIENTATION_DISTANCE_Z 0x20047C
#define HID_USAGE_SENSOR_DATA_ORIENTATION_DISTANCE_OUT_OF_RANGE 0x20047D
#define HID_USAGE_SENSOR_DATA_ORIENTATION_TILT 0x20047E
#define HID_USAGE_SENSOR_DATA_ORIENTATION_TILT_X 0x20047F
#define HID_USAGE_SENSOR_DATA_ORIENTATION_TILT_Y 0x200480
#define HID_USAGE_SENSOR_DATA_ORIENTATION_TILT_Z 0x200481
#define HID_USAGE_SENSOR_DATA_ORIENTATION_ROTATION_MATRIX 0x200482
#define HID_USAGE_SENSOR_DATA_ORIENTATION_QUATERNION 0x200483
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_FLUX 0x200484
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_FLUX_X_AXIS 0x200485
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_FLUX_Y_AXIS 0x200486
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETIC_FLUX_Z_AXIS 0x200487
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETOMETER_ACCURACY 0x200488

/* data type mechanical */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_MECHANICAL 0x200490
#define HID_USAGE_SENSOR_DATA_MECHANICAL_BOOLEAN_SWITCH_STATE 0x200491
#define HID_USAGE_SENSOR_DATA_MECHANICAL_BOOLEAN_SWITCH_ARRAY_STATES 0x200492
#define HID_USAGE_SENSOR_DATA_MECHANICAL_MULTIVALUE_SWITCH_VALUE 0x200493
#define HID_USAGE_SENSOR_DATA_MECHANICAL_FORCE 0x200494
#define HID_USAGE_SENSOR_DATA_MECHANICAL_ABSOLUTE_PRESSURE 0x200495
#define HID_USAGE_SENSOR_DATA_MECHANICAL_GAUGE_PRESSURE 0x200496
#define HID_USAGE_SENSOR_DATA_MECHANICAL_STRAIN 0x200497
#define HID_USAGE_SENSOR_DATA_MECHANICAL_WEIGHT 0x200498
/* property usages (get/set feature report) */
#define HID_USAGE_SENSOR_PROPERTY_MECHANICAL 0x2004A0
#define HID_USAGE_SENSOR_PROPERTY_MECHANICAL_VIBRATION_STATE 0x2004A1
#define HID_USAGE_SENSOR_DATA_MECHANICAL_VIBRATION_SPEED_FORWARD 0x2004A2
#define HID_USAGE_SENSOR_DATA_MECHANICAL_VIBRATION_SPEED_BACKWARD 0x2004A3

/* data type biometric */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_BIOMETRIC 0x2004B0
#define HID_USAGE_SENSOR_DATA_BIOMETRIC_HUMAN_PRESENCE 0x2004B1
#define HID_USAGE_SENSOR_DATA_BIOMETRIC_HUMAN_PROXIMITY_RANGE 0x2004B2
#define HID_USAGE_SENSOR_DATA_BIOMETRIC_HUMAN_PROXIMITY_OUT_OF_RANGE 0x2004B3
#define HID_USAGE_SENSOR_DATA_BIOMETRIC_HUMAN_TOUCH_STATE 0x2004B4

/* data type light sensor */
/* data field usages (input report) */
/*#define HID_USAGE_SENSOR_DATA_LIGHT 0x2004D0*/
#define HID_USAGE_SENSOR_DATA_LIGHT_ILLUMINANCE 0x2004D1
#define HID_USAGE_SENSOR_DATA_LIGHT_COLOR_TEMPERATURE 0x2004D2
#define HID_USAGE_SENSOR_DATA_LIGHT_CHROMATICITY 0x2004D3
#define HID_USAGE_SENSOR_DATA_LIGHT_CHROMATICITY_X 0x2004D4
#define HID_USAGE_SENSOR_DATA_LIGHT_CHROMATICITY_Y 0x2004D5
#define HID_USAGE_SENSOR_DATA_LIGHT_CONSUMER_IR_SENTENCE_RECEIVE 0x2004D6
/* property usages (get/set feature report) */
#define HID_USAGE_SENSOR_PROPERTY_LIGHT 0x2004E0
#define HID_USAGE_SENSOR_PROPERTY_LIGHT_CONSUMER_IR_SENTENCE_SEND 0x2004E1

/* data type scanner */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_SCANNER 0x2004F0
#define HID_USAGE_SENSOR_DATA_SCANNER_RFID_TAG 0x2004F1
#define HID_USAGE_SENSOR_DATA_SCANNER_NFC_SENTENCE_RECEIVE 0x2004F2
/* property usages (get/set feature report) */
#define HID_USAGE_SENSOR_PROPERTY_SCANNER 0x2004F8
#define HID_USAGE_SENSOR_PROPERTY_SCANNER_NFC_SENTENCE_SEND 0x2004F9

/* data type electrical */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_ELECTRICAL 0x200500
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_CAPACITANCE 0x200501
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_CURRENT 0x200502
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_POWER 0x200503
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_INDUCTANCE 0x200504
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_RESISTANCE 0x200505
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_VOLTAGE 0x200506
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_FREQUENCY 0x200507
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_PERIOD 0x200508
#define HID_USAGE_SENSOR_DATA_ELECTRICAL_PERCENT_OF_RANGE 0x200509

/* data type time */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_TIME 0x200520
#define HID_USAGE_SENSOR_DATA_TIME_YEAR 0x200521
#define HID_USAGE_SENSOR_DATA_TIME_MONTH 0x200522
#define HID_USAGE_SENSOR_DATA_TIME_DAY 0x200523
#define HID_USAGE_SENSOR_DATA_TIME_DAY_OF_WEEK 0x200524
#define HID_USAGE_SENSOR_DATA_TIME_HOUR 0x200525
#define HID_USAGE_SENSOR_DATA_TIME_MINUTE 0x200526
#define HID_USAGE_SENSOR_DATA_TIME_SECOND 0x200527
#define HID_USAGE_SENSOR_DATA_TIME_MILLISECOND 0x200528
#define HID_USAGE_SENSOR_DATA_TIME_TIMESTAMP 0x200529
#define HID_USAGE_SENSOR_DATA_TIME_JULIAN_DAY_OF_YEAR 0x20052A
/* property usages (get/set feature report) */
#define HID_USAGE_SENSOR_PROPERTY_TIME 0x200530
#define HID_USAGE_SENSOR_PROPERTY_TIME_TIME_ZONE_OFFSET_FROM_UTC 0x200531
#define HID_USAGE_SENSOR_PROPERTY_TIME_TIME_ZONE_NAME 0x200532
#define HID_USAGE_SENSOR_PROPERTY_TIME_DAYLIGHT_SAVINGS_TIME_OBSERVED 0x200533
#define HID_USAGE_SENSOR_PROPERTY_TIME_TIME_TRIM_ADJUSTMENT 0x200534
#define HID_USAGE_SENSOR_PROPERTY_TIME_ARM_ALARM 0x200535

/* data type custom */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_CUSTOM 0x200540
#define HID_USAGE_SENSOR_DATA_CUSTOM_USAGE 0x200541
#define HID_USAGE_SENSOR_DATA_CUSTOM_BOOLEAN_ARRAY 0x200542
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE 0x200543
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_1 0x200544
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_2 0x200545
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_3 0x200546
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_4 0x200547
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_5 0x200548
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_6 0x200549

#if 1 /* define vendor-specific (non-spec) custom datafields */
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_7 0x20054A
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_8 0x20054B
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_9 0x20054C
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_10 0x20054D
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_11 0x20054E
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_12 0x20054F
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_13 0x200550
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_14 0x200551
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_15 0x200552
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_16 0x200553
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_17 0x200554
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_18 0x200555
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_19 0x200556
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_20 0x200557
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_21 0x200558
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_22 0x200559
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_23 0x20055A
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_24 0x20055B
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_25 0x20055C
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_26 0x20055D
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_27 0x20055E
#define HID_USAGE_SENSOR_DATA_CUSTOM_VALUE_28 0x20055F
#endif

#define HID_DRIVER_USAGE_SENSOR_DATA_CUSTOM_HEALTH_MONITOR 0x200583
#define HID_DRIVER_USAGE_SENSOR_DATA_CUSTOM_HEALTH_SYSTOLIC_BLOOD_PRESSURE 0x200584
#define HID_DRIVER_USAGE_SENSOR_DATA_CUSTOM_HEALTH_DYSTOLIC_BLOOD_PRESSURE 0x200585
#define HID_DRIVER_USAGE_SENSOR_DATA_CUSTOM_HEALTH_HEART_BEAT 0x200586

/* data type generic */
/* data field usages (input report) */
#define HID_USAGE_SENSOR_DATA_GENERIC 0x200560
#define HID_USAGE_SENSOR_DATA_GENERIC_GUID_OR_PROPERTYKEY 0x200561
#define HID_USAGE_SENSOR_DATA_GENERIC_CATEGORY_GUID 0x200562
#define HID_USAGE_SENSOR_DATA_GENERIC_TYPE_GUID 0x200563
#define HID_USAGE_SENSOR_DATA_GENERIC_EVENT_PROPERTYKEY 0x200564
#define HID_USAGE_SENSOR_DATA_GENERIC_PROPERTY_PROPERTYKEY 0x200565
#define HID_USAGE_SENSOR_DATA_GENERIC_DATAFIELD_PROPERTYKEY 0x200566
#define HID_USAGE_SENSOR_DATA_GENERIC_EVENT 0x200567
#define HID_USAGE_SENSOR_DATA_GENERIC_PROPERTY 0x200568
#define HID_USAGE_SENSOR_DATA_GENERIC_DATAFIELD 0x200569
#define HID_USAGE_SENSOR_DATA_ENUMERATOR_TABLE_ROW_INDEX 0x20056A
#define HID_USAGE_SENSOR_DATA_ENUMERATOR_TABLE_ROW_COUNT 0x20056B
#define HID_USAGE_SENSOR_DATA_GENERIC_GUID_OR_PROPERTYKEY_KIND 0x20056C
/* begin GorPK kind selectors */
#define HID_USAGE_SENSOR_GORPK_KIND_CATEGORY 0x2008D0
#define HID_USAGE_SENSOR_GORPK_KIND_TYPE 0x2008D1
#define HID_USAGE_SENSOR_GORPK_KIND_EVENT 0x2008D2
#define HID_USAGE_SENSOR_GORPK_KIND_PROPERTY 0x2008D3
#define HID_USAGE_SENSOR_GORPK_KIND_DATAFIELD 0x2008D4
/* end GorPK kind selectors */
#define HID_USAGE_SENSOR_DATA_GENERIC_GUID 0x20056D
#define HID_USAGE_SENSOR_DATA_GENERIC_PROPERTYKEY 0x20056E
#define HID_USAGE_SENSOR_DATA_GENERIC_TOP_LEVEL_COLLECTION_ID 0x20056F
#define HID_USAGE_SENSOR_DATA_GENERIC_REPORT_ID 0x200570
#define HID_USAGE_SENSOR_DATA_GENERIC_REPORT_ITEM_POSITION_INDEX 0x200571
#define HID_USAGE_SENSOR_DATA_GENERIC_FIRMWARE_VARTYPE 0x200572

/* Units */
#define HID_USAGE_SENSOR_UNITS_NOT_SPECIFIED			0x00
#define HID_USAGE_SENSOR_UNITS_LUX				0x01
#define HID_USAGE_SENSOR_UNITS_KELVIN				0x01000100
#define HID_USAGE_SENSOR_UNITS_FAHRENHEIT			0x03000100
#define HID_USAGE_SENSOR_UNITS_PASCAL				0xF1E1
#define HID_USAGE_SENSOR_UNITS_NEWTON				0x11E1
#define HID_USAGE_SENSOR_UNITS_METERS_PER_SECOND		0x11F0
#define HID_USAGE_SENSOR_UNITS_METERS_PER_SEC_SQRD		0x11E0
#define HID_USAGE_SENSOR_UNITS_FARAD				0xE14F2000
#define HID_USAGE_SENSOR_UNITS_AMPERE				0x01001000
#define HID_USAGE_SENSOR_UNITS_WATT				0x21d1
#define HID_USAGE_SENSOR_UNITS_HENRY				0x21E1E000
#define HID_USAGE_SENSOR_UNITS_OHM				0x21D1E000
#define HID_USAGE_SENSOR_UNITS_VOLT				0x21D1F000
#define HID_USAGE_SENSOR_UNITS_HERTZ				0x01F0
#define HID_USAGE_SENSOR_UNITS_DEGREES_PER_SEC_SQRD		0x14E0
#define HID_USAGE_SENSOR_UNITS_RADIANS				0x12
#define HID_USAGE_SENSOR_UNITS_RADIANS_PER_SECOND		0x12F0
#define HID_USAGE_SENSOR_UNITS_RADIANS_PER_SEC_SQRD		0x12E0
#define HID_USAGE_SENSOR_UNITS_SECOND				0x0110
#define HID_USAGE_SENSOR_UNITS_GAUSS				0x01E1F000
#define HID_USAGE_SENSOR_UNITS_GRAM				0x0101
#define HID_USAGE_SENSOR_UNITS_CENTIMETER			0x11
#define HID_USAGE_SENSOR_UNITS_G				0x1A
#define HID_USAGE_SENSOR_UNITS_MILLISECOND			0x19
#define HID_USAGE_SENSOR_UNITS_PERCENT				0x17
#define HID_USAGE_SENSOR_UNITS_DEGREES				0x14
#define HID_USAGE_SENSOR_UNITS_DEGREES_PER_SECOND		0x15

/* Modifiers (Mask of 0xF000 to data field number )*/
#define HID_USAGE_SENSOR_MODIFIER_NONE				0x0000
#define HID_USAGE_SENSOR_MODIFIER_CHG_SENSITIVITY_ABS		0x1000
#define HID_USAGE_SENSOR_MODIFIER_MAX				0x2000
#define HID_USAGE_SENSOR_MODIFIER_MIN				0x3000
#define HID_USAGE_SENSOR_MODIFIER_ACCURACY			0x4000
#define HID_USAGE_SENSOR_MODIFIER_RESOLUTION			0x5000
#define HID_USAGE_SENSOR_MODIFIER_THRES_HIGH			0x6000
#define HID_USAGE_SENSOR_MODIFIER_THRES_LOW			0x7000
#define HID_USAGE_SENSOR_MODIFIER_CALIBRATION_OFFSET		0x8000
#define HID_USAGE_SENSOR_MODIFIER_CALIBRATION_MULTIPLIER	0x9000
#define HID_USAGE_SENSOR_MODIFIER_REPORT_INTERVAL		0xA000
#define HID_USAGE_SENSOR_MODIFIER_FREQ_MAX			0xB000
#define HID_USAGE_SENSOR_MODIFIER_PERIOD_MAX			0xC000
#define HID_USAGE_SENSOR_MODIFIER_CHG_SENSITIVITY_PERCENT_RANGE	0xD000
#define HID_USAGE_SENSOR_MODIFIER_CHG_SENSITIVITY_PERCENT_REL	0xE000

/*state usages*/
#define HID_USAGE_SENSOR_STATE 0x200201
/* state selectors */
#define HID_USAGE_SENSOR_STATE_UNKNOWN_SEL 0x200800
#define HID_USAGE_SENSOR_STATE_READY_SEL 0x200801
#define HID_USAGE_SENSOR_STATE_NOT_AVAILABLE_SEL 0x200802
#define HID_USAGE_SENSOR_STATE_NO_DATA_SEL 0x200803
#define HID_USAGE_SENSOR_STATE_INITIALIZING_SEL 0x200804
#define HID_USAGE_SENSOR_STATE_ACCESS_DENIED_SEL 0x200805
#define HID_USAGE_SENSOR_STATE_ERROR_SEL 0x200806

/* state enums */
#define HID_USAGE_SENSOR_STATE_UNKNOWN_ENUM                                             0x01
#define HID_USAGE_SENSOR_STATE_READY_ENUM                                               0x02
#define HID_USAGE_SENSOR_STATE_NOT_AVAILABLE_ENUM                                       0x03
#define HID_USAGE_SENSOR_STATE_NO_DATA_ENUM                                             0x04
#define HID_USAGE_SENSOR_STATE_INITIALIZING_ENUM                                        0x05
#define HID_USAGE_SENSOR_STATE_ACCESS_DENIED_ENUM                                       0x06
#define HID_USAGE_SENSOR_STATE_ERROR_ENUM                                               0x07


/* event usages */
#define HID_USAGE_SENSOR_EVENT 0x200202
/* event selectors */
#define HID_USAGE_SENSOR_EVENT_UNKNOWN_SEL 0x200810
#define HID_USAGE_SENSOR_EVENT_STATE_CHANGED_SEL 0x200811
#define HID_USAGE_SENSOR_EVENT_PROPERTY_CHANGED_SEL 0x200812
#define HID_USAGE_SENSOR_EVENT_DATA_UPDATED_SEL 0x200813
#define HID_USAGE_SENSOR_EVENT_POLL_RESPONSE_SEL 0x200814
#define HID_USAGE_SENSOR_EVENT_CHANGE_SENSITIVITY_SEL 0x200815
#define HID_USAGE_SENSOR_EVENT_MAX_REACHED_SEL 0x200816
#define HID_USAGE_SENSOR_EVENT_MIN_REACHED_SEL 0x200817
#define HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_UPWARD_SEL 0x200818
#define HID_USAGE_SENSOR_EVENT_HIGH_THESHOLD_CROSS_ABOVE_SEL        HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_UPWARD_SEL
#define HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_DOWNWARD_SEL 0x200819
#define HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_BELOW_SEL       HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_DOWNWARD_SEL
#define HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_UPWARD_SEL 0x20081A
#define HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_ABOVE_SEL        HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_UPWARD_SEL
#define HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_DOWNWARD_SEL 0x20081B
#define HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_BELOW_SEL        HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_DOWNWARD_SEL
#define HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_UPWARD_SEL 0x20081C
#define HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_ABOVE_SEL       HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_UPWARD_SEL
#define HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_DOWNWARD_SEL 0x20081D
#define HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_BELOW_SEL       HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_DOWNWARD_SEL
#define HID_USAGE_SENSOR_EVENT_PERIOD_EXCEEDED_SEL 0x20081E
#define HID_USAGE_SENSOR_EVENT_FREQUENCY_EXCEEDED_SEL 0x20081F
#define HID_USAGE_SENSOR_EVENT_COMPLEX_TRIGGER_SEL 0x200820

/* event enums */
#define HID_USAGE_SENSOR_EVENT_UNKNOWN_ENUM                                             0x01
#define HID_USAGE_SENSOR_EVENT_STATE_CHANGED_ENUM                                       0x02
#define HID_USAGE_SENSOR_EVENT_PROPERTY_CHANGED_ENUM                                    0x03
#define HID_USAGE_SENSOR_EVENT_DATA_UPDATED_ENUM                                        0x04
#define HID_USAGE_SENSOR_EVENT_POLL_RESPONSE_ENUM                                       0x05
#define HID_USAGE_SENSOR_EVENT_CHANGE_SENSITIVITY_ENUM                                  0x06
#define HID_USAGE_SENSOR_EVENT_MAX_REACHED_ENUM                                         0x07
#define HID_USAGE_SENSOR_EVENT_MIN_REACHED_ENUM                                         0x08
#define HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_UPWARD_ENUM 0x200009
#define HID_USAGE_SENSOR_EVENT_HIGH_THESHOLD_CROSS_ABOVE_ENUM   HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_UPWARD_ENUM
#define HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_DOWNWARD_ENUM 0x200A00
#define HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_BELOW_ENUM  HID_USAGE_SENSOR_EVENT_HIGH_THRESHOLD_CROSS_DOWNWARD_ENUM
#define HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_UPWARD_ENUM                          0x0B
#define HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_ABOVE_ENUM   HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_UPWARD_ENUM
#define HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_DOWNWARD_ENUM                        0x0C
#define HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_BELOW_ENUM   HID_USAGE_SENSOR_EVENT_LOW_THRESHOLD_CROSS_DOWNWARD_ENUM
#define HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_UPWARD_ENUM                         0x0D
#define HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_ABOVE_ENUM  HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_UPWARD_ENUM
#define HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_DOWNWARD_ENUM                       0x0E
#define HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_BELOW_ENUM  HID_USAGE_SENSOR_EVENT_ZERO_THRESHOLD_CROSS_DOWNWARD_ENUM
#define HID_USAGE_SENSOR_EVENT_PERIOD_EXCEEDED_ENUM                                     0x0F
#define HID_USAGE_SENSOR_EVENT_FREQUENCY_EXCEEDED_ENUM                                  0x10
#define HID_USAGE_SENSOR_EVENT_COMPLEX_TRIGGER_ENUM                                     0x11


/* property usages (get/set feature report) */
#define HID_USAGE_SENSOR_PROPERTY 0x200300
#define HID_USAGE_SENSOR_PROPERTY_FRIENDLY_NAME 0x200301
#define HID_USAGE_SENSOR_PROPERTY_PERSISTENT_UNIQUE_ID 0x200302
#define HID_USAGE_SENSOR_PROPERTY_SENSOR_STATUS 0x200303
#define HID_USAGE_SENSOR_PROPERTY_MINIMUM_REPORT_INTERVAL 0x200304
#define HID_USAGE_SENSOR_PROPERTY_SENSOR_MANUFACTURER 0x200305
#define HID_USAGE_SENSOR_PROPERTY_SENSOR_MODEL 0x200306
#define HID_USAGE_SENSOR_PROPERTY_SENSOR_SERIAL_NUMBER 0x200307
#define HID_USAGE_SENSOR_PROPERTY_SENSOR_DESCRIPTION 0x200308
#define HID_USAGE_SENSOR_PROPERTY_SENSOR_CONNECTION_TYPE 0x200309
/* begin connection type selectors */
#define HID_USAGE_SENSOR_PROPERTY_CONNECTION_TYPE_PC_INTEGRATED_SEL 0x200830
#define HID_USAGE_SENSOR_PROPERTY_CONNECTION_TYPE_PC_ATTACHED_SEL 0x200831
#define HID_USAGE_SENSOR_PROPERTY_CONNECTION_TYPE_PC_EXTERNAL_SEL 0x200832
/* end connection type selectors */

/* begin connection type enums */
#define HID_USAGE_SENSOR_PROPERTY_CONNECTION_TYPE_PC_INTEGRATED_ENUM                    0x01
#define HID_USAGE_SENSOR_PROPERTY_CONNECTION_TYPE_PC_ATTACHED_ENUM                      0x02
#define HID_USAGE_SENSOR_PROPERTY_CONNECTION_TYPE_PC_EXTERNAL_ENUM                      0x03
/* end connection type enums */

#define HID_USAGE_SENSOR_PROPERTY_SENSOR_DEVICE_PATH 0x20030A
#define HID_USAGE_SENSOR_PROPERTY_HARDWARE_REVISION 0x20030B
#define HID_USAGE_SENSOR_PROPERTY_FIRMWARE_VERSION 0x20030C
#define HID_USAGE_SENSOR_PROPERTY_RELEASE_DATE 0x20030D
#define HID_USAGE_SENSOR_PROPERTY_REPORT_INTERVAL 0x20030E
#define HID_USAGE_SENSOR_PROPERTY_CHANGE_SENSITIVITY_ABS 0x20030F
#define HID_USAGE_SENSOR_PROPERTY_CHANGE_SENSITIVITY_RANGE_PCT 0x200310
#define HID_USAGE_SENSOR_PROPERTY_CHANGE_SENSITIVITY_REL_PCT 0x200311
#define HID_USAGE_SENSOR_PROPERTY_ACCURACY 0x200312
#define HID_USAGE_SENSOR_PROPERTY_RESOLUTION 0x200313
#define HID_USAGE_SENSOR_PROPERTY_RANGE_MAXIMUM 0x200314
#define HID_USAGE_SENSOR_PROPERTY_RANGE_MINIMUM 0x200315
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE 0x200316

/* begin reporting state selectors */
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_NO_EVENTS_SEL 0x200840
#define HID_USAGE_REPORTING_STATE_ON_NONE_SEL       HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_NO_EVENTS_SEL
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_ALL_EVENTS_SEL 0x200841
#define HID_USAGE_REPORTING_STATE_ON_ALL_SEL        HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_ALL_EVENTS_SEL
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_THRESHOLD_EVENTS_SEL 0x200842
#define HID_USAGE_REPORTING_STATE_ON_THRESHOLD_SEL  HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_THRESHOLD_EVENTS_SEL
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_NO_EVENTS_WAKE_SEL 0x200843
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_ALL_EVENTS_WAKE_SEL 0x200844
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_THRESHOLD_EVENTS_WAKE_SEL 0x200845
/* end reporting state selectors */

/* begin reporting state enums */
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_NO_EVENTS_ENUM                        0x01
#define HID_USAGE_REPORTING_STATE_ON_NONE_ENUM      HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_NO_EVENTS_ENUM
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_ALL_EVENTS_ENUM                       0x02
#define HID_USAGE_REPORTING_STATE_ON_ALL_ENUM       HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_ALL_EVENTS_ENUM
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_THRESHOLD_EVENTS_ENUM                 0x03
#define HID_USAGE_REPORTING_STATE_ON_THRESHOLD_ENUM HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_THRESHOLD_EVENTS_ENUM
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_NO_EVENTS_WAKE_ENUM                   0x04
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_ALL_EVENTS_WAKE_ENUM                  0x05
#define HID_USAGE_SENSOR_PROPERTY_REPORTING_STATE_THRESHOLD_EVENTS_WAKE_ENUM            0x06
/* end reporting state enums */

#define HID_USAGE_SENSOR_PROPERTY_SAMPLING_RATE 0x200317
#define HID_USAGE_SENSOR_PROPERTY_RESPONSE_CURVE 0x200318
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE 0x200319
/* begin power state selectors */
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_UNDEFINED_SEL 0x200850
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D0_FULL_POWER_SEL 0x200851
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D1_LOW_POWER_SEL 0x200852
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D2_STANDBY_WITH_WAKE_SEL 0x200853
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D3_SLEEP_WITH_WAKE_SEL 0x200854
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D4_POWER_OFF_SEL 0x200855
/* end power state selectors */

/* begin power state enums */
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_UNDEFINED_ENUM                            0x01
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D0_FULL_POWER_ENUM                        0x02
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D1_LOW_POWER_ENUM                         0x03
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D2_STANDBY_WITH_WAKE_ENUM                 0x04
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D3_SLEEP_WITH_WAKE_ENUM                   0x05
#define HID_USAGE_SENSOR_PROPERTY_POWER_STATE_D4_POWER_OFF_ENUM                         0x06
/* end power state enums */

/* begin orientation magnetometer accuracy selectors */
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETOMETER_ACCURACY_LOW 0x02008E0
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETOMETER_ACCURACY_MEDIUM 0x02008E1
#define HID_USAGE_SENSOR_DATA_ORIENTATION_MAGNETOMETER_ACCURACY_HIGH 0x02008E2
/* end orientation magnetometer accuracy selectors */

#define HID_USAGE_SENSOR_DATA_GENERIC_UNIT_EXPONENT 0x200574
/* begin unit exponent selectors */
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_0 0x200970
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_1 0x200971
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_2 0x200972
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_3 0x200973
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_4 0x200974
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_5 0x200975
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_6 0x200976
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_7 0x200977
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_8 0x200978
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_9 0x200979
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_A 0x20097A
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_B 0x20097B
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_C 0x20097C
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_D 0x20097D
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_E 0x20097E
#define HID_USAGE_SENSOR_GENERIC_EXPONENT_F 0x20097F
/* end unit exponent selectors */

#endif
