/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_RECENT_SOURCE_H_
#define _LAUNCHER_RECENT_SOURCE_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <netbook-launcher/netbook-launcher.h>

#define LAUNCHER_TYPE_RECENT_SOURCE (launcher_recent_source_get_type ())

#define LAUNCHER_RECENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_RECENT_SOURCE, LauncherRecentSource))

#define LAUNCHER_RECENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_RECENT_SOURCE, LauncherRecentSourceClass))

#define LAUNCHER_IS_RECENT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_RECENT_SOURCE))

#define LAUNCHER_IS_RECENT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_RECENT_SOURCE))

#define LAUNCHER_RECENT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_RECENT_SOURCE, LauncherRecentSourceClass))

typedef struct _LauncherRecentSource        LauncherRecentSource;
typedef struct _LauncherRecentSourceClass   LauncherRecentSourceClass;
typedef struct _LauncherRecentSourcePrivate LauncherRecentSourcePrivate;
 
struct _LauncherRecentSource
{
  GObject        parent;	

  LauncherRecentSourcePrivate *priv;
};

struct _LauncherRecentSourceClass
{
  GObjectClass   parent_class;
};

GType     launcher_recent_source_get_type   (void) G_GNUC_CONST;

GObject * launcher_recent_source_new        (NlShell *shell);

#endif /* _LAUNCHER_RECENT_SOURCE_H_ */

