/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_FAVORITE_GADGET_H_
#define _NL_FAVORITE_GADGET_H_

#include <glib.h>
#include <clutter/clutter.h>
#include <netbook-launcher/netbook-launcher.h>

#define NL_TYPE_FAVORITE_GADGET (nl_favorite_gadget_get_type ())

#define NL_FAVORITE_GADGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), \
        NL_TYPE_FAVORITE_GADGET, NlFavoriteGadget))

#define NL_FAVORITE_GADGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), \
        NL_TYPE_FAVORITE_GADGET, NlFavoriteGadgetClass))

#define NL_IS_FAVORITE_GADGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), \
        NL_TYPE_FAVORITE_GADGET))

#define NL_IS_FAVORITE_GADGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE \
        ((klass), NL_TYPE_FAVORITE_GADGET))

#define NL_FAVORITE_GADGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS \
        ((obj), NL_TYPE_FAVORITE_GADGET, NlFavoriteGadgetClass))

typedef struct _NlFavoriteGadget        NlFavoriteGadget;
typedef struct _NlFavoriteGadgetClass   NlFavoriteGadgetClass;
typedef struct _NlFavoriteGadgetPrivate NlFavoriteGadgetPrivate;
 
struct _NlFavoriteGadget
{
  NlFavorite        parent;

  NlFavoriteGadgetPrivate *priv;
};

struct _NlFavoriteGadgetClass
{
  NlFavoriteClass   parent_class;
};

GType        nl_favorite_gadget_get_type   (void) G_GNUC_CONST;

NlFavorite * nl_favorite_gadget_new        (const gchar *uid,
                                            NlShell     *shell);

#endif /* _NL_FAVORITE_GADGET_H_ */

