#ifndef __SP_TIMER_H__
#define __SP_TIMER_H__



#include <glib-2.0/glib.h> 

#define 	SP_TIMER_MAX						2		/*the max timer count*/


typedef enum
{
	SP_KEY_TYPE_JUDGE_TIMER,
	SP_KEY_PRESS_JUDGE_TIMER,
    SP_TIMER_LAST
}SP_TIMER;

/*the timer current status*/
typedef enum
{
    SP_TIMER_STATUS_OFF,
    SP_TIMER_STATUS_ON
}SP_TIMER_STATUS;

/*the struct of each timer*/
typedef struct sp_timer
{
    int iTimerId;
    int iInterval;
    void *pData;
    SP_TIMER_STATUS status;
}sp_timer_t;


/*remove the timer from mainloop*/
void sp_add_timer(int interval,SP_TIMER type,int (* back_func)(gpointer), gpointer gdata);
int sp_remove_timer(SP_TIMER TimerType);

gboolean sp_timer_status_set(SP_TIMER which_timer,SP_TIMER_STATUS timer_status);
SP_TIMER_STATUS sp_timer_status_get(SP_TIMER which_timer);

extern sp_timer_t sp_timer_list[SP_TIMER_MAX];

#endif

