/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "hrn.h"
#include "hrn-toolbar-theatre.h"
#include "hrn-thumb-bar.h"

G_DEFINE_TYPE (HrnToolbarTheatre, hrn_toolbar_theatre, NBTK_TYPE_TABLE)

#define TOOLBAR_THEATRE_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), HRN_TYPE_TOOLBAR_THEATRE, \
                                HrnToolbarTheatrePrivate))

struct _HrnToolbarTheatrePrivate
{
  NbtkWidget   *zoom_bar;
  NbtkWidget   *filter_bar;
  ClutterActor *thumbbar;
  NbtkWidget   *close_button;
};

static NbtkWidget *
hrn_utils_button_new ()
{
  NbtkWidget *button = nbtk_button_new ();

  g_object_set (G_OBJECT (
                  button),
                "transition-duration", 150,
                /*               "transition-type", NBTK_TRANSITION_FADE,
                 */
                NULL);
  return button;
}

static void
hrn_toolbar_theatre_get_property (GObject *object, guint property_id,
                                  GValue *value,
                                  GParamSpec *pspec)
{
  switch (property_id)
    {
      default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
    }
}

static void
hrn_toolbar_theatre_set_property (GObject *object, guint property_id,
                                  const GValue *value,
                                  GParamSpec   *pspec)
{
  switch (property_id)
    {
      default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
    }
}

static void
hrn_toolbar_theatre_dispose (GObject *object)
{
  G_OBJECT_CLASS (hrn_toolbar_theatre_parent_class)->dispose (object);
}

static void
hrn_toolbar_theatre_finalize (GObject *object)
{
  G_OBJECT_CLASS (hrn_toolbar_theatre_parent_class)->finalize (object);
}

static void
hrn_toolbar_theatre_class_init (HrnToolbarTheatreClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS (klass);

  g_type_class_add_private (klass, sizeof (HrnToolbarTheatrePrivate));

  object_class->get_property = hrn_toolbar_theatre_get_property;
  object_class->set_property = hrn_toolbar_theatre_set_property;
  object_class->dispose      = hrn_toolbar_theatre_dispose;
  object_class->finalize     = hrn_toolbar_theatre_finalize;
}

static void
hrn_toolbar_theatre_quit_clicked_cb (ClutterActor      *actor,
                                     HrnToolbarTheatre *self)
{
  hrn_quit ();
}

/* FIXME: Should this be handled here, or higher up the food chain? */
static void
item_clicked_cb (HrnThumbBar *bar, BklItem           *item,
                 HrnToolbarTheatre *theatre)
{
  hrn_play_now (item);
}

static void
hrn_toolbar_theatre_init (HrnToolbarTheatre *self)
{
  NbtkTable                *table;
  ClutterActor             *separator;
  ClutterActor             *reserved;

  HrnToolbarTheatrePrivate *priv = self->priv = TOOLBAR_THEATRE_PRIVATE (self);

  clutter_actor_set_name (CLUTTER_ACTOR (self), "toolbar-theatre");


  priv->close_button = hrn_utils_button_new ();
  clutter_actor_set_name (CLUTTER_ACTOR (priv->close_button),
                          "close-button");

  priv->filter_bar = nbtk_entry_new ("foo");
  clutter_actor_set_name (CLUTTER_ACTOR (priv->filter_bar),
                          "filter-bar");

  priv->zoom_bar = nbtk_scroll_bar_new (zoom_adjustment);
  clutter_actor_set_name (CLUTTER_ACTOR (priv->filter_bar),
                          "nbtk-filter-bar");
  priv->thumbbar = (ClutterActor *) hrn_thumb_bar_new ();
  g_signal_connect (priv->thumbbar, "item-clicked",
                    G_CALLBACK (item_clicked_cb), self);

  clutter_actor_set_name (CLUTTER_ACTOR (priv->thumbbar), "HrnContext");

  g_signal_connect (priv->close_button, "clicked",
                    G_CALLBACK (hrn_toolbar_theatre_quit_clicked_cb), self);

  reserved = clutter_rectangle_new ();
  clutter_actor_set_height (reserved, 2);
  clutter_actor_set_height (priv->thumbbar, 61);
  clutter_actor_set_size (CLUTTER_ACTOR (priv->close_button), 64, 40);

  table = NBTK_TABLE (self);

  nbtk_table_set_col_spacing (table, 6);
  separator = clutter_texture_new_from_file (
    PKGDATADIR "nbtk-toolbar-separator.png",
    NULL);
  clutter_actor_set_width (CLUTTER_ACTOR (priv->zoom_bar),
                           clutter_actor_get_width (
                             clutter_stage_get_default ()) * 0.333);
  clutter_actor_set_height (CLUTTER_ACTOR (priv->zoom_bar), 40);


  nbtk_table_add_actor_with_properties (NBTK_TABLE (table),
                                        CLUTTER_ACTOR (priv->zoom_bar), 0, 1,
                                        "row-span", 1,
                                        "col-span", 1,
                                        "y-expand", FALSE,
                                        "x-expand", FALSE,
                                        "y-fill", FALSE,
                                        "x-fill", FALSE,
                                        "y-align", 0.5,
                                        "x-align", 0.5,
                                        NULL);


  nbtk_table_add_actor_with_properties (NBTK_TABLE (table),
                                        CLUTTER_ACTOR (priv->thumbbar), 0, 2,
                                        "row-span", 1,
                                        "col-span", 1,
                                        "y-expand", FALSE,
                                        "x-expand", TRUE,
                                        "x-fill", TRUE,
                                        "y-fill", FALSE,
                                        "y-align", 0.5,
                                        "x-align", 0.5,
                                        NULL);


  nbtk_table_add_actor_with_properties (NBTK_TABLE (table),
                                        CLUTTER_ACTOR (separator), 0, 3,
                                        "row-span", 1,
                                        "col-span", 1,
                                        "y-expand", FALSE,
                                        "x-expand", FALSE,
                                        "y-fill", FALSE,
                                        "x-fill", FALSE,
                                        "y-align", 0.5,
                                        "x-align", 0.5,
                                        NULL);


  nbtk_table_add_actor_with_properties (NBTK_TABLE (table),
                                        CLUTTER_ACTOR (
                                          priv->close_button), 0, 5,
                                        "row-span", 1,
                                        "col-span", 1,
                                        "y-expand", FALSE,
                                        "x-expand", FALSE,
                                        "y-fill", FALSE,
                                        "x-fill", FALSE,
                                        "y-align", 0.5,
                                        "x-align", 0.5,
                                        NULL);
}

NbtkWidget*
hrn_toolbar_theatre_new (void)
{
  return g_object_new (HRN_TYPE_TOOLBAR_THEATRE, NULL);
}

void
hrn_toolbar_theatre_focused (ClutterActor *toolbar)
{
  clutter_stage_set_key_focus (CLUTTER_STAGE (
                                 clutter_stage_get_default ()), NULL);
}

void
hrn_toolbar_theatre_set_items (HrnToolbarTheatre *toolbar,
                               BklItem          **items,
                               int                current)
{
  HrnToolbarTheatrePrivate *priv;

  priv = toolbar->priv;

  hrn_thumb_bar_set_items ((HrnThumbBar *) priv->thumbbar, items);
  hrn_thumb_bar_set_current ((HrnThumbBar *) priv->thumbbar, current);
}
