#include <glib.h>
#include <bognor/br-iface-player.h>

#include "hrn-state-manager.h"
#include "hrn.h"

enum {
    PROP_0,
};

enum {
    PLAYING,
    POSITION_CHANGED,
    READY,
    PLAY_URI,
    LAST_SIGNAL
};

struct _HrnStateManagerPrivate {
    char *uri;
    gboolean ready;
    gboolean force_visual_mode;
    gboolean playing;
    gboolean can_show_visual;

    double progress;
};

static void hrn_state_manager_player_init (BrIfacePlayerClass *iface);
#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_STATE_MANAGER, HrnStateManagerPrivate))
G_DEFINE_TYPE_WITH_CODE (HrnStateManager, hrn_state_manager, G_TYPE_OBJECT,
                         G_IMPLEMENT_INTERFACE (BR_TYPE_IFACE_PLAYER,
                                                hrn_state_manager_player_init));
static guint32 signals[LAST_SIGNAL] = {0, };

static void
hrn_state_manager_finalize (GObject *object)
{
    G_OBJECT_CLASS (hrn_state_manager_parent_class)->finalize (object);
}

static void
hrn_state_manager_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_state_manager_parent_class)->dispose (object);
}

static void
hrn_state_manager_set_property (GObject      *object,
                                guint         prop_id,
                                const GValue *value,
                                GParamSpec   *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_state_manager_get_property (GObject    *object,
                                guint       prop_id,
                                GValue     *value,
                                GParamSpec *pspec)
{
    switch (prop_id) {

    default:
        break;
    }
}

static void
hrn_state_manager_class_init (HrnStateManagerClass *klass)
{
    GObjectClass *o_class = (GObjectClass *)klass;

    o_class->dispose = hrn_state_manager_dispose;
    o_class->finalize = hrn_state_manager_finalize;
    o_class->set_property = hrn_state_manager_set_property;
    o_class->get_property = hrn_state_manager_get_property;

    g_type_class_add_private (klass, sizeof (HrnStateManagerPrivate));

    signals[PLAYING] = g_signal_new ("playing",
                                     G_TYPE_FROM_CLASS (klass),
                                     G_SIGNAL_RUN_FIRST | G_SIGNAL_NO_RECURSE,
                                     0, NULL, NULL,
                                     g_cclosure_marshal_VOID__BOOLEAN,
                                     G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
    signals[POSITION_CHANGED] = g_signal_new ("progress-changed",
                                              G_TYPE_FROM_CLASS (klass),
                                              G_SIGNAL_RUN_FIRST |
                                              G_SIGNAL_NO_RECURSE,
                                              0, NULL, NULL,
                                              g_cclosure_marshal_VOID__DOUBLE,
                                              G_TYPE_NONE, 1, G_TYPE_DOUBLE);
    signals[READY] = g_signal_new ("ready",
                                   G_TYPE_FROM_CLASS (klass),
                                   G_SIGNAL_RUN_FIRST |
                                   G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                   g_cclosure_marshal_VOID__VOID,
                                   G_TYPE_NONE, 0);
    signals[PLAY_URI] = g_signal_new ("play-uri",
                                      G_TYPE_FROM_CLASS (klass),
                                      G_SIGNAL_RUN_FIRST |
                                      G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                      g_cclosure_marshal_VOID__STRING,
                                      G_TYPE_NONE, 1, G_TYPE_STRING);
}

static void
hrn_state_manager_init (HrnStateManager *self)
{
    HrnStateManagerPrivate *priv = GET_PRIVATE (self);

    self->priv = priv;
}

static gboolean
br_player_play (BrIfacePlayer *player,
                GError       **error)
{
    HrnStateManager *state = (HrnStateManager *) player;
    HrnStateManagerPrivate *priv = state->priv;

    priv->playing = TRUE;

    if (priv->ready) {
        g_signal_emit (state, signals[PLAYING], 0, TRUE);
    }

    return TRUE;
}

static gboolean
br_player_stop (BrIfacePlayer *player,
                GError       **error)
{
    HrnStateManager *state = (HrnStateManager *) player;
    HrnStateManagerPrivate *priv = state->priv;

    priv->playing = TRUE;

    if (priv->ready) {
        g_signal_emit (state, signals[PLAYING], 0, FALSE);
    }

    return TRUE;
}

static gboolean
br_player_set_position (BrIfacePlayer *player,
                        double         progress,
                        GError       **error)
{
    HrnStateManager *state = (HrnStateManager *) player;
    HrnStateManagerPrivate *priv = state->priv;

    priv->progress = progress;

    if (priv->ready) {
        g_signal_emit (player, signals[POSITION_CHANGED], 0, progress);
    }

    return TRUE;
}

static gboolean
br_player_show_uri (BrIfacePlayer  *player,
                    const char     *uri,
                    const char     *mimtype,
                    GError        **error)
{
    HrnStateManager *state = (HrnStateManager *) player;
    HrnStateManagerPrivate *priv = state->priv;

    if (priv->uri) {
        g_free (priv->uri);
    }

    priv->uri = g_strdup (uri);

    if (priv->ready) {
        g_signal_emit (state, signals[PLAY_URI], 0, priv->uri);
    }

    return TRUE;
}

static gboolean
br_player_can_show_visual (BrIfacePlayer *player,
                           gboolean      *can_show_visual,
                           GError       **error)
{
    HrnStateManager *state = (HrnStateManager *) player;
    HrnStateManagerPrivate *priv = state->priv;

    *can_show_visual = priv->can_show_visual;
    return TRUE;
}

static gboolean
br_player_force_visual_mode (BrIfacePlayer *player,
                             GError       **error)
{
    HrnStateManager *state = (HrnStateManager *) player;
    HrnStateManagerPrivate *priv = state->priv;

    if (priv->ready) {
        hrn_set_theatre ();
    } else {
        priv->force_visual_mode = TRUE;
    }

    return TRUE;
}

static void
hrn_state_manager_player_init (BrIfacePlayerClass *iface)
{
    iface->play = br_player_play;
    iface->stop = br_player_stop;
    iface->set_position = br_player_set_position;
    iface->show_uri = br_player_show_uri;
    iface->can_show_visual = br_player_can_show_visual;
    iface->force_visual_mode = br_player_force_visual_mode;
}

void
hrn_state_manager_set_uri (HrnStateManager *state,
                           const char      *uri)
{
    HrnStateManagerPrivate *priv = state->priv;

    if (priv->uri) {
        g_free (priv->uri);
    }

    priv->uri = g_strdup (uri);
}

const char *
hrn_state_manager_get_uri (HrnStateManager *state)
{
    HrnStateManagerPrivate *priv = state->priv;

    return priv->uri;
}

gboolean
hrn_state_manager_get_force_visual_mode (HrnStateManager *state)
{
    HrnStateManagerPrivate *priv = state->priv;

    return priv->force_visual_mode;
}

gboolean
hrn_state_manager_get_playing (HrnStateManager *state)
{
    HrnStateManagerPrivate *priv = state->priv;

    return priv->playing;
}

void
hrn_state_manager_ready (HrnStateManager *state)
{
    HrnStateManagerPrivate *priv = state->priv;

    priv->ready = TRUE;

    g_signal_emit (state, signals[READY], 0);
}

void
hrn_state_manager_set_can_show_visual (HrnStateManager *state,
                                       gboolean         can_show)
{
    HrnStateManagerPrivate *priv = state->priv;

    if (priv->can_show_visual != can_show) {
        priv->can_show_visual = can_show;
        br_iface_player_emit_can_show_visual_changed
            ((BrIfacePlayer *) state, priv->can_show_visual);
    }
}

double
hrn_state_manager_get_progress (HrnStateManager *state)
{
    HrnStateManagerPrivate *priv = state->priv;

    return priv->progress;
}
