/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <string.h>

#include "hrn-queue-group.h"

#include "hrn.h"
G_DEFINE_TYPE (HrnQueueGroup, hrn_queue_group, CLUTTER_TYPE_GROUP)

#define QUEUE_GROUP_PRIVATE(o) \
  (G_TYPE_INSTANCE_GET_PRIVATE ((o), HRN_TYPE_QUEUE_GROUP, HrnQueueGroupPrivate))


enum
{
  PROP_0,
};

enum
{
  LOADED,
  ERROR_LOADING,

  LAST_SIGNAL
};

static void
hrn_queue_group_finalize (GObject *object)
{
  G_OBJECT_CLASS (hrn_queue_group_parent_class)->finalize (object);
}

static void
hrn_queue_group_paint (ClutterActor *actor)
{
  GList         *child_item, *children;

  gint           sh;

  NbtkScrollBar *scrollbar =
    NBTK_SCROLL_BAR (nbtk_scroll_view_get_vscroll_bar (NBTK_SCROLL_VIEW (
                clutter_actor_get_parent (clutter_actor_get_parent (actor)))));
  gfloat scroll = nbtk_adjustment_get_value (
    nbtk_scroll_bar_get_adjustment (scrollbar));


  sh = clutter_actor_get_height (clutter_stage_get_default ());

  children = clutter_container_get_children (CLUTTER_CONTAINER (actor));

  for (child_item = children;
       child_item != NULL;
       child_item = child_item->next)
    {
      ClutterActor *child = child_item->data;

      g_assert (child != NULL);

      if (CLUTTER_ACTOR_IS_VISIBLE (child))
        {
          gint y;
          y = clutter_actor_get_y (child);
          if (y - scroll > -64 &&
              y - scroll < 300)
            clutter_actor_paint (child);
        }
    }
  g_list_free (children);
}


static void
hrn_queue_group_class_init (HrnQueueGroupClass *klass)
{
  GObjectClass      *object_class = G_OBJECT_CLASS (klass);
  ClutterActorClass *actor_class  = CLUTTER_ACTOR_CLASS (klass);

  object_class->finalize = hrn_queue_group_finalize;
  actor_class->paint     = hrn_queue_group_paint;
}

static void
hrn_queue_group_init (HrnQueueGroup *self)
{
}

ClutterActor *
hrn_queue_group_new (void)
{
  return g_object_new (HRN_TYPE_QUEUE_GROUP, NULL);
}
