#include <glib.h>

#include "hrn-tiler.h"

enum {
    LAST_SIGNAL
};

static void
hrn_tiler_base_init (gpointer klass)
{
    static gboolean initialized = FALSE;

    if (initialized) {
        return;
    }
    initialized = TRUE;
}

GType
hrn_tiler_get_type (void)
{
    static GType type = 0;

    if (!type) {
        const GTypeInfo info = {
            sizeof (HrnTilerInterface),
            hrn_tiler_base_init, NULL,
        };

        type = g_type_register_static (G_TYPE_INTERFACE,
                                       "HrnTiler", &info, 0);
    }

    return type;
}

void
hrn_tiler_show_all (HrnTiler *tiler)
{
    HRN_TILER_GET_CLASS (tiler)->show_all (tiler);
}

void
hrn_tiler_show (HrnTiler    *tiler,
                HrnTileable *tile)
{
    HRN_TILER_GET_CLASS (tiler)->show (tiler, tile);
}

void
hrn_tiler_set_expanded (HrnTiler *tiler,
                        gboolean  expanded)
{
    HRN_TILER_GET_CLASS (tiler)->set_expanded (tiler, expanded);
}

void
hrn_tiler_set_items_per_row (HrnTiler *tiler,
                             guint     items_per_row)
{
    HRN_TILER_GET_CLASS (tiler)->set_items_per_row (tiler,
                                                    items_per_row);
}

void
hrn_tiler_add_items (HrnTiler       *tiler,
                     HrnClusterNode *root)
{
    HRN_TILER_GET_CLASS (tiler)->add_items (tiler, root);
}

