#ifndef __HRN_THEATRE_UI_H__
#define __HRN_THEATRE_UI_H__

#include <clutter/clutter.h>
#include "hrn-cluster-node.h"

G_BEGIN_DECLS

#define HRN_TYPE_THEATRE_UI                                             \
   (hrn_theatre_ui_get_type())
#define HRN_THEATRE_UI(obj)                                             \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_THEATRE_UI,                    \
                                HrnTheatreUi))
#define HRN_THEATRE_UI_CLASS(klass)                                     \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_THEATRE_UI,                       \
                             HrnTheatreUiClass))
#define IS_HRN_THEATRE_UI(obj)                                          \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_THEATRE_UI))
#define IS_HRN_THEATRE_UI_CLASS(klass)                                  \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_THEATRE_UI))
#define HRN_THEATRE_UI_GET_CLASS(obj)                                   \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_THEATRE_UI,                     \
                               HrnTheatreUiClass))

typedef struct _HrnTheatreUiPrivate HrnTheatreUiPrivate;
typedef struct _HrnTheatreUi      HrnTheatreUi;
typedef struct _HrnTheatreUiClass HrnTheatreUiClass;

typedef void (*HrnTheatreUiFinishedCb) (HrnTheatreUi *ui,
                                        gboolean      shown,
                                        gpointer      userdata);
struct _HrnTheatreUi
{
    ClutterGroup parent;

    HrnTheatreUiPrivate *priv;
};

struct _HrnTheatreUiClass
{
    ClutterGroupClass parent_class;
};

GType hrn_theatre_ui_get_type (void) G_GNUC_CONST;

void hrn_theatre_ui_show (HrnTheatreUi          *ui,
                          HrnTheatreUiFinishedCb callback,
                          gpointer               userdata);
void hrn_theatre_ui_hide (HrnTheatreUi          *ui,
                          HrnTheatreUiFinishedCb callback,
                          gpointer               userdata);
void hrn_theatre_ui_show_node (HrnTheatreUi   *ui,
                               HrnClusterNode *node);
void hrn_theatre_ui_set_playing (HrnTheatreUi *ui,
                                 gboolean      playing);
void hrn_theatre_ui_show_uri (HrnTheatreUi *ui,
                              const char   *uri,
                              const char   *mimetype);
void hrn_theatre_ui_set_focused (HrnTheatreUi *ui,
                                 gboolean      focused);

G_END_DECLS

#endif /* __HRN_THEATRE_UI_H__ */
