/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <clutter/clutter.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "hrn.h"
#include "hrn-item-image.h"

G_DEFINE_TYPE (HrnItemImage, hrn_item_image, HRN_TYPE_ITEM);

#define HRN_ITEM_IMAGE_GET_PRIVATE(obj)                 \
  (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
                                HRN_TYPE_ITEM_IMAGE, \
                                HrnItemImagePrivate))

struct _HrnItemImagePrivate
{
  gchar *uri;
};

static GObject *
hrn_item_image_constructor (GType type, guint n_params,
                            GObjectConstructParam *params);
static void
hrn_item_image_dispose (GObject *object);

static void
hrn_item_image_class_init (HrnItemImageClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->dispose     = hrn_item_image_dispose;
  gobject_class->constructor = hrn_item_image_constructor;

  g_type_class_add_private (gobject_class, sizeof (HrnItemImagePrivate));
}

static void
hrn_item_image_init (HrnItemImage *self)
{
  HrnItemImagePrivate *priv = HRN_ITEM_IMAGE_GET_PRIVATE (self);

  memset (priv, 0, sizeof (priv));
}

static GObject *
hrn_item_image_constructor (GType type, guint n_params,
                            GObjectConstructParam *params)
{
  GObject      *object;
  HrnItemImage *item_image;

  object = G_OBJECT_CLASS (hrn_item_image_parent_class)->constructor (
    type, n_params, params);

  item_image = HRN_ITEM_IMAGE (object);


  return object;
}

static void
hrn_item_image_dispose (GObject *object)
{
  G_OBJECT_CLASS (hrn_item_image_parent_class)->dispose (object);
}


static ClutterActor *
item_image_alone (HrnSwitcher *switcher, guint state_no, gpointer userdata)
{
  ClutterActor *group      = clutter_group_new ();
  ClutterActor *item_image = hrn_make_element (userdata, HRN_SQUARE|HRN_PINCHABLE);

  clutter_actor_set_scale (item_image, 0.93, 0.93);
  clutter_actor_set_position (item_image, DIM * 0.023, DIM * 0.024);
  clutter_group_add (CLUTTER_GROUP (group), item_image);
  hrn_play_button_new (switcher, group, userdata);

  return group;
}

#if 0
static ClutterActor *
item_image_correct_dim (HrnSwitcher *switcher, guint state_no, gpointer userdata)
{
  ClutterActor *group      = clutter_group_new ();
  ClutterActor *item_image = item_image = hrn_make_element (userdata, 0);

  clutter_actor_set_scale (item_image, 0.95, 0.95);
  clutter_actor_set_position (item_image, DIM * 0.025, DIM * 0.025);
  clutter_group_add (CLUTTER_GROUP (group), item_image);
  hrn_play_button_new (switcher, group, userdata);

  return group;
}
#endif


#include <string.h>


HrnItemImage *
hrn_item_image_create (BklItem *item, gboolean square)
{
  HrnSwitcher *self = g_object_new (HRN_TYPE_ITEM_IMAGE, "item", item, NULL);


  HRN_ITEM (self)->item = item; /* XXX: take a reference ? */

  clutter_actor_set_size (CLUTTER_ACTOR (self), DIM, DIM);

  hrn_switcher_add_state_full (self, NULL, -1, 0.65,
                               item_image_alone, item,
                               NULL, NULL);
#if 0
  hrn_switcher_add_state_full (self, NULL, -1, 0.70,
                               item_image_correct_dim, item,
                               NULL, NULL);
#endif


  return HRN_ITEM_IMAGE (self);
}
