/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <bickley/bkl-item-extended.h>

#include "hrn.h"
#include "hrn-texture-cache.h"
#include <string.h>


#include <stdlib.h>

/* we should have an element factory for the actual content texture used
 * in switchers to enable loading them only once, and when needed only
 * in thumbnail form.
 */

static void
sync_size (ClutterActor *actor, gpointer unused, HrnSwitcher  *switcher)
{
  gfloat w, h;

  clutter_actor_get_size (actor, &w, &h);

  if (DIM / (w * 1.0) > DIM / (h * 1.0))
    {
      clutter_actor_set_scale (actor, DIM / (h * 1.0), DIM / (h * 1.0));
      clutter_actor_set_x (actor, (DIM - w * (DIM / (h * 1.0))) / 2);
      if (switcher)
        g_object_set_data (G_OBJECT (switcher), "x",
                           GINT_TO_POINTER ((gint)(DIM - w *
                                                   (DIM / (h * 1.0))) / 2));
    }
  else
    {
      clutter_actor_set_scale (actor, DIM / (w * 1.0), DIM / (w * 1.0));
      clutter_actor_set_y (actor, (DIM - h * (DIM / (w * 1.0))));
      if (switcher)
        g_object_set_data (G_OBJECT (switcher), "y",
                           GINT_TO_POINTER ((gint)(DIM - h * (DIM / (w * 1.0)))));
    }
  if (unused)
    clutter_actor_queue_redraw (hrn_window_get_stage (window));
}


static ClutterActor *
element_square (BklItem *item,
                gboolean pinchable)
{
  const char   *thumb = NULL;
  ClutterActor *actor;

  if (item)
    thumb = bkl_item_extended_get_thumbnail ((BklItemExtended *) item);

  if (thumb)
    {
      actor = hrn_texture_load_sq (thumb);
      /* g_signal_connect (actor, "notify::source", G_CALLBACK (sync_size),
         switcher); */

      if (pinchable)
        hrn_square_clone_set_can_pinch (actor, TRUE);

      clutter_actor_set_size (actor, DIM, DIM);

      if (bkl_item_get_item_type (item) == BKL_ITEM_TYPE_IMAGE)
        {
          const gchar *orientation = bkl_item_image_get_orientation (
            BKL_ITEM_IMAGE (item));

          if (orientation) /* this should probably happen through syncing */
            {
              if (g_str_equal (orientation, "right - top"))
                {
                  gfloat w, h;
                  clutter_actor_set_rotation (actor, CLUTTER_Z_AXIS, 90, 0, 0,
                                              0);
                  clutter_actor_set_anchor_point_from_gravity (
                    actor, CLUTTER_GRAVITY_SOUTH_WEST);
                  ClutterActor *group = clutter_group_new ();
                  clutter_group_add (group, actor);
                  clutter_actor_get_size (actor, &w, &h);
                  clutter_actor_set_size (group, h, w);
                  actor = group;
                }
            }
        }
      sync_size (actor, NULL, NULL);
    }
  else
    {
      const gchar *uri = bkl_item_get_uri (item);
      const gchar *string;
      ClutterColor label_color = { 0x00, 0x00, 0x00, 0xbb };

      if (bkl_item_get_item_type (item) == BKL_ITEM_TYPE_AUDIO)
        {
          actor = hrn_texture_load_sq (PKGDATADIR "hrn-generic-album.png");
          clutter_actor_set_size (actor, DIM, DIM);
          if (pinchable)
            hrn_square_clone_set_can_pinch (actor, TRUE);
          return actor;
        }
      else if (bkl_item_get_item_type (item) == BKL_ITEM_TYPE_VIDEO)
        {
          actor = hrn_texture_load_sq (PKGDATADIR "hrn-generic-video.png");
          clutter_actor_set_size (actor, DIM, DIM);
          if (pinchable)
            hrn_square_clone_set_can_pinch (actor, TRUE);
          return actor;
        }
      else if (bkl_item_get_item_type (item) == BKL_ITEM_TYPE_IMAGE)
        {
          actor = hrn_texture_load_sq (PKGDATADIR "hrn-generic-images.png");
          clutter_actor_set_size (actor, DIM, DIM);
          if (pinchable)
            hrn_square_clone_set_can_pinch (actor, TRUE);
          return actor;
        }

      string = uri ? strrchr (uri, '/') : NULL;
      if (string)
        string = string + 1;
      else
        string = uri;
      actor = clutter_text_new_with_text ("Sans 20px", string);
      clutter_text_set_color (CLUTTER_TEXT (actor), &label_color);
    }
  return actor;
}


static ClutterActor *
element_thumb (HrnSwitcher *switcher, guint state_no, gpointer userdata)
{
  BklItem      *item  = (BklItem *) userdata;
  const char   *thumb = NULL;
  ClutterActor *actor;

  if (userdata)
    thumb = bkl_item_extended_get_thumbnail ((BklItemExtended *) item);

  if (thumb)
    {
      actor = hrn_texture_load (thumb);
      g_signal_connect (actor, "notify::source", G_CALLBACK (
                          sync_size), switcher);

      if (bkl_item_get_item_type (item) == BKL_ITEM_TYPE_IMAGE)
        {
          const gchar *orientation = bkl_item_image_get_orientation (
            BKL_ITEM_IMAGE (item));

          if (orientation) /* this should probably happen through syncing */
            {
              if (g_str_equal (orientation, "right - top"))
                {
                  gfloat w, h;
                  clutter_actor_set_rotation (actor, CLUTTER_Z_AXIS, 90, 0, 0,
                                              0);
                  clutter_actor_set_anchor_point_from_gravity (
                    actor, CLUTTER_GRAVITY_SOUTH_WEST);
                  clutter_actor_get_size (actor, &w, &h);
                }
            }
        }
      sync_size (actor, NULL, switcher);
    }
  else
    {
      const gchar *uri = bkl_item_get_uri (item);
      const gchar *string;
      ClutterColor label_color = { 0x00, 0x00, 0x00, 0xbb };

      if (bkl_item_get_item_type (item) == BKL_ITEM_TYPE_AUDIO)
        {
          actor = hrn_texture_load (PKGDATADIR "hrn-generic-album.png");
          clutter_actor_set_size (actor, DIM, DIM);
          return actor;
        }

      string = uri ? strrchr (uri, '/') : NULL;
      if (string)
        string = string + 1;
      else
        string = uri;
      actor = clutter_text_new_with_text ("Sans 20px", string);
      clutter_text_set_color (CLUTTER_TEXT (actor), &label_color);
    }
  return actor;
}

#if HRN_ELEMENT_LOAD_FULL

/* FIXME: remove group */
static ClutterActor *
element_original (HrnSwitcher *switcher, guint state_no, gpointer userdata)
{
  BklItem      *item = (BklItem *) userdata;
  GFile        *file;
  const char   *uri;
  gchar        *path  = NULL;
  ClutterActor *group = clutter_group_new ();
  ClutterActor *actor;

  uri  = bkl_item_get_uri (item);
  file = g_file_new_for_uri (uri);
  path = g_file_get_path (file);

  if (path)
    {
      gfloat w, h;
      actor = hrn_texture_load (path);
      clutter_actor_get_size (actor, &w, &h);

      if (DIM / (w * 1.0) > DIM / (h * 1.0))
        {
          clutter_actor_set_scale (actor, DIM / (h * 1.0), DIM / (h * 1.0));
          clutter_actor_set_x (actor, (DIM - w * (DIM / (h * 1.0))) / 2);
        }
      else
        {
          clutter_actor_set_scale (actor, DIM / (w * 1.0), DIM / (w * 1.0));
          clutter_actor_set_y (actor, (DIM - h * (DIM / (w * 1.0))));
        }
      g_free (path);
    }
  else
    {
      gchar       *string = userdata;
      ClutterColor yellow = { 0xff, 0xff, 0x99, 0xff };
      string = strrchr (string, '/');
      if (string)
        string = string + 1;
      else
        string = "eek";
      actor = clutter_text_new_with_text ("Sans 20px", string);
      clutter_text_set_color (CLUTTER_TEXT (actor), &yellow);
    }
  clutter_group_add (CLUTTER_GROUP (group), actor);
  g_object_unref (file);
  return group;
}
#endif

ClutterActor *
hrn_make_element (BklItem *element,
                  gint     flags)
{
  HrnSwitcher *switcher;

#if HRN_JUST_RECTANGLES
  { ClutterActor *rect = clutter_rectangle_new ();
    ClutterColor  red  = { 0xff, 0, 0, 0xff };
    clutter_actor_set_size (rect, DIM, DIM);
    clutter_rectangle_set_color (CLUTTER_RECTANGLE (rect), &red);
    return rect; }
#endif

  /* 33 for initial set
   * 221 for first transition
   * 150 for second transition
   */

  if (flags & HRN_SQUARE)
    {
      ClutterActor *ret = element_square (element, flags & HRN_PINCHABLE);
      return ret;
    }

  if (element == NULL)
    {
      ClutterActor *rect = clutter_rectangle_new ();
      ClutterColor  red  = { 0xff, 0, 0, 0xff };
      clutter_actor_set_size (rect, DIM, DIM);
      clutter_rectangle_set_color (CLUTTER_RECTANGLE (rect), &red);
      return rect;
    }

  switcher = hrn_switcher_new (DIM, DIM);

  hrn_switcher_add_state_full (switcher, NULL, -1, 1.0,
                               element_thumb, element,
                               NULL, NULL);

#if HRN_ELEMENT_LOAD_FULL
  hrn_switcher_add_state_full (switcher, NULL, -1, 20.0,
                               element_original, element,
                               NULL, NULL);
  hrn_switcher_add_state_full (switcher, NULL, -1, 20.2,
                               element_thumb, element,
                               NULL, NULL);
#endif

  hrn_switcher_set_state_no (switcher, 1);

  return CLUTTER_ACTOR (switcher);
}
