#include <glib/gi18n.h>

#include "hrn-cluster-node.h"
#include "hrn-album-cluster.h"

enum {
    PROP_0,
    PROP_NODE,
};

struct _HrnAlbumClusterPrivate {
    HrnClusterNode *node;
    guint32 visibility_id;
    guint32 added_id;
    guint32 removed_id;
};

static gboolean debug_visible = FALSE;

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), HRN_TYPE_ALBUM_CLUSTER, HrnAlbumClusterPrivate))
G_DEFINE_TYPE (HrnAlbumCluster, hrn_album_cluster, HRN_TYPE_CLUSTER);

static void
hrn_album_cluster_finalize (GObject *object)
{
    HrnAlbumCluster *artist = (HrnAlbumCluster *) object;
    HrnAlbumClusterPrivate *priv = artist->priv;

    if (priv->visibility_id) {
        g_signal_handler_disconnect (priv->node, priv->visibility_id);
        priv->visibility_id = 0;
    }

    G_OBJECT_CLASS (hrn_album_cluster_parent_class)->finalize (object);
}

static void
hrn_album_cluster_dispose (GObject *object)
{
    G_OBJECT_CLASS (hrn_album_cluster_parent_class)->dispose (object);
}

static void
node_visibility_changed (HrnClusterNode  *node,
                         gboolean         hidden,
                         HrnAlbumCluster *cluster)
{
    if (debug_visible) {
        g_print ("[album] %s %s\n", node->name, hidden ? "hidden" : "shown");
    }
    hrn_tileable_visibility_changed ((HrnTileable *) cluster, hidden);
}

static void
hrn_album_cluster_set_property (GObject      *object,
                                guint         prop_id,
                                const GValue *value,
                                GParamSpec   *pspec)
{
    HrnAlbumCluster *self = (HrnAlbumCluster *) object;
    HrnAlbumClusterPrivate *priv = self->priv;
    AlbumCluster *album_cluster;
    const char *artist;

    switch (prop_id) {
    case PROP_NODE:
        priv->node = g_value_get_pointer (value);
        priv->visibility_id = g_signal_connect
            (priv->node, "visibility-changed",
             G_CALLBACK (node_visibility_changed), self);
        clutter_actor_set_name ((ClutterActor *) self, priv->node->name);

        album_cluster = (AlbumCluster *) priv->node->data;
        if (album_cluster->artists->len == 0) {
            artist = _("Unknown");
        } else {
            /* FIXME: Use all artists... */
            artist = album_cluster->artists->pdata[0];
        }

        g_object_set (self,
                      "primary", priv->node->name,
                      "secondary", artist,
                      NULL);
        break;

    default:
        break;
    }
}

static void
hrn_album_cluster_get_property (GObject    *object,
                                guint       prop_id,
                                GValue     *value,
                                GParamSpec *pspec)
{
}

static HrnClusterNode *
hrn_album_cluster_get_node (HrnCluster *cluster)
{
    HrnAlbumCluster *album_cluster = (HrnAlbumCluster *) cluster;
    HrnAlbumClusterPrivate *priv = album_cluster->priv;

    return priv->node;
}

static const char *
hrn_album_cluster_get_label (HrnCluster *cluster)
{
    return _("Queue Album");
}

static void
hrn_album_cluster_class_init (HrnAlbumClusterClass *klass)
{
    GObjectClass *o_class = (GObjectClass *) klass;
    HrnClusterClass *c_class = (HrnClusterClass *) klass;

    o_class->dispose = hrn_album_cluster_dispose;
    o_class->finalize = hrn_album_cluster_finalize;
    o_class->set_property = hrn_album_cluster_set_property;
    o_class->get_property = hrn_album_cluster_get_property;

    c_class->get_node = hrn_album_cluster_get_node;
    c_class->get_label = hrn_album_cluster_get_label;

    g_type_class_add_private (klass, sizeof (HrnAlbumClusterPrivate));

    g_object_class_override_property (o_class, PROP_NODE, "node");
}

static void
hrn_album_cluster_init (HrnAlbumCluster *self)
{
    HrnAlbumClusterPrivate *priv = GET_PRIVATE (self);
    self->priv = priv;
}

