import Qt 4.7

GridView {
    property int min_horizontal_spacing: 0
    property int min_vertical_spacing: 0
    property int delegate_width: 100
    property int delegate_height: 100

    /* Compute the number of cells per line and column so that:
        - the items are always centered horizontally within the grid (= same
          margins on the right and left sides of the grid)
        - the spacing between items is kept as small as possible but always
          greater than min_horizontal_spacing and min_vertical_spacing
        - a non integer number of lines is shown as to indicate the
          availability of more lines to the user and incitate scrolling
    */
    property real cells_per_line: Math.floor(width/(min_horizontal_spacing+delegate_width))
    property real cells_per_column: Math.floor(height/(min_vertical_spacing+delegate_height))
    property int horizontal_spacing: Math.floor(width/cells_per_line-delegate_width)
    property int vertical_spacing: Math.floor(height/cells_per_column-delegate_height)

    cellWidth: delegate_width+horizontal_spacing
    cellHeight: delegate_height+vertical_spacing
}
