#!/bin/bash

# Author: Taiten Peng <taiten.peng@canonical.com>

LOGFILE=/tmp/tmp.gdm.log

if [ -e /tmp/xkb_disable ]
then
   cp -vf /tmp/xkb_disable /var/lib/gdm/xkb_disable 2>&1|tee >> $LOGFILE
fi

if [ -e /tmp/xkb_variant ]
then
   cp -vf /tmp/xkb_variant /var/lib/gdm/xkb_variant 2>&1|tee >> $LOGFILE
fi

if [ -e /tmp/xkb_layout ]
then
   cp -fv /tmp/xkb_layout /var/lib/gdm/xkb_layout 2>&1 |tee >> $LOGFILE
fi

if [ -e /var/lib/gdm/xkb_disable ]
then
   if [ "1" = `cat /var/lib/gdm/xkb_disable` ]
   then
   gconftool-2 -s /apps/gdm/simple-greeter/recent-layouts -t string ""
   echo "xkb disabled" >> $LOGFILE
   exit 0
   fi
fi

if [ -e /var/lib/gdm/xkb_layout ]
then
   if [ -e /var/lib/gdm/xkb_variant ]
   then
   tmplayout=`cat /var/lib/gdm/xkb_layout`
   tmpvar=`cat /var/lib/gdm/xkb_variant`
   setxkbmap $tmplayout $tmpvar
   echo "Change keyboard layout to $tmplayout" and keyboard variant to $tmpvar 2>&1 |tee >> $LOGFILE
   else
   tmplayout=`cat /var/lib/gdm/xkb_layout`
   setxkbmap $tmplayout
   echo "Change keyboard layout to $tmplayout" 2>&1 |tee >> $LOGFILE
   fi
fi

exit 0
