#ifndef SUPPORT_H
#define SUPPORT_H

#include <gtk/gtk.h>
#include <math.h>
#include <string.h>

#include "murrine_types.h"

/* GTK 2.2 compatibility */
#ifndef GTK_IS_COMBO_BOX_ENTRY
	#define GTK_IS_COMBO_BOX_ENTRY(x) 0
#endif
#ifndef GTK_IS_COMBO_BOX
	#define GTK_IS_COMBO_BOX(x) 0
#endif

#define RADIO_SIZE 13
#define CHECK_SIZE 13

G_GNUC_INTERNAL GtkTextDirection murrine_get_direction (GtkWidget *widget);

G_GNUC_INTERNAL gboolean  	murrine_sanitize_size (GdkWindow *window, gint *width, gint *height);

G_GNUC_INTERNAL GtkWidget 	*murrine_special_get_ancestor (GtkWidget *widget, GType widget_type);

G_GNUC_INTERNAL void       	murrine_shade (const MurrineRGB *a, MurrineRGB *b, float k);
			
G_GNUC_INTERNAL GtkWidget*  murrine_get_parent_window (GtkWidget *widget);

G_GNUC_INTERNAL GdkColor*   murrine_get_parent_bgcolor (GtkWidget *widget);

G_GNUC_INTERNAL gboolean    mrn_is_combo_box (GtkWidget *widget);

G_GNUC_INTERNAL GtkWidget*  mrn_find_combo_box_widget(GtkWidget *widget);

G_GNUC_INTERNAL void  			murrine_gdk_color_to_rgb   (GdkColor *c, double *r, double *g, double *b);

G_GNUC_INTERNAL void  			murrine_gtk_treeview_get_header_index (GtkTreeView *tv,
                                                 GtkWidget    *header,
                                                 gint         *column_index,
                                                 gint         *columns,
                                                 gboolean     *resizable);

G_GNUC_INTERNAL void  			murrine_gtk_clist_get_header_index (GtkCList *clist,
                                                 GtkWidget    *button,
                                                 gint         *column_index,
                                                 gint         *columns);

G_GNUC_INTERNAL void  			murrine_get_parent_bg (const GtkWidget *widget, MurrineRGB *color);

G_GNUC_INTERNAL void  			murrine_option_menu_get_props (GtkWidget *widget,
                                                 GtkRequisition  *indicator_size,
                                                 GtkBorder       *indicator_spacing);

G_GNUC_INTERNAL MurrineStepper murrine_scrollbar_get_stepper (GtkWidget *widget, GdkRectangle *stepper);

G_GNUC_INTERNAL MurrineStepper murrine_scrollbar_visible_steppers (GtkWidget *widget);

G_GNUC_INTERNAL MurrineJunction murrine_scrollbar_get_junction (GtkWidget *widget);

G_GNUC_INTERNAL gboolean    mrn_is_panel_widget (GtkWidget *widget);

#endif /* SUPPORT_H */
