/*
 * Copyright 2003-2007 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.codehaus.groovy.runtime.callsite;

import org.codehaus.groovy.reflection.ClassLoaderForClassArtifacts;

import java.util.Set;
import java.util.HashSet;
import java.util.Collections;

public class CallSiteClassLoader extends ClassLoaderForClassArtifacts {

    private final static Set<String> knownClasses = new HashSet<String>();
    static {
        Collections.addAll(knownClasses
                , "org.codehaus.groovy.runtime.callsite.PogoMetaMethodSite"
                , "org.codehaus.groovy.runtime.callsite.PojoMetaMethodSite"
                , "org.codehaus.groovy.runtime.callsite.StaticMetaMethodSite"
                , "org.codehaus.groovy.runtime.callsite.CallSite"
                , "org.codehaus.groovy.runtime.callsite.CallSiteArray"
                , "groovy.lang.MetaMethod"
                , "groovy.lang.MetaClassImpl"
                );
    }

    public CallSiteClassLoader(Class klazz) {
        super(klazz);
    }

    protected synchronized Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (knownClasses.contains(name))
          return getClass().getClassLoader().loadClass(name);
        else {
            try {
                return super.loadClass(name, resolve);
            }
            catch (ClassNotFoundException e) {
                return getClass().getClassLoader().loadClass(name);
            }
        }
    }

}
