// PidginHandleContactDetailItem.cs
// 
// GNOME Do is the legal property of its developers, whose names are too numerous
// to list here.  Please refer to the COPYRIGHT file distributed with this
// source distribution.
// 
// This program is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program.  If not, see <http://www.gnu.org/licenses/>.
//

using System;

using Do.Universe;

namespace PidginPlugin
{

	class PidginHandleContactDetailItem : Item, IContactDetailItem
	{

		string proto, handle;

		public PidginHandleContactDetailItem (string proto, string handle)
		{
			this.proto = proto;
			this.handle = handle;
		}

		public override string Name {
			get {
				return string.Format ("{0} ({1})", handle, ReadableProto (proto));
			}
		}

		public override string Description {
			get {
				return ReadableProto (proto) + " " + "Handle" ;
			}
		}

		public override string Icon {
			get { return Pidgin.GetProtocolIcon (proto); }
		}

		public string Key {
			get { return proto; }
		}

		public string Value {
			get { return handle; }
		}

		string ReadableProto (string proto)
		{
			switch (proto) {
			case "prpl-aim":		return "AIM";
			case "prpl-jabber":	return "Jabber";
			default:						return proto;
			}
		}
	}
}
