with Ada.Text_IO;
with OCI.Thick.Lobs;
with OCI.Thick.Binds.Lob;
with OCI.Thick.Connections;
with OCI.Thick.Statements;
with OCI.Thick.Strings;

procedure Lob is
   use OCI.Thick;
   use Ada.Text_IO;

   Connect : Connections.Connection := Connections.Logon ("scott/tiger");
   Stmt    : Statements.Statement;
   Loc : Lobs.Lob := Lobs.Create_Empty (Connect);
   BLoc : Binds.Lob.Bind_Lob;

   Result : Strings.Variable;

begin
   Stmt := Statements.Prepare
     (Connect,
     "begin "
   & "   if :Clob is null then"
   & "      :Result := ' clob is null.';"
   & "   else"
   & "      :Result := ' clob exist.';"
   & "   end if; "
   & "end;");

   Binds.Lob.Bind (Stmt, BLoc, Loc, "Clob");
   Strings.Bind (Stmt, Result, "Result");

   Statements.Execute (Stmt);
   Put_Line (Boolean'Image (Lobs.Is_Init (Loc)) & Strings.Value (Result));

   Lobs.Create_Temporary (Loc);
   Binds.Lob.Bind (Stmt, BLoc, Loc, "Clob");
   Statements.Execute (Stmt);
   Put_Line (Boolean'Image (Lobs.Is_Init (Loc)) & Strings.Value (Result));

   Lobs.Free_Temporary (Loc);
   Put_Line (Boolean'Image (Lobs.Is_Init (Loc)));
end Lob;
