//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************

#ifndef _QUANTIZATION_H_
#define _QUANTIZATION_H_
#include "macros.h"

typedef struct RateDistNmr
{
  Int    cBitsNonHeader;    // size of encoded data (not including size of header)
  Int    cBitsHeader;       // size of just the header
  int    intInvQuantStep;   // pow(10, -intStepSize*0.05)
  int    intNmr;            // achieved Nmr
  int    intLogNmr;         // log10(fltNmr)
  Bool   fQuantOverflow;    // if quant saturation happened while coding
  Bool   fCoded;            // actually coded, or bogus
  Bool   fInferiorPoint;    // a coded point higher or lower is better
  Bool   fAcceptable;       // Neither over bit limit nor saturates quant
  Bool   fValidBitCnt;      // Whether bit counting actually took place for this data point.
} RateDistNmr;

#endif //_QUANTIZATION_H_
