//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************


#ifndef _LPFMACRO_H_
#define _LPFMACRO_H_

///////////////////////////// Integerized Versions /////////////////////////////
// Mess alert: the following two macros make the following assumptions:
// 1) A call to FIVE_TAP_IIR_INT_NUMERATOR is always followed (eventually)
//    by a call to FIVE_TAP_IIR_FLOAT_DENOMINATOR.
// 2) These macros assume that certain variables are present.
#define FIVE_TAP_IIR_VARIABLES                                      \
    Int output[4096];                                               \
    Float fltSumSquared=0;                                          \
    int j;                                                          \
    Int iSrcCurr = *piSrcCurr;                                      \
    Int nextStop = iSliceIncr; // Needed by *_DENOMINATOR macro

#define FIVE_TAP_IIR_INT_NUMERATOR                                  \
    assert(iSourceLength<=4096);                                    \
    for (j = 0; j < iSourceLength; j++) {                           \
        Int iDst = 0;                                               \
        const I16 *piCoefNum = (const I16 *)rgiCoefNum;             \
        iDst += piCoefNum[0] * *piSource;                           \
        iDst += piCoefNum[1] * rgiSrc[iSrcCurr + 0];                \
        iDst += piCoefNum[2] * rgiSrc[iSrcCurr + 1];                \
        iDst += piCoefNum[3] * rgiSrc[iSrcCurr + 2];                \
        iDst += piCoefNum[4] * rgiSrc[iSrcCurr + 3];                \
                                                                    \
        iSrcCurr = c_minus1Mod4[iSrcCurr];                          \
        rgiSrc[iSrcCurr] = rgiSrc[iSrcCurr + ORDER] = *piSource;    \
                                                                    \
        piSource += cChannel;                                       \
        output[j] = iDst;                                           \
    }                                                               \
    *piSrcCurr = iSrcCurr;                                          \


#define FIVE_TAP_IIR_FLOAT_DENOMINATOR_VARIABLES                    \
    Int iDstCurr = *piDstCurr;                                      \
    const Int c_minus1Mod4[] = {3, 0, 1, 2};                        \
    const Int ORDER = 4;                                            \
    const int c_iSliceMask = iSliceIncr - 1;                        \

#define FIVE_TAP_IIR_FLOAT_DENOMINATOR(invScale,position)           \
    for (j = 0; j < iSourceLength; ) {                              \
        Float fltDst;                                               \
                                                                    \
        assert (rgfltCoefDen[0] == 1.0F);                           \
        assert (iDstCurr >= 0 && iDstCurr < 4);                     \
                                                                    \
        fltDst = (float)output[j] * invScale -                      \
                  rgfltCoefDen[1] * rgfltDst[iDstCurr + 0] -        \
                  rgfltCoefDen[2] * rgfltDst[iDstCurr + 1] -        \
                  rgfltCoefDen[3] * rgfltDst[iDstCurr + 2] -        \
                  rgfltCoefDen[4] * rgfltDst[iDstCurr + 3];         \
                                                                    \
        iDstCurr = c_minus1Mod4[iDstCurr];                          \
        rgfltDst[iDstCurr] = rgfltDst[iDstCurr + ORDER] = fltDst;   \
                                                                    \
        fltSumSquared += fltDst * fltDst;                           \
                                                                    \
        j += 1;                                                     \
        if ((j & c_iSliceMask) == 0) {                        \
            FLOATORINT_ASSERT(FLOATORU32_DISCARDBITSFROMFLT(fltSumSquared,      \
                TRANSIENT_BITDISCARD) <= UINT_MAX);                             \
            pfltPower[position] = FLOATORU32_DISCARDBITSFROMFLT(fltSumSquared,  \
                TRANSIENT_BITDISCARD);                                          \
            pfltPower+=3;                                           \
            fltSumSquared = 0;                                      \
        } /* if */                                                  \
    } /* for */                                                     \
    *piDstCurr = iDstCurr;                                          \



// Mess alert: the following two macros make the following assumptions:
// 1) A call to FOUR_TAP_IIR_INT_NUMERATOR is always followed (eventually)
//    by a call to FOUR_TAP_IIR_FLOAT_DENOMINATOR.
// 2) These macros assume that certain variables are present.
#define FOUR_TAP_IIR_VARIABLES                                      \
    Float fltSumSquared=0;                                          \
    int j;                                                          \
    Int output[4096];                                               \
    Int iSrcCurr = *piSrcCurr;                                      \


#define FOUR_TAP_IIR_FLOAT_DENOMINATOR_VARIABLES                    \
    Int iDstCurr = *piDstCurr;                                      \
    const Int c_minus1Mod3[] = {2, 0, 1};                           \
    const Int ORDER = 3;                                            \
    const int c_iSliceMask = iSliceIncr - 1;                        \


#define FOUR_TAP_IIR_INT_NUMERATOR                                  \
    assert(iSourceLength<=4096);                                    \
    for (j = 0; j < iSourceLength; j++) {                           \
        Int iDst = 0;                                               \
        const I16 *piCoefNum = (const I16 *)rgiCoefNum;             \
        iDst += piCoefNum[0] * *piSource;                           \
        iDst += piCoefNum[1] * rgiSrc[iSrcCurr + 0];                \
        iDst += piCoefNum[2] * rgiSrc[iSrcCurr + 1];                \
        iDst += piCoefNum[3] * rgiSrc[iSrcCurr + 2];                \
                                                                    \
        iSrcCurr = c_minus1Mod3[iSrcCurr];                          \
        rgiSrc[iSrcCurr] = rgiSrc[iSrcCurr + ORDER] = *piSource;    \
                                                                    \
        piSource += cChannel;                                       \
        output[j] = iDst;                                           \
    }                                                               \
    *piSrcCurr = iSrcCurr;                                          \


#define FOUR_TAP_IIR_FLOAT_DENOMINATOR(invScale,position)           \
    for (j = 0; j < iSourceLength; ) {                              \
        Float fltDst;                                               \
                                                                    \
        assert (rgfltCoefDen[0] == 1.0F);                           \
        assert (iDstCurr >= 0 && iDstCurr < 3);                     \
                                                                    \
        fltDst = (float)output[j] * invScale -                      \
                  rgfltCoefDen[1] * rgfltDst[iDstCurr + 0] -        \
                  rgfltCoefDen[2] * rgfltDst[iDstCurr + 1] -        \
                  rgfltCoefDen[3] * rgfltDst[iDstCurr + 2];         \
                                                                    \
        iDstCurr = c_minus1Mod3[iDstCurr];                          \
        rgfltDst[iDstCurr] = rgfltDst[iDstCurr + ORDER] = fltDst;   \
                                                                    \
        fltSumSquared += fltDst * fltDst;                           \
                                                                    \
        j += 1;                                                     \
        if ((j & c_iSliceMask) == 0) {                        \
            FLOATORINT_ASSERT(FLOATORU32_DISCARDBITSFROMFLT(fltSumSquared,      \
                TRANSIENT_BITDISCARD) <= UINT_MAX);                             \
            pfltPower[position] = FLOATORU32_DISCARDBITSFROMFLT(fltSumSquared,  \
                TRANSIENT_BITDISCARD);                                          \
            pfltPower+=3;                                           \
            fltSumSquared = 0;                                      \
        } /* if */                                                  \
    } /* for */                                                     \
    *piDstCurr = iDstCurr;                                          \


#define FOUR_TAP_IIR_FLOAT_VARIABLES                                \
    Double fltSumSquared=0;                                         \
    int j;                                                          \
    Double output[4096];                                            \
    Int nextStop = iSliceIncr; /* Needed by *_DENOMINATOR macro */  \
    Int iSrcCurr = *piSrcCurr;                                      \


#define FOUR_TAP_IIR_FLOAT_NUMERATOR                                \
    assert(iSourceLength<=4096);                                    \
    for (j = 0; j < iSourceLength; j++) {                           \
        Float iDst = 0;                                             \
        Float *piCoefNum = rgfltCoefNum;                            \
        iDst += piCoefNum[0] * *piSource;                           \
        iDst += piCoefNum[1] * rgiSrc[iSrcCurr + 0];                \
        iDst += piCoefNum[2] * rgiSrc[iSrcCurr + 1];                \
        iDst += piCoefNum[3] * rgiSrc[iSrcCurr + 2];                \
                                                                    \
        iSrcCurr = c_minus1Mod3[iSrcCurr];                          \
        rgiSrc[iSrcCurr] = rgiSrc[iSrcCurr + ORDER] = *piSource;    \
                                                                    \
        piSource += cChannel;                                       \
        output[j] = iDst;                                           \
    }                                                               \
    *piSrcCurr = iSrcCurr;                                          \


#define FOUR_TAP_IIR_INT_DENOMINATOR_VARIABLES                                          \
    I64 iPwr = 0;                                                                       \
    const int c_iSliceMask = iSliceIncr - 1;                                            \


#define FOUR_TAP_IIR_INT_DENOMINATOR(iNumeratorScalePwr, iDenominatorScalePwr,          \
                                     position)                                          \
    assert(0 == ((iSliceIncr - 1) & iSliceIncr)); /* Must be power of 2 */              \
    for (j = 0; j < iSourceLength; j++)                                                 \
    {                                                                                   \
        const U32 *pfltCoefDen = rgiCoefDen;                                            \
        const Int iDstCurr = *piDstCurr;                                                \
        const U32 c_iDstMask = 3; /* Destination must be in set (0,1,2,3) */            \
        I64 fltDst;                                                                     \
        I32 *pfltDstHistory = (I32 *)rgfltDst;                                          \
                                                                                        \
        /* Apply first coefficient */                                                   \
        assert (*pfltCoefDen == ((I64)1 << iDenominatorScalePwr));                      \
        fltDst = (I64)*pfltCoefDen * (I64)output[j];                                    \
        pfltCoefDen += 1;                                                               \
                                                                                        \
        assert (iDstCurr >= 0 && iDstCurr < 4);                                         \
        assert(((U32)pfltDstHistory & c_iDstMask) == 0);                                \
                                                                                        \
        /* Second coef (unrolled loop) */                                               \
        fltDst += (I64)*pfltCoefDen * (I64)pfltDstHistory[(iDstCurr - 1) & c_iDstMask]; \
        pfltCoefDen += 1;                                                               \
                                                                                        \
        /* Third coef (unrolled loop) */                                                \
        fltDst -= (I64)*pfltCoefDen * (I64)pfltDstHistory[(iDstCurr - 2) & c_iDstMask]; \
        pfltCoefDen += 1;                                                               \
                                                                                        \
        /* Fourth coef (unrolled loop) */                                               \
        fltDst += (I64)*pfltCoefDen * (I64)pfltDstHistory[(iDstCurr - 3) & c_iDstMask]; \
        pfltCoefDen += 1;                                                               \
                                                                                        \
        /* Truncate to I32 before saving to history */                                  \
        fltDst >>= iDenominatorScalePwr;                                                \
        assert(fltDst <= (I64)INT_MAX);                                                 \
        fltDst = (I32)(fltDst);                                                         \
                                                                                        \
        pfltDstHistory[iDstCurr] = (I32)fltDst;                                         \
        *piDstCurr = (iDstCurr + 1) & c_iDstMask;                                       \
                                                                                        \
        /* Convert to whole number so we can square it for power calculation */         \
        fltDst >>= iNumeratorScalePwr;                                                  \
        iPwr += fltDst * fltDst;                                                        \
                                                                                        \
        if (((j + 1) & c_iSliceMask) == 0)                                              \
        {                                                                               \
            FLOATORINT_ASSERT(FLOATORU32_DISCARDBITSFROMI64(iPwr,                       \
                TRANSIENT_BITDISCARD) <= UINT_MAX);                                     \
            pfltPower[position] = (FLOATORU32) FLOATORU32_DISCARDBITSFROMI64(iPwr,      \
                TRANSIENT_BITDISCARD);                                                  \
            pfltPower += 3;                                                             \
            iPwr = 0;                                                                   \
        } /* if */                                                                      \
    } /* for */                                                                         \

#endif // _LPFMACRO_H_
