#include "fontzoom.h"

#define PKGDIR "/usr/share/fontzoom/data/"
#define P //printf

gboolean status = FALSE;
GtkWidget *window = NULL;
gint timeoutsign = TRUE;

gint hide_window(gpointer data)
{
	gtk_widget_hide(window);
	P("1hide\n");
	status = FALSE;
	return 0;
}

static gboolean
focus_out_event_cb(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
	gtk_widget_hide(window);
	status = FALSE;
	return TRUE;
}

static gboolean
font_zoom_in_cb(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
	Display* disp = XOpenDisplay( NULL );
	
	if( disp == NULL )
		return FALSE;

	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Control_L), True, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_L), True, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Up), True, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Up), False, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_L), False, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Control_L), False, CurrentTime );
	XCloseDisplay( disp );
	gtk_timeout_remove(timeoutsign);
	timeoutsign = g_timeout_add(6000, hide_window, data);  
	
	return FALSE;
}

static gboolean
font_zoom_out_cb(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
	Display* disp = XOpenDisplay( NULL );
	
	if( disp == NULL )
		return FALSE;

	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Control_L), True, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_L), True, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Down), True, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Down), False, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Alt_L), False, CurrentTime );
	XTestFakeKeyEvent( disp, XKeysymToKeycode( disp, XK_Control_L), False, CurrentTime );
	XCloseDisplay( disp );
	gtk_timeout_remove(timeoutsign);
	timeoutsign = g_timeout_add(6000, hide_window, data);  

	return FALSE;
}

static void
popup_set_font_window_cb(GtkWidget *widget, GdkEventButton *event, gpointer data)
{
	GtkWidget *box, *lbutton, *rbutton, *limage, *rimage;

	if(status)
	{
		gtk_widget_hide(window);
		status = FALSE;
		gtk_timeout_remove(timeoutsign);
		return;
	}
	else if(window)
	{
		gtk_widget_show(window);
		status = TRUE;
		timeoutsign = g_timeout_add(6000, hide_window, data);  
		return;
	}

	
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size(GTK_WINDOW(window), 20, 20);
	gtk_window_set_decorated (GTK_WINDOW(window), FALSE);
 	gtk_window_set_skip_taskbar_hint (GTK_WINDOW(window), TRUE);
	gtk_window_set_type_hint (GTK_WINDOW(window), GDK_WINDOW_TYPE_HINT_MENU);

	gtk_window_set_position(GTK_WINDOW(window),GTK_WIN_POS_MOUSE);

	timeoutsign = g_timeout_add(6000, hide_window, data);
//	g_signal_connect (G_OBJECT (window), "focus-out-event",
//			G_CALLBACK (focus_out_event_cb), NULL);i
	
	box = gtk_hbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER(window), box);

	//left button create
	lbutton = gtk_button_new ();
	gtk_box_pack_start (GTK_BOX(box), lbutton, FALSE, FALSE, 0);
	limage = gtk_image_new_from_file (PKGDIR"zoom_in.png");
	gtk_widget_set_size_request (limage, 48, 24);
	gtk_container_add (GTK_CONTAINER (lbutton), limage);
	g_signal_connect (G_OBJECT(lbutton), "button-press-event",
			G_CALLBACK(font_zoom_in_cb), NULL);

	//right button create
	rbutton = gtk_button_new ();
	gtk_box_pack_start (GTK_BOX(box), rbutton, FALSE, FALSE, 0);
	rimage = gtk_image_new_from_file (PKGDIR"zoom_out.png");
	gtk_widget_set_size_request (rimage, 48, 24);
	gtk_container_add (GTK_CONTAINER (rbutton), rimage);
	g_signal_connect (G_OBJECT(rbutton), "button-press-event",
			G_CALLBACK(font_zoom_out_cb), NULL);


	gtk_widget_show (window);
	gtk_widget_show (box);
	gtk_widget_show (lbutton);
	gtk_widget_show (limage);
	gtk_widget_show (rimage);
	gtk_widget_show (rbutton);
	status = TRUE;
	
}

int 
main(int argc, char **argv)
{
	gtk_init (&argc, &argv);

	GtkWidget *image;
	GtkWidget *event_box;
	GtkStatusIcon *tray_icon;

	//system tray
	tray_icon = gtk_status_icon_new_from_file (PKGDIR"zoom_icon.png");
//	gtk_status_icon_set_tooltip (tray_icon, "Font Zoom");
	gtk_status_icon_set_visible (tray_icon, TRUE);
//	gtk_status_icon_set_title (tray_icon, "font zoom");

//	tooltips = gtk_tooltips_new ();
//	gtk_tooltips_set_tip (tooltips, tray_icon, "Font Zoom", NULL);

	g_signal_connect (G_OBJECT(tray_icon), "activate",
			G_CALLBACK(popup_set_font_window_cb), NULL);

	gtk_main();

	return 0;
}
