/*
 * $Id: sig_power.c,v 1.11 2009-01-27 17:06:42 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"
#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue-shm.h"

#include "sig_boolean.h"
#include "sig_power.h"

struct sig_power_board *
sig_power_board_init(const char *name, unsigned int nr)
{
	struct sig_power_board *c;
	char n[1000];

	c = shm_map(name, nr, sizeof(*c), 0);
	c->type = SIG_GEN_POWER_BOARD;

	sprintf(n, "%s-n_ps_on", name);
	c->n_ps_on = sig_std_logic_init(n, nr);
	sprintf(n, "%s-+5Vsb", name);
	c->_plus_5Vsb = sig_boolean_init(n, nr);
	sprintf(n, "%s-pwr_ok", name);
	c->pwr_ok = sig_boolean_init(n, nr);
	sprintf(n, "%s-+3_3V", name);
	c->_plus_3_3V = sig_boolean_init(n, nr);
	sprintf(n, "%s-+5V", name);
	c->_plus_5V = sig_boolean_init(n, nr);
	sprintf(n, "%s--5V", name);
	c->_minus_5V = sig_boolean_init(n, nr);
	sprintf(n, "%s-+12V", name);
	c->_plus_12V = sig_boolean_init(n, nr);
	sprintf(n, "%s--12V", name);
	c->_minus_12V = sig_boolean_init(n, nr);
	sprintf(n, "%s-gnd", name);
	c->gnd = sig_boolean_init(n, nr);

	return c;
}

struct sig_power_board_at *
sig_power_board_at_init(const char *name, unsigned int nr)
{
	struct sig_power_board_at *c;
	char n[1000];

	c = shm_map(name, nr, sizeof(*c), 0);

	sprintf(n, "%s-+5V", name);
	c->_plus_5V = sig_boolean_init(n, nr);
	sprintf(n, "%s--5V", name);
	c->_minus_5V = sig_boolean_init(n, nr);
	sprintf(n, "%s-+12V", name);
	c->_plus_12V = sig_boolean_init(n, nr);
	sprintf(n, "%s--12V", name);
	c->_minus_12V = sig_boolean_init(n, nr);
	sprintf(n, "%s-gnd", name);
	c->gnd = sig_boolean_init(n, nr);

	return c;
}

struct sig_power_device *
sig_power_device_init(const char *name, unsigned int nr)
{
	struct sig_power_device *c;
	char n[1000];

	c = shm_map(name, nr, sizeof(*c), 0);
	c->type = SIG_GEN_POWER_DEVICE;

	sprintf(n, "%s-power_5V", name);
	c->power_5V = sig_boolean_init(n, nr);
	sprintf(n, "%s-power_12V", name);
	c->power_12V = sig_boolean_init(n, nr);
	sprintf(n, "%s-gnd", name);
	c->gnd = sig_boolean_init(n, nr);

	return c;
}

void
sig_power_board_create(const char *name, unsigned int nr)
{
	char n[1000];

	shm_create(name, nr, sizeof(struct sig_power_board));

	sprintf(n, "%s-n_ps_on", name);
	sig_std_logic_create(n, nr);
	sprintf(n, "%s-+5Vsb", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-pwr_ok", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-+3_3V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-+5V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s--5V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-+12V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s--12V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-gnd", name);
	sig_boolean_create(n, nr);
}

void
sig_power_board_destroy(const char *name, unsigned int nr)
{
	char n[1000];

	sprintf(n, "%s-n_ps_on", name);
	sig_std_logic_destroy(n, nr);
	sprintf(n, "%s-+5Vsb", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-pwr_ok", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-+3_3V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-+5V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s--5V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-+12V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s--12V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-gnd", name);
	sig_boolean_destroy(n, nr);

	shm_destroy(name, nr);
}

void
sig_power_board_at_create(const char *name, unsigned int nr)
{
	char n[1000];

	shm_create(name, nr, sizeof(struct sig_power_board));

	sprintf(n, "%s-+5V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s--5V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-+12V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s--12V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-gnd", name);
	sig_boolean_create(n, nr);
}

void
sig_power_board_at_destroy(const char *name, unsigned int nr)
{
	char n[1000];

	sprintf(n, "%s-+5V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s--5V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-+12V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s--12V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-gnd", name);
	sig_boolean_destroy(n, nr);

	shm_destroy(name, nr);
}

void
sig_power_device_create(const char *name, unsigned int nr)
{
	char n[1000];

	shm_create(name, nr, sizeof(struct sig_power_device));

	sprintf(n, "%s-power_5V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-power_12V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-gnd", name);
	sig_boolean_create(n, nr);
}

void
sig_power_device_destroy(const char *name, unsigned int nr)
{
	char n[1000];

	sprintf(n, "%s-power_5V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-power_12V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-gnd", name);
	sig_boolean_destroy(n, nr);

	shm_destroy(name, nr);
}
