/* $Id: glue-log.c,v 1.8 2009-01-27 17:06:40 potyra Exp $ 
 *
 * Copyright (C) 2005-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

/* enable printing of timestamps if set to 1 */
#define LOG_TIMESTAMP 0

#include <assert.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

#if LOG_TIMESTAMP == 1
#include <time.h>
#endif

#include "glue-log.h"


void
faum_log(
	enum faum_log_level level,
	const char *type,
	const char *name,
	const char *fmt,
	...
)
{
	va_list args;
	char buffer[1024];
	char *buf = buffer;
#if LOG_TIMESTAMP == 1
	time_t t;
	struct tm *lt;
	size_t ret;

	t = time(NULL);
	lt = localtime(&t);
	assert(lt != NULL);

	ret = strftime(buf, sizeof(buffer), "%H:%M> ", lt);
	buf += ret;
#endif

	switch (level) {
	case FAUM_LOG_FATAL: strcpy(buf, "FATAL:"); break;
	case FAUM_LOG_CRITICAL: strcpy(buf, "CRITICAL:"); break;
	case FAUM_LOG_ERROR: strcpy(buf, "ERROR:"); break;
	case FAUM_LOG_WARNING: strcpy(buf, "WARNING:"); break;
	case FAUM_LOG_INFO: strcpy(buf, "INFO:"); break;
	case FAUM_LOG_DEBUG: strcpy(buf, "DEBUG:"); break;
	default: assert(0);
	}
	strcat(buf, " ");
	strcat(buf, type);
	if (name[0] != '\0') {
		strcat(buf, " ");
		strcat(buf, name);
	}
	strcat(buf, ": ");

	va_start(args, fmt);
	vsprintf(buf + strlen(buf), fmt, args);
	va_end(args);

	fputs(buffer, stderr);
}

#undef LOG_TIMESTAMP

void
faum_cont(
	enum faum_log_level level,
	const char *fmt,
	...
)
{
	va_list args;
	char buf[1024];

	va_start(args, fmt);
	vsprintf(buf, fmt, args);
	va_end(args);

	fputs(buf, stderr);
}

