/*
 * $Id: arch_route_ip.c,v 1.4 2009-01-28 12:59:16 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#define DEBUG_ROUTE_IP	0

#ifdef INCLUDE

#include <assert.h>
#include <inttypes.h>
#include <stdio.h>

#endif /* INCLUDE */

#ifdef STATE

struct {
	uint32_t ip;
	uint32_t netmask;
	uint32_t broadcast;
} NAME;

#endif /* STATE */

#ifdef BEHAVIOR

static void
NAME_(dump)(const char *func, const unsigned char *buf, unsigned int len)
{
#if DEBUG_ROUTE_IP
	unsigned int i;

	fprintf(stderr, "%s:\n", func);
	for (i = 0; i < len; i++) {
		if (i % 16 == 0) {
			fprintf(stderr, "%5u:", i);
		}
		fprintf(stderr, " %02x", buf[i]);
		if (i % 16 == 15) {
			fprintf(stderr, "\n");
		}
	}
	fprintf(stderr, "\n");
#endif
}

static void
NAME_(do)(struct cpssp *cpssp, int src, const unsigned char *buf, unsigned int len)
{
	const struct ip *iphdr = (const struct ip *) buf;
	uint32_t ip;

	ip = ntohl(iphdr->ip_dst.s_addr);

	if (ip == cpssp->NAME.broadcast
	 || ip == 0xffffffff) {
		/* Send to local port. */
		NAME_(to_local_ip)(cpssp, buf, len);

		if (src != 0) {
			/* Send to net connected to "iface". */
			NAME_(to_arp)(cpssp, buf, len);
		}

	} else if (ip == cpssp->NAME.ip) {
		/* Send to local port. */
		NAME_(to_local_ip)(cpssp, buf, len);

	} else if ((ip & cpssp->NAME.netmask) == (cpssp->NAME.ip & cpssp->NAME.netmask)) {
		if (src != 0) {
			/* Send to net connected to "iface". */
			NAME_(to_arp)(cpssp, buf, len);
		}

	} else {
		if (src != 1) {
			/* Send to default port. */
			NAME_(to_default_ip)(cpssp, buf, len);
		}
	}
}

static void
NAME_(from_local_ip)(struct cpssp *cpssp, const unsigned char *buf, unsigned int len)
{
	NAME_(dump)(__FUNCTION__, buf, len);
	NAME_(do)(cpssp, -1, buf, len);
}

static void
NAME_(from_arp)(struct cpssp *cpssp, const unsigned char *buf, unsigned int len)
{
	NAME_(dump)(__FUNCTION__, buf, len);
	NAME_(do)(cpssp, 0, buf, len);
}

static void
NAME_(from_default_ip)(struct cpssp *cpssp, const unsigned char *buf, unsigned int len)
{
	NAME_(dump)(__FUNCTION__, buf, len);
	NAME_(do)(cpssp, 1, buf, len);
}

static void
NAME_(create)(struct cpssp *cpssp, uint32_t ip, uint32_t netmask, uint32_t broadcast)
{
	cpssp->NAME.ip = ip;
	cpssp->NAME.netmask = netmask;
	cpssp->NAME.broadcast = broadcast;
}

static void
NAME_(destroy)(struct cpssp *cpssp)
{
}

#undef DEBUG_ROUTE_IP

#endif /* BEHAVIOR */
