#
# $Id: sigs_and_comps.spec,v 1.220 2009-02-27 11:03:23 potyra Exp $
#
# Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
# This program is free software. You can redistribute it and/or modify it
# under the terms of the GNU General Public License, either version 2 of
# the License, or (at your option) any later version. See COPYING.
#
# signal:
#
#	type : upperclasstype;
#	bridge : methode;
#	noconfig;
#	connect_component;
#
#
# components:
#
#	generics {
#		a : type : init1, init2, init3, ...;
#		b : type;
#		.
#		.
#	}
#
#	port {
#		name : type;
#		.
#		.
#	}
#
#	simsetup {
#		name : "default value", "variant1", ...;
#		.
#		.
#	}
#
#	internal {
#		patternmatch : boolean;
#		.
#		.
#	}
#	fault_injection {
#		name ;
#		.
#		.
#	}
#

# signal types

signal boolean PRIMITIVE;
signal character PRIMITIVE;
signal integer PRIMITIVE;
signal std_logic PRIMITIVE;

signal agp_bus BUS;
signal cardbus BUS;
signal dio24 BUS;
signal host_bus BUS;
signal ide_bus BUS;
signal isa_bus BUS;
signal match BUS;
signal mem_bus BUS;
signal pci_bus BUS;
signal power_board BUS;
signal power_board_at BUS;
signal power_device BUS;
signal ps2 BUS;
signal scsi_bus BUS;
signal shugart_bus BUS;
signal sound BUS;
signal usb_bus BUS;
signal vga BUS;
signal video BUS;
signal opt_rgb BUS;
signal dio48 BUS;
signal eth BUS;
signal parallel BUS;
signal serial BUS;
signal telephone BUS;
signal cstring BUS;

#
# Chassis
#
component chassis {
	port {
		mech_power_button : IN boolean;
		n_power_button : OUT std_logic;
		mech_reset_button : IN boolean;
		n_reset_button : OUT std_logic;
		power_led : IN boolean;
		opt_power_led : OUT boolean;
		ide_led : IN boolean;
		opt_ide_led : OUT boolean;
		speaker : IN sound;
		audio_speaker : OUT sound;
	}
}

component chassis_at {
	port {
		mech_reset_button : IN boolean;
		n_reset_button : OUT std_logic;
		power_led : IN boolean;
		opt_power_led : OUT boolean;
		speaker : IN sound;
		audio_speaker : IN sound;
	}
}

#
# Power Supply
#
component power_supply {
	port {
		power_230v : IN boolean;
		mech_power_switch : IN boolean;
		power_board : INOUT power_board;
		power_dev0 : OUT power_device;
		power_dev1 : OUT power_device;
		power_dev2 : OUT power_device;
		power_dev3 : OUT power_device;
		power_dev4 : OUT power_device;
		power_dev5 : OUT power_device;
		power_dev6 : OUT power_device;
		power_dev7 : OUT power_device;
	}
}

component power_supply_at {
	port {
		power_230v : IN boolean;
		mech_power_switch : IN boolean;
		power_board : INOUT power_board_at;
		power_dev0 : OUT power_device;
		power_dev1 : OUT power_device;
		power_dev2 : OUT power_device;
		power_dev3 : OUT power_device;
		power_dev4 : OUT power_device;
		power_dev5 : OUT power_device;
		power_dev6 : OUT power_device;
		power_dev7 : OUT power_device;
	}
}

#
# Motherboards
#
component mb_ibm_at {
	generics {
		rtc_start : integer = -1;
	}
	port {
		power : INOUT power_board_at;
		isa0 : INOUT isa_bus;
		isa1 : INOUT isa_bus;
		isa2 : INOUT isa_bus;
		isa3 : INOUT isa_bus;
		isa4 : INOUT isa_bus;
		isa5 : INOUT isa_bus;
		isa6 : INOUT isa_bus;
		isa7 : INOUT isa_bus;
		keyboard : INOUT ps2;
		speaker : OUT sound;
		power_led : OUT boolean;
		n_reset_button : IN std_logic;
	}
}

component mb_ga_686dlx {
	generics {
		rtc_start : integer = -1;
	}
	port {
		power : INOUT power_board;
		cpu0 : INOUT host_bus;
		cpu1 : INOUT host_bus;
		mem0 : INOUT mem_bus;
		mem1 : INOUT mem_bus;
		mem2 : INOUT mem_bus;
		mem3 : INOUT mem_bus;
		agp : INOUT agp_bus;
		pci0 : INOUT pci_bus;
		pci1 : INOUT pci_bus;
		pci2 : INOUT pci_bus;
		pci3 : INOUT pci_bus;
		isa0 : INOUT isa_bus;
		isa1 : INOUT isa_bus;
		isa2 : INOUT isa_bus;
		ide0 : INOUT ide_bus;
		ide1 : INOUT ide_bus;
		scsi : INOUT scsi_bus;
		usb0 : INOUT usb_bus;
		usb1 : INOUT usb_bus;
		ser0 : INOUT serial;
		ser1 : INOUT serial;
		par : INOUT parallel;
		keyboard : INOUT ps2;
		mouse : INOUT ps2;
		speaker : OUT sound;
		shugart : INOUT shugart_bus;
		power_led : OUT boolean;
		ide_led : OUT boolean;
		n_power_button : IN std_logic;
		n_reset_button : IN std_logic;
	}
}

#
# CPUs
#
component cpu_generic_host {
	port {
		conn : INOUT host_bus;
	}
	fault_injection {
		bitflip : boolean;
	}
}

component cpu_intel_80386 {
	port {
		conn : INOUT host_bus; # FIXME
	}
}

component cpu_intel_80386_interpreter {
	port {
		conn : INOUT host_bus; # FIXME
	}
}

component cpu_intel_80686_klamath {
	port {
		conn : INOUT host_bus;
	}
}

component cpu_intel_80686_coppermine {
	port {
		conn : INOUT host_bus;
	}
}

component cpu_intel_x86_64 {
	port {
		conn : INOUT host_bus;
	}
}

#
# Memory
#
component memory {
	generics {
		size : integer = 32;
	}
	port {
		conn : INOUT mem_bus;
	}
	fault_injection {
		bitflip : boolean;
		stuck_at_0 : boolean;
		stuck_at_1 : boolean;
		coupling : boolean;
	}
}

#
# ISA Bus Components
#
component isa_gen_ne2000 {
	generics {
		irq : integer;
		ioaddr : integer;
		mac : string = "00:00:00:00:00:00";
	}
	port {
		isa : INOUT isa_bus;
		eth : INOUT eth;
		opt_busy_led : OUT boolean;
	}
	fault_injection {
		recv_loss : integer;
		send_loss : integer;
	}
}

component isa_gen_idectrl {
	generics {
		irq : integer = 11;
		ioaddr_8 : integer = 0x01e8;
		ioaddr_1 : integer = 0x03ee;
	}
	port {
		isa : INOUT isa_bus;
		ide : INOUT ide_bus;
	}
}

component isa_gen_soundblaster16 {
	generics {
		irq : integer = 5;
		ioaddr : integer = 0x220;
		dma8 : integer = 1;
		dma16 : integer = 5;
	}
	port {
		isa : INOUT isa_bus;
		speaker : INOUT sound;
	}
}

component isa_gen_parallel {
	generics {
		irq : integer = 5;
		ioaddr : integer = 0x0278;
	}
	port {
		isa : INOUT isa_bus;
		par : INOUT parallel;
	}
}

component isa_gen_serial {
	generics {
		irq : integer = 4;
		ioaddr : integer = 0x03e8;
	}
	port {
		isa : INOUT isa_bus;
		ser : INOUT serial;
	}
}

component isa_gen_vga {
	port {
		isa : INOUT isa_bus;
		vga : INOUT vga;
	}
}

#
# PCI Bus Components
#
component pci_cirrus_gd5446 {
	generics {
		name : string = "cirrus_vga_bios.rom";
	}
	port {
		pci : INOUT pci_bus;
		vga : INOUT vga;
	}
}

component pci_cirrus_gd5446_2mb {
	generics {
		name : string = "cirrus_vga_bios.rom";
	}
	port {
		pci : INOUT pci_bus;
		vga : INOUT vga;
	}
}

component pci_cirrus_gd5446_3mb {
	generics {
		name : string = "cirrus_vga_bios.rom";
	}
	port {
		pci : INOUT pci_bus;
		vga : INOUT vga;
	}
}

component pci_intel_eepro100 {
	generics {
		mac : string = "00:00:00:00:00:00";
	}
	port {
		pci : INOUT pci_bus;
		eth : INOUT eth;
		opt_busy_led : OUT boolean;
	}
	fault_injection {
		recv_loss : integer;
		send_loss : integer;
	}
}

component pci_ti_1520 {
	port {
		pci : INOUT pci_bus;
		card0 : INOUT cardbus;
		card1 : INOUT cardbus;
	}
}

component pci_lsi_20810 {
	port {
		pci : INOUT pci_bus;
		scsi : INOUT scsi_bus;
	}
}

component pci_gen_dio24 {
	port {
		pci : INOUT pci_bus;
		dio24 : INOUT dio24;
	}
}

component pci_gen_dio48 {
        port {  
                pci : INOUT pci_bus;
                dio48 : INOUT dio48;
        }
}

#
# SCSI Drives
#
component scsi_gen_cdrom {
	generics {
		# model : string = "FAUmachine SCSI Disk";
		scsi_id : integer = 0;
	}
	port {
		power : IN power_device;
		scsi : INOUT scsi_bus;
		change : IN cstring;
	}
#	fault_injection {
#		fault : boolean;
#	}
}

component scsi_gen_disk {
	generics {
		# model : string = "FAUmachine SCSI Disk";
		scsi_id : integer = 0;
		size : integer = 2047;
	}
	port {
		power : IN power_device;
		scsi : INOUT scsi_bus;
	}
#	fault_injection {
#		disk_fault : boolean;
#		block_fault : boolean;
#	}
}

#
# IDE Drives
#
component ide_gen_cdrom {
	generics {
		model : string = "FAUmachine CDROM";
		unit : integer = 0;
	}
	port {
		power : IN power_device;
		ide : INOUT ide_bus;
		change : IN cstring;
	}
	fault_injection {
		fault : boolean;
	}
}

component ide_gen_disk {
	generics {
		model : string = "FAUmachine Disk";
		unit : integer = 0;
		size : integer = 2047;
	}
	port {
		power : IN power_device;
		ide : INOUT ide_bus;
	}
	simsetup {
		cow : boolean = "no";
		create : boolean = "no";
		sparse : boolean = "no";
		sync : boolean = "no";
		image : string = "";
	}
	fault_injection {
		disk_fault : boolean;
		block_fault : boolean;
	}
}

component floppy_gen_floppydrive {
	generics {
		unit : integer = 0;
		model : integer = 4;
	}
	port {
		power : IN power_device;
		shugart : INOUT shugart_bus;
		opt_busy_led : OUT boolean;
		change : IN cstring;
	}
}

#
# User I/O Devices
#
component keyboard {
	port {
		ps2 : INOUT ps2;
		key0 : IN boolean;
		key1 : IN boolean;
		key2 : IN boolean;
		key3 : IN boolean;
		key4 : IN boolean;
		key5 : IN boolean;
		key6 : IN boolean;
		key7 : IN boolean;
		key8 : IN boolean;
		key9 : IN boolean;
		key10 : IN boolean;
		key11 : IN boolean;
		key12 : IN boolean;
		key13 : IN boolean;
		key14 : IN boolean;
		key15 : IN boolean;
		key16 : IN boolean;
		key17 : IN boolean;
		key18 : IN boolean;
		key19 : IN boolean;
		key20 : IN boolean;
		key21 : IN boolean;
		key22 : IN boolean;
		key23 : IN boolean;
		key24 : IN boolean;
		key25 : IN boolean;
		key26 : IN boolean;
		key27 : IN boolean;
		key28 : IN boolean;
		key29 : IN boolean;
		key30 : IN boolean;
		key31 : IN boolean;
		key32 : IN boolean;
		key33 : IN boolean;
		key34 : IN boolean;
		key35 : IN boolean;
		key36 : IN boolean;
		key37 : IN boolean;
		key38 : IN boolean;
		key39 : IN boolean;
		key40 : IN boolean;
		key41 : IN boolean;
		key42 : IN boolean;
		key43 : IN boolean;
		key44 : IN boolean;
		key45 : IN boolean;
		key46 : IN boolean;
		key47 : IN boolean;
		key48 : IN boolean;
		key49 : IN boolean;
		key50 : IN boolean;
		key51 : IN boolean;
		key52 : IN boolean;
		key53 : IN boolean;
		key54 : IN boolean;
		key55 : IN boolean;
		key56 : IN boolean;
		key57 : IN boolean;
		key58 : IN boolean;
		key59 : IN boolean;
		key60 : IN boolean;
		key61 : IN boolean;
		key62 : IN boolean;
		key63 : IN boolean;
		key64 : IN boolean;
		key65 : IN boolean;
		key66 : IN boolean;
		key67 : IN boolean;
		key68 : IN boolean;
		key69 : IN boolean;
		key70 : IN boolean;
		key71 : IN boolean;
		key72 : IN boolean;
		key73 : IN boolean;
		key74 : IN boolean;
		key75 : IN boolean;
		key76 : IN boolean;
		key77 : IN boolean;
		key78 : IN boolean;
		key79 : IN boolean;
		key80 : IN boolean;
		key81 : IN boolean;
		key82 : IN boolean;
		key83 : IN boolean;
		key84 : IN boolean;
		key85 : IN boolean;
		key86 : IN boolean;
		key87 : IN boolean;
		key88 : IN boolean;
		key89 : IN boolean;
		key90 : IN boolean;
		key91 : IN boolean;
		key92 : IN boolean;
		key93 : IN boolean;
		key94 : IN boolean;
		key95 : IN boolean;
		key96 : IN boolean;
		key97 : IN boolean;
		key98 : IN boolean;
		key99 : IN boolean;
		key100 : IN boolean;
		key101 : IN boolean;
		key102 : IN boolean;
		key103 : IN boolean;
		key104 : IN boolean;
		key105 : IN boolean;
		key106 : IN boolean;
		key107 : IN boolean;
		key108 : IN boolean;
		key109 : IN boolean;
		key110 : IN boolean;
		key111 : IN boolean;
		key112 : IN boolean;
		key113 : IN boolean;
		key114 : IN boolean;
		key115 : IN boolean;
		key116 : IN boolean;
		key117 : IN boolean;
		key118 : IN boolean;
		key119 : IN boolean;
		key120 : IN boolean;
		key121 : IN boolean;
		key122 : IN boolean;
		key123 : IN boolean;
		key124 : IN boolean;
		key125 : IN boolean;
		key126 : IN boolean;
		key127 : IN boolean;
		opt_num_led    : OUT boolean;
		opt_caps_led   : OUT boolean;
		opt_scroll_led : OUT boolean;
	}
}

component ps2_gen_mouse_4 {
	port {
		ps2 : INOUT ps2;
		deltax : IN integer;
		deltay : IN integer;
		deltaz : IN integer;
		button1 : IN boolean;
		button2 : IN boolean;
		button3 : IN boolean;
		button4 : IN boolean;
		button5 : IN boolean;
	}
}

# video device connected to the vt102
# in contrast to the normal monitor, it has only a video signal
# (which doesn't ddc pins)
component vt102_monitor {
	port {
		power_230v : IN boolean;
		in_video : IN video;
		opt_video : OUT opt_rgb;
		screen_shot : IN integer;
	}
}


component monitor {
	port {
		power_230v : IN boolean;
		vga : IN vga;
		opt_video : OUT opt_rgb;
		screen_shot : IN integer;
	}
}

component patternm {
	port {
		video : IN opt_rgb;
		slot0 : INOUT match;
		slot1 : INOUT match;
		slot2 : INOUT match;
		slot3 : INOUT match;
		slot4 : INOUT match;
		slot5 : INOUT match;
		slot6 : INOUT match;
		slot7 : INOUT match;
		slot8 : INOUT match;
		slot9 : INOUT match;
		slot10 : INOUT match;
		slot11 : INOUT match;
		slot12 : INOUT match;
		slot13 : INOUT match;
		slot14 : INOUT match;
		slot15 : INOUT match;
		#FIXME potyra: text* are actually sig_strings!
		text0 : IN cstring;
		text0_state : OUT boolean;
		text1 : IN cstring;
		text1_state : OUT boolean;
		text2 : IN cstring;
		text2_state : OUT boolean;
		text3 : IN cstring;
		text3_state : OUT boolean;
		asc_text0 : IN cstring;
		asc_text0_state : OUT boolean;
		asc_text1 : IN cstring;
		asc_text1_state : OUT boolean;
		asc_text2 : IN cstring;
		asc_text2_state : OUT boolean;
		asc_text3 : IN cstring;
		asc_text3_state : OUT boolean;

		# transitional signals, interface to expect of the 
		# gfx pattern matcher.
		# FIXME potyra should go away some day.
		pattern_rectangle0 : IN cstring;
		match_rectangle0_x : OUT integer;
		match_rectangle0_y : OUT integer;
		match_rectangle0_w : OUT integer;
		match_rectangle0_h : OUT integer;
		pattern_rectangle1 : IN cstring;
		match_rectangle1_x : OUT integer;
		match_rectangle1_y : OUT integer;
		match_rectangle1_w : OUT integer;
		match_rectangle1_h : OUT integer;
		pattern_rectangle2 : IN cstring;
		match_rectangle2_x : OUT integer;
		match_rectangle2_y : OUT integer;
		match_rectangle2_w : OUT integer;
		match_rectangle2_h : OUT integer;
		pattern_rectangle3 : IN cstring;
		match_rectangle3_x : OUT integer;
		match_rectangle3_y : OUT integer;
		match_rectangle3_w : OUT integer;
		match_rectangle3_h : OUT integer;
	}
}

component mouse_matcher {
	port {
		# path to pointer directory. If empty, mouse matcher
		# is disabled, otherwise enabled.
		pointerdir : IN cstring;
		# match state
		match_state : OUT boolean;
		# explicit event for x/y coordinate
		event : OUT boolean;
		# match x/y coordindates
		x : OUT integer;
		y : OUT integer;
		# connections to patternm
		slot0 : INOUT match;
		slot1 : INOUT match;
		slot2 : INOUT match;
		slot3 : INOUT match;
		slot4 : INOUT match;
		slot5 : INOUT match;
		slot6 : INOUT match;
		slot7 : INOUT match;
		slot8 : INOUT match;
		slot9 : INOUT match;
		slot10 : INOUT match;
		slot11 : INOUT match;
	}
}


component loudspeaker {
	port {
		sound_in : IN sound;
		audio_sound : OUT sound;
	}
}

#
# Non-PC Components
#
component usb2serial {
	port {
		serial : INOUT serial;
		usb : INOUT usb_bus;
	}
}

component usbstorage {
	port {
		usb : INOUT usb_bus;
	}
}

component vt102_keyboard {
	port {
		keyboard : OUT character;
		key0 : IN boolean;
		key1 : IN boolean;
		key2 : IN boolean;
		key3 : IN boolean;
		key4 : IN boolean;
		key5 : IN boolean;
		key6 : IN boolean;
		key7 : IN boolean;
		key8 : IN boolean;
		key9 : IN boolean;
		key10 : IN boolean;
		key11 : IN boolean;
		key12 : IN boolean;
		key13 : IN boolean;
		key14 : IN boolean;
		key15 : IN boolean;
		key16 : IN boolean;
		key17 : IN boolean;
		key18 : IN boolean;
		key19 : IN boolean;
		key20 : IN boolean;
		key21 : IN boolean;
		key22 : IN boolean;
		key23 : IN boolean;
		key24 : IN boolean;
		key25 : IN boolean;
		key26 : IN boolean;
		key27 : IN boolean;
		key28 : IN boolean;
		key29 : IN boolean;
		key30 : IN boolean;
		key31 : IN boolean;
		key32 : IN boolean;
		key33 : IN boolean;
		key34 : IN boolean;
		key35 : IN boolean;
		key36 : IN boolean;
		key37 : IN boolean;
		key38 : IN boolean;
		key39 : IN boolean;
		key40 : IN boolean;
		key41 : IN boolean;
		key42 : IN boolean;
		key43 : IN boolean;
		key44 : IN boolean;
		key45 : IN boolean;
		key46 : IN boolean;
		key47 : IN boolean;
		key48 : IN boolean;
		key49 : IN boolean;
		key50 : IN boolean;
		key51 : IN boolean;
		key52 : IN boolean;
		key53 : IN boolean;
		key54 : IN boolean;
		key55 : IN boolean;
		key56 : IN boolean;
		key57 : IN boolean;
		key58 : IN boolean;
		key59 : IN boolean;
		key60 : IN boolean;
		key61 : IN boolean;
		key62 : IN boolean;
		key63 : IN boolean;
		key64 : IN boolean;
		key65 : IN boolean;
		key66 : IN boolean;
		key67 : IN boolean;
		key68 : IN boolean;
		key69 : IN boolean;
		key70 : IN boolean;
		key71 : IN boolean;
		key72 : IN boolean;
		key73 : IN boolean;
		key74 : IN boolean;
		key75 : IN boolean;
		key76 : IN boolean;
		key77 : IN boolean;
		key78 : IN boolean;
		key79 : IN boolean;
		key80 : IN boolean;
		key81 : IN boolean;
		key82 : IN boolean;
		key83 : IN boolean;
		key84 : IN boolean;
		key85 : IN boolean;
		key86 : IN boolean;
		key87 : IN boolean;
		key88 : IN boolean;
		key89 : IN boolean;
		key90 : IN boolean;
		key91 : IN boolean;
		key92 : IN boolean;
		key93 : IN boolean;
		key94 : IN boolean;
		key95 : IN boolean;
		key96 : IN boolean;
		key97 : IN boolean;
		key98 : IN boolean;
		key99 : IN boolean;
		key100 : IN boolean;
		key101 : IN boolean;
		key102 : IN boolean;
		key103 : IN boolean;
		key104 : IN boolean;
		key105 : IN boolean;
		key106 : IN boolean;
		key107 : IN boolean;
		key108 : IN boolean;
		key109 : IN boolean;
		key110 : IN boolean;
		key111 : IN boolean;
		key112 : IN boolean;
		key113 : IN boolean;
		key114 : IN boolean;
		key115 : IN boolean;
		key116 : IN boolean;
		key117 : IN boolean;
		key118 : IN boolean;
		key119 : IN boolean;
		key120 : IN boolean;
		key121 : IN boolean;
		key122 : IN boolean;
		key123 : IN boolean;
		key124 : IN boolean;
		key125 : IN boolean;
		key126 : IN boolean;
		key127 : IN boolean;
	}
}

component vt102_core {
#	generics {
#		x : integer = 80;
#		y : integer = 25;
#	}
	port {
		mech_power_switch : IN boolean;
		serial : INOUT serial;
		keyboard : IN character;
		video : OUT video;
	}
}

component cb_intel_eepro100 {
	generics {
		mac : string = "00:00:00:00:00:00";
	}
	port {
		card : INOUT cardbus;
		eth : INOUT eth;
		opt_power_led : OUT boolean;
		opt_busy_led : OUT boolean;
	}
	fault_injection {
		recv_loss : integer;
		send_loss : integer;
	}
}

component dhcp_server {
	generics {
		mac : string = "00:00:00:00:00:00";
		ip : string = "10.0.0.1";
		first_ip : string = "10.0.0.2";
		netmask : string = "255.255.255.0";
		broadcast : string = "10.0.0.255";
		default_router : string = "10.0.0.1";
		dns_server : string = "131.188.3.73";
	}
	port {
		eth : INOUT eth;
	}
}

component serial_modem {
	port {
		switch : IN boolean;
		serial : INOUT serial;
		phone : INOUT telephone;
		opt_online_led : OUT boolean;
		opt_rxd_led : OUT boolean;
		opt_txd_led : OUT boolean;
	}
}

component printer {
	port {
		par : INOUT parallel;
	}
}

component telephone_switch {
	generics {
		num1 : integer = 1;
		num2 : integer = 2;
		num3 : integer = 3;
	}
	port {
		switch : IN boolean;
		phone0 : INOUT telephone;
		phone1 : INOUT telephone;
		phone2 : INOUT telephone;
		carrier0 : OUT boolean;
		carrier1 : OUT boolean;
		carrier2 : OUT boolean;
		connected0 : OUT integer;
		connected1 : OUT integer;
		connected2 : OUT integer;
	}
}

component telephone_isp {
	port {
		phone : INOUT telephone;
		switch : IN boolean;
	}
}

component elevator {
	port {
		mech_power_switch : IN boolean;
                dio48 : INOUT dio48;
		opt_led_a : OUT boolean;
		opt_led_b : OUT boolean;
		opt_led_c : OUT boolean;
		opt_led_d : OUT boolean;
		opt_led_e : OUT boolean;
		opt_led_f : OUT boolean;
		opt_led_g : OUT boolean;
		opt_led_arrow_down : OUT boolean;
		opt_led_arrow_up : OUT boolean;
		opt_led_panel_0 : OUT boolean;
		opt_led_panel_1 : OUT boolean;
		opt_led_panel_2 : OUT boolean;
		opt_led_0_up : OUT boolean;
		opt_led_1_down : OUT boolean;
		opt_led_1_up : OUT boolean;
		opt_led_2_down : OUT boolean;
		mech_button_panel_0 : IN boolean;
		mech_button_panel_1 : IN boolean;
		mech_button_panel_2 : IN boolean;
		mech_button_0_up : IN boolean;
		mech_button_1_down : IN boolean;
		mech_button_1_up : IN boolean;
		mech_button_2_down : IN boolean;
		mech_door_0 : OUT integer;
		mech_door_1 : OUT integer;
		mech_door_2 : OUT integer;
		mech_cabin : OUT integer;
	}
}

component elevator_rc {
	port {
		dio48 : INOUT dio48;
	}
}

component network_bridge {
	port {
		eth : INOUT eth;
	}
}

component network_router {
	generics {
		mac : string = "00:00:00:00:00:00";
		ip : string = "10.0.0.1";
		# Setup of the dhcp server
		first_ip : string = "10.0.0.2";
		netmask : string = "255.255.255.0";
		broadcast : string = "10.0.0.255";
		default_router : string = "10.0.0.1";
		dns_server : string = "131.188.3.73";
	}
	port {
		console : INOUT serial;
		eth : INOUT eth;
	}
}

component dio24_loopback {
	port {
		dio24 : INOUT dio24;
	}
}

component dio48_loopback {
        port {  
                dio48 : INOUT dio48;
        }
}
