/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 1999-2008 Novell, Inc. (www.novell.com)
 * Copyright (C) 2006 OpenedHand Ltd
 * Copyright (C) 2009 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of version 2.1 of the GNU Lesser General Public License as published
 * by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Author: Chris Toshok <toshok@ximian.com>
 * Author: Ross Burton <ross@linux.intel.com>
 */

#ifndef __E_DATA_BOOK_TYPES_H__
#define __E_DATA_BOOK_TYPES_H__

G_BEGIN_DECLS

typedef struct _EDataBookView        EDataBookView;
typedef struct _EDataBookViewClass   EDataBookViewClass;

typedef struct _EBookBackendSExp EBookBackendSExp;
typedef struct _EBookBackendSExpClass EBookBackendSExpClass;

typedef struct _EBookBackend        EBookBackend;
typedef struct _EBookBackendClass   EBookBackendClass;

typedef struct _EBookBackendSummary EBookBackendSummary;
typedef struct _EBookBackendSummaryClass EBookBackendSummaryClass;

typedef struct _EBookBackendSync        EBookBackendSync;
typedef struct _EBookBackendSyncClass   EBookBackendSyncClass;

typedef struct _EDataBook        EDataBook;
typedef struct _EDataBookClass   EDataBookClass;

typedef enum {
	Success,
	RepositoryOffline,
	PermissionDenied,
	ContactNotFound,
	ContactIdAlreadyExists,
	AuthenticationFailed,
	AuthenticationRequired,
	UnsupportedField,
	UnsupportedAuthenticationMethod,
	TLSNotAvailable,
	NoSuchBook,
	BookRemoved,
	OfflineUnavailable,

	/* These can be returned for successful searches, but
	   indicate the result set was truncated */
	SearchSizeLimitExceeded,
	SearchTimeLimitExceeded,

	InvalidQuery,
	QueryRefused,

	CouldNotCancel,

	OtherError,
	InvalidServerVersion,
	NoSpace,
} EDataBookStatus;

/* Some hacks so the backends compile without change */
#define GNOME_Evolution_Addressbook_CallStatus EDataBookStatus
#define GNOME_Evolution_Addressbook_BookMode EDataBookMode
#define GNOME_Evolution_Addressbook_Success Success
#define GNOME_Evolution_Addressbook_ContactNotFound ContactNotFound
#define GNOME_Evolution_Addressbook_NoSpace NoSpace
#define GNOME_Evolution_Addressbook_OtherError OtherError
#define GNOME_Evolution_Addressbook_PermissionDenied PermissionDenied
#define GNOME_Evolution_Addressbook_CouldNotCancel CouldNotCancel
#define GNOME_Evolution_Addressbook_RepositoryOffline RepositoryOffline
#define GNOME_Evolution_Addressbook_AuthenticationRequired AuthenticationRequired
#define GNOME_Evolution_Addressbook_AuthenticationFailed AuthenticationFailed
#define GNOME_Evolution_Addressbook_OfflineUnavailable OfflineUnavailable
#define GNOME_Evolution_Addressbook_TLSNotAvailable TLSNotAvailable
#define GNOME_Evolution_Addressbook_ContactIdAlreadyExists ContactIdAlreadyExists
#define GNOME_Evolution_Addressbook_SearchTimeLimitExceeded SearchTimeLimitExceeded
#define GNOME_Evolution_Addressbook_SearchSizeLimitExceeded SearchSizeLimitExceeded
#define GNOME_Evolution_Addressbook_InvalidQuery InvalidQuery
#define GNOME_Evolution_Addressbook_UnsupportedAuthenticationMethod UnsupportedAuthenticationMethod
#define GNOME_Evolution_Addressbook_InvalidServerVersion InvalidServerVersion
#define GNOME_Evolution_Addressbook_NoSuchBook NoSuchBook

typedef enum {
	Local,
	Remote,
	Any,
} EDataBookMode;

#define GNOME_Evolution_Addressbook_MODE_LOCAL Local
#define GNOME_Evolution_Addressbook_MODE_REMOTE Remote
#define GNOME_Evolution_Addressbook_MODE_ANY Any

typedef enum {
  E_BOOK_BACKEND_CHANGE_ADDED,
  E_BOOK_BACKEND_CHANGE_DELETED,
  E_BOOK_BACKEND_CHANGE_MODIFIED
} EDataBookChangeType;

typedef struct {
  EDataBookChangeType change_type;
  char *vcard;
} EDataBookChange;

G_END_DECLS

#endif /* __E_DATA_BOOK_TYPES_H__ */
