from setuptools import setup, find_packages


# Function to convert simple ETS project names and versions to a requirements
# spec that works for both development builds and stable builds.  Allows
# a caller to specify a max version, which is intended to work along with
# Enthought's standard versioning scheme -- see the following write up:
#    https://svn.enthought.com/enthought/wiki/EnthoughtVersionNumbers
def etsdep(p, min, max=None, literal=False):
    require = '%s >=%s.dev' % (p, min)
    if max is not None:
        if literal is False:
            require = '%s, <%sa' % (require, max)
        else:
            require = '%s, <%s' % (require, max)
    return require


# Declare our ETS project dependencies.
#ENVISAGE -- all imports of this are in try...excepts so it is realy not required
#IO -- all imports of this are in try...excepts so it is really not required.
#NAMING -- all imports of this are in try...excepts so it is really not required.
TESTING = etsdep('enthought.testing', '2.0.1b1', '3.0')
TRAITS = etsdep('enthought.traits', '2.0.1b1', '3.0')
TRAITS_UI = etsdep('enthought.traits[ui]', '2.0.1b1', '3.0')
TRAITSUIWX = etsdep('enthought.traits.ui.wx', '2.0.1b1', '3.0')
#UNITS -- all imports of this are in try..except so it is really not required.


setup(
    author = 'Enthought, Inc',
    author_email = 'info@enthought.com',
    dependency_links = [
        'http://code.enthought.com/enstaller/eggs/source',
        ],
    description = 'Enthought utility package',
    extras_require = {
        'distribution': [
            TRAITS_UI,
            ],
        'traits': [
            TRAITSUIWX,
            ],
        'ui': [
            TRAITS_UI,
            ],

        # All non-ets dependencies should be in this extra to ensure users can
        # decide whether to require them or not.
        'nonets': [
            #'numarray',
            'numpy >=1.0.2',
            'scipy >=0.5',
            #'wx ==2.6',  # wx does not build as an egg cleanly on all platforms.
            #'wxPython'
            ],
        },
    include_package_data = True,
    install_requires = [
        TRAITS,
        ],
    license = 'BSD',
    name = 'enthought.util',
    namespace_packages = [
        'enthought',
        ],
    packages = find_packages(),
    tests_require = [
        'nose >= 0.9, ',
        ],
    test_suite = 'nose.collector',
    url = 'http://code.enthought.com/ets',
    version = '2.0.1b2',
    zip_safe = False,
    )
