/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _ENM_WLAN_H
#define _ENM_WLAN_H

#include <wx/string.h>
#if defined(__WXMSW__)
#include <ENM/ENMApi.h>
#else
#include <sdk/ENMApi.h>
#include <ENMDef.h>
#endif

wxString MacAddressToString(const unsigned char* mac);

bool StringToMacAddress(unsigned char* mac, const char* str, size_t strLen);

int CompareMacAddress(unsigned char* mac1, unsigned char* mac2);

bool operator == (const WlanSsid& ssid1, const WlanSsid& ssid2);
bool operator != (const WlanSsid& ssid1, const WlanSsid& ssid2);

#if defined(__WXMSW__)

#include <windows.h>
#include <wlanapi.h>

wxString NetworkNameToString(const PWLAN_AVAILABLE_NETWORK pNetwork);

wxString GuidToString(GUID guid);

// Windows native wifi callback function
VOID WINAPI OnWlanNotify(PWLAN_NOTIFICATION_DATA pData, PVOID pVoid);

DWORD ENMWlanGetAPStatus(PWLAN_AVAILABLE_NETWORK pNetwork, PAPStatus pAPStatus);

VOID UpdateCurrentAP(const PDOT11_SSID pSsid, bool connected);

#endif // __WXMSW__

#endif // _ENM_WLAN_H
