/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _CHECKED_LISTCTRL_H_
#define _CHECKED_LISTCTRL_H_

#include <wx/listctrl.h>
#include <wx/imaglist.h>

#define CHECKED_LIST_CONTROL_UNCHECKED_IMAGE_INDEX				0		// unchecked & enabled
#define CHECKED_LIST_CONTROL_CHECKED_IMAGE_INDEX				1		// checked & enabled
#define CHECKED_LIST_CONTROL_DISABLED_UNCHECKED_IMAGE_INDEX		2		// unchecked & disabled
#define CHECKED_LIST_CONTROL_DISABLED_CHECKED_IMAGE_INDEX		3		// checked & disabled

#define wxLIST_STATE_CHECKED			0x010000
#define wxLIST_STATE_ENABLED			0x100000

#define wxCLC_CHECK_WHEN_SELECTING		0x10000

//DECLARE_EXPORTED_EVENT_TYPE(WXDLLIMPEXP_WEBUPDATE, wxEVT_COMMAND_LIST_ITEM_CHECKED, -1);
//DECLARE_EXPORTED_EVENT_TYPE(WXDLLIMPEXP_WEBUPDATE, wxEVT_COMMAND_LIST_ITEM_UNCHECKED, -1);

#define EVT_LIST_ITEM_CHECKED(id, fn) \
        DECLARE_EVENT_TABLE_ENTRY( wxEVT_COMMAND_LIST_ITEM_CHECKED, id, -1, \
        (wxObjectEventFunction)(wxEventFunction)(wxListEventFunction)&fn, (wxObject*)NULL ),

#define EVT_LIST_ITEM_UNCHECKED(id, fn) \
        DECLARE_EVENT_TABLE_ENTRY( wxEVT_COMMAND_LIST_ITEM_UNCHECKED, id, -1, \
        (wxObjectEventFunction)(wxEventFunction)(wxListEventFunction)&fn, (wxObject*)NULL ),

// class wxCheckedListCtrl
class wxCheckedListCtrl : public wxListCtrl
{

public:
    //ctor
	wxCheckedListCtrl();

    //ctor
	wxCheckedListCtrl(wxWindow *parent, wxWindowID id = -1, const wxPoint& pt = wxDefaultPosition,
            const wxSize& sz = wxDefaultSize, long style = wxCLC_CHECK_WHEN_SELECTING,
            const wxValidator& validator = wxDefaultValidator, const wxString& name = wxListCtrlNameStr);

    //cteate
	bool Create(wxWindow *parent, wxWindowID id = -1, const wxPoint& pos = wxDefaultPosition,
            const wxSize& size = wxDefaultSize, long style = wxCLC_CHECK_WHEN_SELECTING,
            const wxValidator& validator = wxDefaultValidator, const wxString& name = wxListCtrlNameStr);

    //dtor
	virtual ~wxCheckedListCtrl();

    wxImageList m_lstImageList;
    //enable
    void EnableCheck(int itemIndex);

    //get item
	bool GetItem(wxListItem& item) const;
    //set item
	bool SetItem(wxListItem& item);
    //delete item
	bool DeleteItem(long itemIndex);
    //insert item
    long InsertItem(wxListItem& item);
    //delete all items
	bool DeleteAllItems();

    //sort items
	bool SortItems(wxListCtrlCompare func, long data);

    //enable
	void Enable(long itemIndex, bool bEnable);
    //enable all
	void EnableAll(bool bEnable = true);
    //check
	void Check(long itemIndex, bool bChecked);
    //check all
	void CheckAll(bool bChecked = true);

    //enable
	virtual bool Enable(bool isEnable = true);

    //is enable
	bool IsEnabled(long itemIndex) const;
    //is check
	bool IsChecked(long itemIndex) const;
    //is enable
	bool IsEnabled() const;
    //get count
	int GetCheckedItemCount() const;

    //get state
	int GetItemState(long itemIndex, long lStateMask) const;
    //set state
	bool SetItemState(long itemIndex, long lState, long lStateMask);
    //set item
	long SetItem(long itemIndex, int column, const wxString& label, int imageId = -1);
    //insert item
    long InsertItem( long itemIndex, const wxString& label, int imageIndex = -1);
    //set item
    bool SetItemStateOri(long itemIndex, long lState, long lStateMask);

protected:
	wxArrayInt m_lstStateList;
    int  m_iEnableCheckRow;

    //call by event
	void OnMouseEvent(wxMouseEvent& event);

    //get image
	static int GetExStateItemImage(int iAddState);
    //get state
	static int GetAndRemoveAdditionalState(long* plState, int iStateMask);
    //get bkcolour
	wxColour GetExStateBackgroundColour(int iExState);

private:
	DECLARE_CLASS(wxCheckedListCtrl)
	DECLARE_EVENT_TABLE()
};

#endif	// _CHECKED_LISTCTRL_H_

