/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef ENMUTIL_H_INCLUDED
#define ENMUTIL_H_INCLUDED
#include "wx/string.h"
#include <string>
#include "PopupConfirmDialog.h"
#include "Profile.h"
using namespace std;

class ENMUtil
{
    public:
        static const int CHECK_OK = 0;
        static const int CHECK_ILLEGAL = 1;
        static const int CHECK_EMPTY = 2;
        static const int MAX_IP_ADDRESS = 15;
        static const int MAX_PART_IP = 3;
        //judging file name eaquls or not
        static bool FilenameEquals(const wxString& name1, const wxString& name2);
        // write log
        static void Log(const wxString& file, const wxString& log);
//        static int CheckParticular(wxString str);
        //convert wxstring into string
        static string WxStringToString(wxString wxStringValue);
        //convert string into wxstring
        static wxString StringToWxString(string stringValue);
        //judging is hex number or not
        static bool IsHexNumber(wxString str);
        //judging whether string only has letter and number or not
        static int OnlyLetterAndNum(wxString str);
        //check validation of specific string
        static int CheckValide(wxString str);
        //checking current user is admin or not
        static bool IsAdministrator();
        //get current user's folder
        static wxString GetCurrentUserAppDataFolder();
        //convert string into lower case
        static string& StringToLowerCase(string& str);
        //change IP address
        static bool ChangeIPAddress(const wxString& ip, const wxString& mask, const wxString& gateway, const wxString& dns, int adapterType, const wxString& op);
        //get IP address
        static bool GetIPAddress(wxString& ip, wxString& mask, wxString& gateway, wxString& dns, int adapterType);
        //disable internet sharing
        static bool DisableInternetSharing();
        //enable internet sharing
        static bool EnableInternetSharing();
        //auto run applications
    static bool AutoRunApp(wxString strAppPath);
        //overwrite home page
    static bool OverwriteHomePage(wxString strHomePage);
        //overwrite proxy
    static bool OverwriteProxy(wxString strProxy, wxString strPort);
        //whether string has only number or not
        static bool IsOnlyNumber(wxString str);
        //enable 802.11 auth
        static bool Enable8021xAuthentication(bool isEnable);
        //checking current user is guest or not
        static bool IsGuest();
        //show switch wired dlg
        static void ShowSwitchWiredLANDlg();
        //show switch wired success dlg
        static void ShowSwitchWiredSuccDlg();
        //show switch wireless dlg
        static int ShowSwitchWirelessLANDlg();
        //show wireless adapter dlg
        static void ShowNoWirelessAdapterDlg();
        //show wireless on or off dlg
        static void ShowWirelessOnOffDlg(bool isEnable);
        //show auto connection failed dlg
        static void ShowAutoConnectionFailedDlg();
        //show help
        static bool ShowContextHelp(const wxWindow* pWnd, const wxString& section);
    static bool ValidateIPSettings(const IPDNSSet_t& set);
#if defined(__WXMSW__)
        //get adapter name
        static wxArrayString GetNetworkAdapterNames();
        //get folder
        static wxString GetAllUserAppDataFolder();
        //startup firewall
        static bool StartupWindowsFirewallService();
        //startup firewall
        static bool StartupWindowsFirewall();
        //stop window firewall
        static bool StopWindowsFirewall();
        //enable file and print
        static bool EnableFileAndPrint();
        //disable file and print
        static bool DisableFileAndPrint();
#endif
#if defined(__UNIX__)
        static bool IsFirefoxRunning();
        static wxString GetFirefoxConfigFile();
        static wxString GetLocaleFileName(int langCode);
#endif

    private:
        static PopupConfirmDialog* switchWiredSuccDlg;
        static PopupConfirmDialog* switchWirelessSuccDlg;
        static PopupConfirmDialog* noWirelessAdapterDlg;
        static PopupConfirmDialog* wirelessOnOffDlg;
        static PopupConfirmDialog* autoConnectionFailedDlg;
};


#endif // ENMUTIL_H_INCLUDED
