/*
 * Easy Network
 * Copyright (c) <2009>, Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 3, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */
#ifndef _PROFILE_MANAGEMENT_CONTROL_H
#define _PROFILE_MANAGEMENT_CONTROL_H

#include "ProfileEditor.h"
#include <wx/wx.h>
#include "wlan.h"
#include "wlanacmevent.h"
#include "SwitchAdapterEvent.h"
#include "DataCenter.h"
#include "WirelessEvent.h"

#include <vector>
using namespace std;

class ProfileManagementControl : public wxEvtHandler
{
    public:
        //ctor
        ProfileManagementControl();
        //dtor
        virtual ~ProfileManagementControl();
        //import profile
        bool ImportProfile(ProfileList_t& profile);
        //export profile
        bool ExportProfile(ProfileList_t& profile, const wxString& path);
        //applu profile
        bool ApplyProfile(const ProfileList_t& profile);
        //disconnect profile
        bool DisconnectCurrentProfile();
        //remove profile
        bool RemoveProfile(size_t index);
        //get profile
        ProfileList_t* GetProfile(size_t index);
        //get profile
        ProfileList_t* GetProfile(const wxString& name, bool admin = true);
        //contains
        bool Contains(const wxString& name);
        //get user profiles
        bool GetUserProfiles(vector<ProfileList_t>& newVector, bool isAdminUser = false, bool reload = true);
        bool GetUserProfiles(vector<ProfileList_t>& newVector, vector<ProfileList_t>& CurrentUserVector, bool isAdminUser = false, bool reload = true);
        //get count
        int GetAdminProfileCount();
        //change priority
        bool ChangePriority(int oldPriority, bool increase = true);
        //get profile
        wxString GetCurrentProfile() const;
        //get profile in use
        const ProfileList_t& GetCurrentUsedProfile() const;
        //confirm modify
        bool ConfirmModify(wxArrayString& failedProfiles);
        //confirm modify
        bool ConfirmModify(const vector<ProfileList_t>* pVector, wxArrayString& failedProfiles);
        //change notify mode
        void NotifyModeChanged(NETWORK_MODE networkMode);
        //read profile
        bool ReadProfile(ProfileList_t& profile, const wxString& fileName);
        //insert profile
        bool InsertNewWirelessProfile(ProfileList_t& profile);
        //check profile exists
        int CheckWirelessProfileExist(const APStatus& network);
        //stop applying
        void StopApplying();

        bool m_bIfStaticIp;
        int m_setIpCounter;
        wxTimer m_SetStaticIp;

        bool GetStaticFlag();

        static const wxString SYSTEM_PROFOLE_DIR;
        static const wxString USER_PROFILE_DIR;
        static const long ID_TIMER_SETSTATICIP;

    protected:
        enum CurrentStatus
        {
            WAITING = 0,
            APPLY_PROFILE = 1,
            DISCONNECT_PROFILE = 2
        };
        CurrentStatus m_status;

    private:
        static const int LAN_CONNECT_TIMER_ID;
        static const int APPLY_TIMER_ID;
        static const int PREPARE_TIMER_ID;
        static const size_t NO_FILES = (size_t)-1;
        static const size_t PROFILE_NAME_LENGTH = 36;
        static const wxChar PATH_SEPARATOR;

        APStatus* m_pToConnect;
        wxString m_strKey;
        ProfileList_t m_profileToApply;
        bool m_isBusy;
        bool m_isStopped;
        int m_iApplyDelay;
        int m_iCurrentProfileIndex;
        wxTimer m_timerLanConnect;
        wxTimer m_timerApply;
        wxTimer m_timerPrepare;

#if defined(__WXMSW__)
        static const int ADDRESS_TIMER_ID;
        wxTimer m_timerAddress;
#endif

        ProfileEditor m_editor;
        wxString m_strCurrentProfile;
        vector<ProfileList_t> m_systemProfiles;
        vector<ProfileList_t> m_userProfiles;

        bool ApplyProfile(size_t index);
        int GetCurrentProfileIndex() const;

        int GetProfilePriority(const ProfileList_t& profile);
        int ContinueApplyProfile(ProfileList_t& profile);
#if defined(__WXMSW__)
        bool ContinueSetAddress(ProfileList_t& profile);
#endif
        //call by event
        void OnTimer(wxTimerEvent& event);
        //call by event
        void OnTimerPrepare(wxTimerEvent& event);
        //call by event
        void OnWlanConnect(WlanAcmEvent& event);
        //call by event
        void OnAdapterSwitch(SwitchAdapterEvent& event);
        //call by event
        void OnWirelessNetworkChanged(const WirelessSwitchEvent& event);
        //set file writeable
        bool SetFileWritable(const wxString& fileName);
        //save profile
        bool SaveProfile(ProfileList_t& profile, int priority, bool isAdminUser = false);
        //load profiles
        bool LoadProfiles(bool isAdminUser);
        //load system profiles
        bool LoadSystemProfiles();
        //load user profiles
        bool LoadUserProfiles();
        //insert profile
        void InsertProfile(const ProfileList_t& profile, vector<ProfileList_t>* pVector);
        //post event
        bool PostConnectEvent(bool success, unsigned long errorCode = WLAN_ACM_ERROR_SUCCESS);
        //post event
        bool PostProfileEvent(bool applySuccess, bool toTaskTray = true);
        //write profiles
        bool WriteProfiles(vector<ProfileList_t>* pVector, const wxString& path, wxArrayString& failedPrifiles);
        //clear current profile
        void ClearCurrentProfile();
        //correct network or not
        bool IsCorrectNetwork();
        void OnStaticIpTimer(wxTimerEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // _PROFILE_MANAGEMENT_CONTROL_H
