/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * main.c
 * Copyright (C) a 2009 <a@a>
 * 
 * main.c is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * main.c is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>

#include <stdlib.h>
#include <assert.h>

#include <config.h>

#include <gtk/gtk.h>
#include <glade/glade.h>

#include <gconf/gconf-client.h>
#include <gconf/gconf-value.h>

#include <errno.h>

/* for show desktop */
#define WNCK_I_KNOW_THIS_IS_UNSTABLE 1
#include <libwnck/libwnck.h>

#include "common.h"

/* for file execution */
#include <libgnome/gnome-program.h>
#include <libgnomevfs/gnome-vfs-utils.h>
#include <libgnomevfs/gnome-vfs-mime-utils.h>
#include <libgnomeui/gnome-ui-init.h>
#include <libgnome/libgnome.h>
#include <libgnomeui/libgnomeui.h>
#include <libgnomeui/gnome-authentication-manager.h>

/*
 * Standard gettext macros.
 */
#ifdef ENABLE_NLS
#  include <libintl.h>
#  undef _
#  define _(String) dgettext (PACKAGE, String)
#  ifdef gettext_noop
#    define N_(String) gettext_noop (String)
#  else
#    define N_(String) (String)
#  endif
#else
#  define textdomain(String) (String)
#  define gettext(String) (String)
#  define dgettext(Domain,Message) (Message)
#  define dcgettext(Domain,Message,Type) (Message)
#  define bindtextdomain(Domain,Directory) (Domain)
#  define _(String) (String)
#  define N_(String) (String)
#endif



#include "callbacks.h"


//******************************
// Macro
//******************************
#if 0	/* Time measurement */
#include <time.h>
#include <sys/time.h>
double GetTime()
{
    struct timeval tv;
    gettimeofday(&tv, NULL);
    return tv.tv_sec + (double)tv.tv_usec / 1000000;
}
#define DISPTIME    \
    printf("%s:%s:%d: %lf\n",   \
        __FILE__, __func__, __LINE__, GetTime())
#define GETTIME1    \
    double t1, t2; \
    t1 = GetTime(); \
    printf("%s:%s:%d: %lf\n",   \
        __FILE__, __func__, __LINE__, t1)
#define GETTIME2    \
    t2 = GetTime(); \
    printf("%s:%s:%d: %lf %lf\n",   \
        __FILE__, __func__, __LINE__, t2, t2 - t1)
#else
#define DISPTIME
#define GETTIME1
#define GETTIME2
#endif


//******************************
// Define
//******************************
#if 0
#define DT_GLADE_FILE		"/home/naito/work/directtouch/src/directtouch.glade"
#define DT_OPTICAL_FILE		"/home/naito/work/oj6sh_wheel"
#else
#define DT_GLADE_FILE		"/usr/share/directtouch/glade/directtouch.glade"
#define DT_OPTICAL_FILE		"/proc/oj6sh_wheel"
#endif

#define DT_OPT_CMD_FIRST		"/bin/sh -c 'echo "
#define DT_OPT_CMD_SECOND	" > "
#define DT_OPT_MODE_CUR		"0"
#define DT_OPT_MODE_WHEEL	"1"

#define DT_BASE_KEY			"/apps/directtouch"
#define DT_SCHEME_HOME		DT_BASE_KEY "/home"
#define DT_SCHEME_WEB		DT_BASE_KEY "/web"
#define DT_SCHEME_MAIL		DT_BASE_KEY "/mail"
#define DT_SCHEME_USER		DT_BASE_KEY "/user"
#define DT_SCHEME_DTIME		DT_BASE_KEY "/displaytime"
#define DT_SCHEME_ITIME		DT_BASE_KEY "/invalidtime"

#define DT_GBASE_KEY			"/desktop/gnome"
#define DT_GBASE_SUB_APP		DT_GBASE_KEY "/applications"
#define DT_GBASE_SUB_HDL		DT_GBASE_KEY "/url-handlers"
#define DT_GSCHEME_BROWS		DT_GBASE_SUB_HDL "/http/command"
#define DT_GSCHEME_MAIL		DT_GBASE_SUB_HDL "/mailto/command"
#define DT_GSCHEME_MEDIA		DT_GBASE_SUB_APP "/media/exec"

#define DT_INT_DEF			-1
#define DT_TIME_DEF			2000
#define DT_STR_DEF			"default"

#define DT_KEY_TYPE			"/type"
#define DT_KEY_MODE			"/mode"
#define DT_KEY_APPLI			"/application"
#define DT_KEY_EXEC			"/execflg"

#define DT_ERR_MSG_EXEC		_("Execution failed: ")
#define DT_ERR_MSG_OPT		_("Option cannot be recognized")

#define DT_STRLEN				128
#define DT_TBLCNT				4
#define DT_FONTSIZE			16

#define DT_FILE_TYPE_SHELL	"application/x-shellscript"
#define DT_FILE_TYPE_APP		"application/x-executable"
#define DT_FILE_TYPE_TEXT	"plain/text"

enum {
	DT_MENU_LAUNCHER,
	DT_MENU_INTERNET,
	DT_MENU_MAIL,
	DT_MENU_OPTICAL,
	DT_MENU_MEDIA,
	DT_MENU_APPLI,
	DT_MENUS
};

enum {
	DT_ERR_TYPE_OPT,
	DT_ERR_TYPE_EXEC,
	DT_ERRS
};


//******************************
// Structer/Variables
//******************************
typedef struct _DtPrefsManager 	DtPrefsManager;

struct _DtPrefsManager {
	GConfClient *gconf_client;
};

DtPrefsManager *dt_prefs_manager = NULL;

gchar*   DT_KEYNAME_TBL[] = {
	DT_NAME_HOME,
	DT_NAME_WEB,	
	DT_NAME_MAIL,	
	DT_NAME_USER	
};

GladeXML	*gxml;
gchar		*gargv0;
gchar		*gargv;
gint		gargc;
gchar		**gparams;

GtkTargetEntry targets[] = {{"STRING", 0, TARGET_STRING}};


//******************************
// Prottype
//******************************
static GtkWidget*
dt_create_dialog (void);

static gboolean
dt_prefs_manager_init (void);

static gboolean
dt_set_exec_info (gint, gint, gchar*, const gchar**);

static gint
dt_prefs_manager_get_int (const gchar*, gint);

static gchar*
dt_prefs_manager_get_string (const gchar*, const gchar*);

static gint
dt_gconf_client_get_int_with_default (GConfClient*, const gchar*, gint, GError**);

static gchar*
dt_gconf_client_get_string_with_default (GConfClient*, const gchar*, const gchar*, GError**);

static void
dt_show_errdialog (const gchar*, gint, gchar*);

static gboolean
dt_excution_command (gchar*);

static gboolean
dt_selection_home (void);

static gboolean
dt_selection_web (void);

static gboolean
dt_selection_mail (void);

static gboolean
dt_selection_user (void);


//******************************
// Public Function
//******************************
/* start of the timer for display startup dialog */
void
dt_start_display_timer (void)
{
	gchar *wstr = (gchar*)NULL;
	gint dtime = (gint)0;

	g_print ("dt_start_display_timer() start\n");

	wstr = g_new0 (char, DT_STRLEN);

	/* get display time of startup dialog */
	wstr = g_strconcat (DT_SCHEME_DTIME, NULL);
	dtime = dt_prefs_manager_get_int ((const gchar*)wstr, DT_TIME_DEF);
	g_print ("dt_start_display_timer() dtime[%d]\n",dtime);

	g_free (wstr);

	gdtag = gtk_timeout_add (dtime, on_display_timeout_callback, NULL);
}

/* start of the timer for key event invalid  */
void
dt_start_invalid_timer (void)
{
	gchar *wstr = (gchar*)NULL;
	gint ktime = (gint)0;

	g_print ("dt_start_invalid_timer() start\n");

	wstr = g_new0 (char, DT_STRLEN);

	/* get key invalid time during  */
	wstr = g_strconcat (DT_SCHEME_ITIME, NULL);
	ktime = dt_prefs_manager_get_int ((const gchar*)wstr, DT_TIME_DEF);
	g_print ("dt_start_invalid_timer() ktime[%d]\n",ktime);

	g_free (wstr);

	gktag = gtk_timeout_add (ktime, on_invalid_timeout_callback, NULL);
}

void
dt_start_excution (void)
{
	gboolean bret = FALSE;

	g_print ("dt_start_excution()\n");

	bret = dt_excution ();
	if (bret){
		g_print ("dt_start_excution() dt_excution() is success\n");
		dt_start_invalid_timer ();
	}else{
		g_print ("dt_start_excution() dt_excution() is failed\n");
		if (gdtag){
			gtk_timeout_remove (gdtag);
		}
		dt_start_invalid_timer ();
	}
}

gboolean
dt_excution (void)
{
	gboolean bret = FALSE;
	const gchar *str = (const gchar*)NULL;
	gchar *appname = (gchar*)NULL;
	gint type = (gint)0;
	gint mode = (gint)0;
	GnomeProgram *program = (GnomeProgram*)NULL;
	GOptionContext *context = (GOptionContext*)NULL;
	gchar *wargv[1];

	g_print ("dt_excution() start\n");

	type = dt_get_current_type ();
	mode = dt_get_current_mode ();

	/* setup of execution information */
	bret = dt_set_exec_info (type, mode, gargv, &str);
	if (!bret){
		if (str != NULL){
			g_free ((gchar*)str);
		}
		return FALSE;
	}
	if (mode != DT_MODE_APPLI){
		if (str != NULL){
			g_free ((gchar*)str);
		}
		return TRUE;
	}

	/* setup name of application */
	appname = g_new0 (char, DT_STRLEN);
	appname = g_strconcat (str, NULL);

	/* removal of an excessive option */
	if ((type == DT_MENU_INTERNET) || (type == DT_MENU_MAIL)){
		gparams = g_strsplit(str, " ", -1);
		appname = gparams[0];
		g_print ("dt_excution() appname[%s]\n",appname);
	}

	/* execution of application */
	wargv[0] = g_new0 (char, DT_STRLEN);
	wargv[0] = gargv0;
	g_print ("dt_excution() gargv0[%s]\n",gargv0);
	g_print ("dt_excution() wargv[0][%s]\n",wargv[0]);

	context = g_option_context_new ("");
	program = gnome_program_init ("directtouch", VERSION,
					LIBGNOMEUI_MODULE,
					gargc, wargv,
					GNOME_PARAM_GOPTION_CONTEXT,
	                context,
					GNOME_PARAM_NONE);

	bret = dt_excution_command (appname);

	g_object_unref (program);

	if (str != NULL){
		g_free ((gchar*)str);
	}

	if (!bret){
		return FALSE;
	}
	return TRUE;
}

gint
dt_get_current_type (void)
{
	gchar *wstr = (gchar*)NULL;
	gint type = (gint)0;

	/* get type of quick-button */
	wstr = g_new0 (char, DT_STRLEN);
	wstr = g_strconcat (DT_BASE_KEY, "/", gargv, DT_KEY_TYPE, NULL);
	type = dt_prefs_manager_get_int ((const gchar*)wstr, DT_INT_DEF);
	g_print ("dt_get_current_type() type[%d]\n",type);
	g_free (wstr);
	
	return type;
}

gint
dt_get_current_mode (void)
{
	gchar *wstr = (gchar*)NULL;
	gint mode = (gint)0;

	/* get mode of quick-button */
	wstr = g_new0 (char, DT_STRLEN);
	wstr = g_strconcat (DT_BASE_KEY, "/", gargv, DT_KEY_MODE, NULL);
	mode = dt_prefs_manager_get_int ((const gchar*)wstr, DT_INT_DEF);
	g_print ("dt_get_current_mode() mode[%d]\n",mode);
	g_free (wstr);
	
	return mode;
}


//******************************
// Private Function
//******************************
/* Generation of the stratup dialog. */
static GtkWidget*
dt_create_dialog (void)
{
	gxml = glade_xml_new (DT_GLADE_FILE, NULL, NULL);
	
	/* This is important */
	glade_xml_signal_autoconnect (gxml);
	gdialog = glade_xml_get_widget(gxml, "startup");
	g_print ("create_dialog() gdialog[%x]\n",(guint)gdialog);
	g_signal_connect (gdialog,
			  "destroy",
			  G_CALLBACK (destroy),
			  &gdialog);

	return gdialog;
}

static gboolean
dt_prefs_manager_init (void)
{
	g_print ("dt_prefs_manager_init() start\n");

	gdialog = (GtkWidget*)NULL;
	gxml = (GladeXML*)NULL;
	gargv0 = (gchar*)NULL;
	gargv = (gchar*)NULL;
	gparams = (gchar**)NULL;
	gatom_home = (GdkAtom)NULL;
	gatom_web = (GdkAtom)NULL;
	gatom_mail = (GdkAtom)NULL;
	gatom_user = (GdkAtom)NULL;
	ginst_home = (gint)-1;
	ginst_web = (gint)-1;
	ginst_mail = (gint)-1;
	ginst_user = (gint)-1;
	gargc = (gint)0;
	gdtag = (gint)0;
	gktag = (gint)0;

	if (dt_prefs_manager == NULL)
	{
		GConfClient *gconf_client = (GConfClient*)NULL;

		gconf_client = gconf_client_get_default ();
		if (gconf_client == NULL)
		{
			g_print ("Cannot initialize preferences manager.\n");
			return FALSE;
		}
		dt_prefs_manager = g_new0 (DtPrefsManager, 1);
		dt_prefs_manager->gconf_client = gconf_client;
	}

	if (dt_prefs_manager->gconf_client == NULL)
	{
		g_free (dt_prefs_manager);
		dt_prefs_manager = NULL;
	}
	g_print ("dt_prefs_manager_init() end\n");

	return dt_prefs_manager != NULL;
}

static gboolean
dt_set_exec_info (gint type, gint mode, gchar *option, const gchar **str)
{
	gchar *tmp_str = (gchar*)NULL;
	gboolean bret = TRUE;
	gchar *content = (gchar*)NULL;
	GError *error = (GError*)NULL;
	gboolean toggle_state = FALSE;
	gchar **wval = (gchar**)NULL;
	gchar *wcmd = (gchar*)NULL;
	
	switch (type)
	{
		/* DT_MODE_APPLI */
		case DT_MENU_INTERNET:
			*str = (const gchar*)dt_prefs_manager_get_string ((const gchar*)DT_GSCHEME_BROWS, DT_STR_DEF);
			if (strcmp(*str, DT_STR_DEF) == 0){
				bret = FALSE;
				break;
			}
			g_print ("dt_set_exec_info() str[%s]\n",*str);
			break;
		case DT_MENU_MAIL:
			*str = (const gchar*)dt_prefs_manager_get_string ((const gchar*)DT_GSCHEME_MAIL, DT_STR_DEF);
			if (strcmp(*str, DT_STR_DEF) == 0){
				bret = FALSE;
				break;
			}
			g_print ("dt_set_exec_info() str[%s]\n",*str);
			break;
		case DT_MENU_MEDIA:
			*str = (const gchar*)dt_prefs_manager_get_string ((const gchar*)DT_GSCHEME_MEDIA, DT_STR_DEF);
			if (strcmp(*str, DT_STR_DEF) == 0){
				bret = FALSE;
				break;
			}
			g_print ("dt_set_exec_info() str[%s]\n",*str);
			break;
		case DT_MENU_APPLI:
			tmp_str = g_new0 (char, DT_STRLEN);
			tmp_str = g_strconcat (DT_BASE_KEY, "/", option, DT_KEY_APPLI, NULL);
			g_print ("dt_set_exec_info() tmp_str[%s]\n",tmp_str);
			*str = (const gchar*)dt_prefs_manager_get_string ((const gchar*)tmp_str, DT_STR_DEF);
			g_free (tmp_str);
			if (strcmp(*str, DT_STR_DEF) == 0){
				bret = FALSE;
				break;
			}
			g_print ("dt_set_exec_info() str[%s]\n",*str);
			break;
		case DT_MENU_OPTICAL:
			/* read optical mode file */
			bret = g_file_get_contents(DT_OPTICAL_FILE, &content, NULL, &error);
			if (!bret) {
				break;
			}
			/* reverse optical mode */
			wval = g_strsplit(content, "\n", -1);
			g_print ("dt_set_exec_info() wval[%s]\n",*wval);
			wcmd = g_new0 (char, DT_STRLEN);
			if (strncmp(wval[0], DT_OPT_MODE_CUR, 1) == 0){
				strncpy(wval[0], DT_OPT_MODE_WHEEL, 1);
			}else{
				strncpy(wval[0], DT_OPT_MODE_CUR, 1);
			}
			wcmd = g_strconcat (DT_OPT_CMD_FIRST, *wval, DT_OPT_CMD_SECOND, DT_OPTICAL_FILE, "'", NULL);
			bret = dt_excution_command (wcmd);
			g_strfreev (wval);
			g_free (content);
			g_free (wcmd);
			if (!bret) {
				break;
			}
#if 1
			gboolean     val = FALSE;
			val = gconf_client_get_bool (dt_prefs_manager->gconf_client, "/apps/touchcruiser/value", NULL);
			if( val ){
				val = FALSE;
			} else {
				val = TRUE;
			}
			gconf_client_set_bool (dt_prefs_manager->gconf_client, "/apps/touchcruiser/value", val, NULL);
#endif
			break;
		case DT_MENU_LAUNCHER:
		    wnck_screen_force_update (wnck_screen_get_default());
			toggle_state = wnck_screen_get_showing_desktop (wnck_screen_get_default());
			g_print ("dt_set_exec_info() toggle_state[%d]\n",toggle_state);
			if (!toggle_state){
				wnck_screen_toggle_showing_desktop(wnck_screen_get_default(), TRUE);
			}else{
				wnck_screen_toggle_showing_desktop(wnck_screen_get_default(), FALSE);
			}
			break;
		default:
			bret = FALSE;
			break;
	}
	return bret;
}

static gint 
dt_prefs_manager_get_int (const gchar* key, gint def)
{
	g_return_val_if_fail (dt_prefs_manager != NULL, def);
	g_return_val_if_fail (dt_prefs_manager->gconf_client != NULL, def);

	return dt_gconf_client_get_int_with_default (dt_prefs_manager->gconf_client,
						  key,
						  def,
						  NULL);
}	

static gchar*
dt_prefs_manager_get_string (const gchar* key, const gchar* def)
{
	g_print ("dt_prefs_manager_get_string() key[%s]\n",key);
	g_print ("dt_prefs_manager_get_string() def[%s]\n",def);

	g_return_val_if_fail (dt_prefs_manager != NULL, 
			      def ? g_strdup (def) : NULL);
	g_return_val_if_fail (dt_prefs_manager->gconf_client != NULL, 
			      def ? g_strdup (def) : NULL);

	return dt_gconf_client_get_string_with_default (dt_prefs_manager->gconf_client,
						     key,
						     def,
						     NULL);
}	

static gint
dt_gconf_client_get_int_with_default (GConfClient* client, const gchar* key,
		                        	   gint def, GError** err)
{
	GError* error = NULL;
	GConfValue* val;

	g_return_val_if_fail (err == NULL || *err == NULL, def);

	val = gconf_client_get (client, key, &error);

	if (val != NULL){
		gint retval = def;

		g_return_val_if_fail (error == NULL, def);
      
		retval = gconf_value_get_int(val);
		gconf_value_free (val);

		return retval;
	}else{
		return def;
	}
}

static gchar*
dt_gconf_client_get_string_with_default (GConfClient* client, const gchar* key,
                        	      const gchar* def, GError** err)
{
	GError* error = (GError*)NULL;
	gchar* val = (gchar*)NULL;

	g_print ("dt_gconf_client_get_string_with_default() client[%x]\n",(guint)client);
	g_print ("dt_gconf_client_get_string_with_default() key[%s]\n",key);
	g_print ("dt_gconf_client_get_string_with_default() def[%s]\n",def);

	g_return_val_if_fail (err == NULL || *err == NULL, def ? g_strdup (def) : NULL);

	val = gconf_client_get_string (client, key, &error);
	g_print ("dt_gconf_client_get_string_with_default() val[%s]\n",val);
	g_print ("dt_gconf_client_get_string_with_default() error[%x]\n",(guint)error);

	if (val != NULL){
		g_return_val_if_fail (error == NULL, def ? g_strdup (def) : NULL);
		return val;
	}else{
		return def ? g_strdup (def) : NULL;
	}
}

static void
dt_show_errdialog (const gchar *filename, gint type, gchar *errstr)
{
	GtkWidget *wdialog = (GtkWidget*)NULL;
	gchar *errmsg = (gchar*)NULL;
	
	g_print ("dt_show_errdialog() start\n");
	g_print ("dt_show_errdialog() filename[%s]\n",filename);
	g_print ("dt_show_errdialog() errstr[%s]\n",errstr);

	errmsg = g_new0 (char, DT_STRLEN);

	if(type == DT_ERR_TYPE_OPT){
///		errmsg = g_strconcat ("\' \' ", "\n", DT_ERR_MSG_EXEC, DT_ERR_MSG_OPT, NULL);
///		errmsg = g_strconcat (DT_ERR_MSG_EXEC, DT_ERR_MSG_OPT, NULL);
		errmsg = g_strconcat ("\'", filename, "\' ", "\n", DT_ERR_MSG_EXEC, DT_ERR_MSG_OPT, NULL);
		/* get widget-info from glade-file */
		dt_create_dialog ();
	}else{
		errmsg = g_strconcat (errstr, NULL);
	}
///	wdialog = gtk_message_dialog_new (GTK_WINDOW(wdialog),
///					GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
///					GTK_MESSAGE_ERROR,
///					GTK_BUTTONS_CLOSE,
///					"%s", errmsg);
	wdialog = glade_xml_get_widget(gxml, "errdialog");
	g_print ("dt_show_errdialog() wdialog[%x]\n",(guint)wdialog);
	gtk_message_dialog_set_markup (GTK_MESSAGE_DIALOG(wdialog), errmsg);

	g_free (errmsg);
	gtk_dialog_run (GTK_DIALOG(wdialog));

	gtk_widget_destroy (wdialog);
}

static gboolean
dt_excution_command (gchar *command)
{
	gboolean bret = TRUE;
	GError *error = (GError*)NULL;
	gchar *wstr = (gchar*)NULL;

	gchar *url_str = (gchar*)NULL;
	gchar *file_type = (gchar*)NULL;
	gint ret = (gint)0;

	g_print ("dt_excution_command() command[%s]\n",command);

	bret = g_spawn_command_line_async (command, &error);
	if (!bret)
	{
		g_print ("g_spawn_command_line_sync() failed\n");

		/* It is confirmed whether a file exists. */
		if (g_file_test (command, G_FILE_TEST_IS_REGULAR) == FALSE)
		{
			g_print ("file path is not found\n");
			wstr = g_new0 (char, DT_STRLEN);
			wstr = g_strconcat ((const gchar*)error->message, NULL);
			/* erase start-up dialog */
			on_display_timeout_callback (NULL);
			dt_show_errdialog (command, DT_ERR_TYPE_EXEC, wstr);
			g_free (wstr);
			return FALSE;
		}
		file_type = (gchar*)gnome_vfs_get_mime_type ((const gchar*)command);
		g_print("dt_excution_command() file_type[%s]\n", file_type);
#if 1
		/* check file type 
		   If it is a file which can be performed, it will be considered as an error. */
		if (strcmp(file_type, DT_FILE_TYPE_APP) == 0)
		{
			g_print ("file is not executable\n");
			wstr = g_new0 (char, DT_STRLEN);
			wstr = g_strconcat ((const gchar*)error->message, NULL);
			/* erase start-up dialog */
			on_display_timeout_callback (NULL);
			dt_show_errdialog (command, DT_ERR_TYPE_EXEC, wstr);
			g_free (wstr);
			return FALSE;
		}
#endif
		if (strcmp(file_type, DT_FILE_TYPE_SHELL) == 0)
		{
			/* It starts on a terminal. */
			g_print("dt_excution_command() It starts on a terminal\n");
			ret = gnome_execute_terminal_shell (NULL, command);
			bret = TRUE;
		}
		else
		{
			g_print("dt_excution_command() The associated application is started.\n");
			url_str = gnome_vfs_make_uri_canonical (command);
			g_print("dt_excution_command() url_str[%s]\n", url_str);
			gnome_url_show (url_str, NULL);
			bret = TRUE;
		}
	}
	return bret;
}

static gboolean
dt_selection_home (void)
{
	/* set callback for selection */
	g_signal_connect (G_OBJECT (gdialog), "selection-get",
								G_CALLBACK (signal_selection_get), DT_NAME_HOME);
	g_signal_connect (G_OBJECT (gdialog), "selection-received",
								G_CALLBACK (signal_selection_received), DT_NAME_HOME);

	/* Generation of the atom corresponding to the specified character string */
	gatom_home = gdk_atom_intern (DT_NAME_HOME, FALSE);

	/* The data format which can be offered at an original selection is registered. */
	gtk_selection_add_targets (gdialog, gatom_home,
								targets, G_N_ELEMENTS (targets));

	/* It confirms whether to already have started. */
	gtk_selection_convert (gdialog, gatom_home,
								GDK_SELECTION_TYPE_STRING, GDK_CURRENT_TIME);

	while (ginst_home < 0){
		while (gtk_events_pending ()){
			gtk_main_iteration ();
		}
	}
	if (ginst_home > 0){
		/* It ends, when having already started. */
		g_print ("dt_selection_home() directtouch is running now\n");
		return FALSE;
	}

	/* The ownership of a selection is declared. */
	gtk_selection_owner_set (gdialog, gatom_home, GDK_CURRENT_TIME);

	return TRUE;
}

static gboolean
dt_selection_web (void)
{
	/* set callback for selection */
	g_signal_connect (G_OBJECT (gdialog), "selection-get",
								G_CALLBACK (signal_selection_get), DT_NAME_WEB);
	g_signal_connect (G_OBJECT (gdialog), "selection-received",
								G_CALLBACK (signal_selection_received), DT_NAME_WEB);

	/* Generation of the atom corresponding to the specified character string */
	gatom_web = gdk_atom_intern (DT_NAME_WEB, FALSE);

	/* The data format which can be offered at an original selection is registered. */
	gtk_selection_add_targets (gdialog, gatom_web,
								targets, G_N_ELEMENTS (targets));

	/* It confirms whether to already have started. */
	gtk_selection_convert (gdialog, gatom_web,
								GDK_SELECTION_TYPE_STRING, GDK_CURRENT_TIME);

	while (ginst_web < 0){
		while (gtk_events_pending ()){
			gtk_main_iteration ();
		}
	}
	if (ginst_web > 0){
		/* It ends, when having already started. */
		g_print ("dt_selection_web() directtouch is running now\n");
		return FALSE;
	}

	/* The ownership of a selection is declared. */
	gtk_selection_owner_set (gdialog, gatom_web, GDK_CURRENT_TIME);

	return TRUE;
}

static gboolean
dt_selection_mail (void)
{
	/* set callback for selection */
	g_signal_connect (G_OBJECT (gdialog), "selection-get",
								G_CALLBACK (signal_selection_get), DT_NAME_MAIL);
	g_signal_connect (G_OBJECT (gdialog), "selection-received",
								G_CALLBACK (signal_selection_received), DT_NAME_MAIL);

	/* Generation of the atom corresponding to the specified character string */
	gatom_mail = gdk_atom_intern (DT_NAME_MAIL, FALSE);

	/* The data format which can be offered at an original selection is registered. */
	gtk_selection_add_targets (gdialog, gatom_mail,
								targets, G_N_ELEMENTS (targets));

	/* It confirms whether to already have started. */
	gtk_selection_convert (gdialog, gatom_mail,
								GDK_SELECTION_TYPE_STRING, GDK_CURRENT_TIME);

	while (ginst_mail < 0){
		while (gtk_events_pending ()){
			gtk_main_iteration ();
		}
	}
	if (ginst_mail > 0){
		/* It ends, when having already started. */
		g_print ("dt_selection_mail() directtouch is running now\n");
		return FALSE;
	}

	/* The ownership of a selection is declared. */
	gtk_selection_owner_set (gdialog, gatom_mail, GDK_CURRENT_TIME);

	return TRUE;
}

static gboolean
dt_selection_user (void)
{
	/* set callback for selection */
	g_signal_connect (G_OBJECT (gdialog), "selection-get",
								G_CALLBACK (signal_selection_get), DT_NAME_USER);
	g_signal_connect (G_OBJECT (gdialog), "selection-received",
								G_CALLBACK (signal_selection_received), DT_NAME_USER);

	/* Generation of the atom corresponding to the specified character string */
	gatom_user = gdk_atom_intern (DT_NAME_USER, FALSE);

	/* The data format which can be offered at an original selection is registered. */
	gtk_selection_add_targets (gdialog, gatom_user,
								targets, G_N_ELEMENTS (targets));

	/* It confirms whether to already have started. */
	gtk_selection_convert (gdialog, gatom_user,
								GDK_SELECTION_TYPE_STRING, GDK_CURRENT_TIME);

	while (ginst_user < 0){
		while (gtk_events_pending ()){
			gtk_main_iteration ();
		}
	}
	if (ginst_user > 0){
		/* It ends, when having already started. */
		g_print ("dt_selection_user() directtouch is running now\n");
		return FALSE;
	}

	/* The ownership of a selection is declared. */
	gtk_selection_owner_set (gdialog, gatom_user, GDK_CURRENT_TIME);

	return TRUE;
}

int
main (int argc, char *argv[])
{
	gchar *cmdline = (gchar*)NULL;
	gint icnt = (gint)0;
	gint jcnt = (gint)0;
	gint keypos = (gint)0;
	gboolean bret = FALSE;
	const gchar *login = (const gchar*)NULL;

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	/* check root user */
	login = g_get_user_name();
	g_print ("main() login[%s]\n",login);
	if ((strlen(login)==4) && (strncmp(login, "root", 4)==0)){
		// It dosen't operate in the root user.
		return 0;
	}

	gtk_set_locale ();
	gtk_init (&argc, &argv);

	/* Generation of the GConfClient */
	g_return_val_if_fail (dt_prefs_manager == NULL, FALSE);
	dt_prefs_manager_init ();
	
	/* check command line option of quick-button */
	cmdline = g_new0 (char, DT_STRLEN);
	cmdline = g_strconcat (argv[0], NULL);
	for (icnt=1; icnt<argc; icnt++)
	{
		cmdline = g_strconcat (cmdline, " ", argv[icnt], NULL);
		for (jcnt=0; jcnt<DT_TBLCNT; jcnt++)
		{
			g_print ("main2() name[%s]\n",DT_KEYNAME_TBL[jcnt]);
			g_print ("main2() argv[%s]\n",argv[icnt]);
			if (strcmp (DT_KEYNAME_TBL[jcnt], argv[icnt]) == 0)
			{
				keypos=icnt;
				break;
			}
		}
	}
	g_print ("main3() icnt[%d]\n",icnt);
	g_print ("main3() jcnt[%d]\n",jcnt);
	if(jcnt == DT_TBLCNT) {
		dt_show_errdialog (cmdline, DT_ERR_TYPE_OPT, NULL);
		g_free (dt_prefs_manager);
		g_free (cmdline);
		return 1;
	}
	g_free (cmdline);

	/* set value to global variables */
	gargv0 = g_new0 (char, DT_STRLEN);
	gargv0 = g_strconcat (argv[0], NULL);

	gargv = g_new0 (char, DT_STRLEN);
	gargv = g_strconcat (argv[keypos], NULL);

	gargc = argc;

	/* get widget-info from glade-file */
	gdialog = dt_create_dialog ();

	/* selection management */
	if (strcmp(gargv, DT_NAME_HOME) == 0){
		bret = dt_selection_home ();
	}else if (strcmp(gargv, DT_NAME_WEB) == 0){
		bret = dt_selection_web ();
	}else if (strcmp(gargv, DT_NAME_MAIL) == 0){
		bret = dt_selection_mail ();
	}else{
		bret = dt_selection_user ();
	}
	if (!bret){
		gtk_exit (0);
	}

	if (dt_get_current_mode () == DT_MODE_APPLI){
		gtk_widget_show (gdialog);
	}else{
		dt_start_excution ();
	}
		
	gtk_main ();

	g_strfreev (gparams);
	g_free (dt_prefs_manager);
	g_free (gargv0);
	g_free (gargv);

	return 0;
}
