/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#ifndef FN_KEY_MON_H
#define FN_KEY_MON_H

#include <X11/Xlib.h>
#include <X11/XKBlib.h>
#include <assert.h>
#include "DCSApi.h"
#include "FnKeyApi.h"
#include "DbgPrint.h"
#include "PMApi.h"
#include "OnScrDsp.h"

/** Linux working thread function to looping XKB event */
extern void *XkbWrk(void *arg);

/**
 * @class FnKeyMon
 *
 * Monitor Function keys events, Caps Lock, Num Lock and Scroll Lock.
 */
class FnKeyMon
{
public:

	FnKeyMon();
	~FnKeyMon();

	static void CALLBACK FnKeyCb(DCS_VKbd_Data *pData);
	static void CALLBACK BrgChnCb(int *pData);
	static void CALLBACK WrlChnCb(BOOL *pData);

	void Init();
	void OpnDsp();
	void InsXkbKey();
	Display *GetDsp() { return m_pDsp; };
	XkbDescPtr GetXkb() { return m_pXkb; };
	BOOL IsMixerValid();
	int GetVlm();
	void SetVlm(int vlm);

	/**
	 * @struct HotKey
	 *
	 * record for key code and key symbol
	 */
	struct HotKey
	{
		int cod; /**< key code */
		KeySym sym; /**< key symbol */
	};

#define HTK_NUM 6 /**< number of hotkeys */
#define LCK_CPS 66 /**< keycode of Caps Lock */
#define LCK_NUM 77 /**< keycode of Num Lock */
#define LCK_SCR 78 /**< keycode of Scroll Lock */
#define ADU_MUT 160 /**< keycode of mute */
#define ADU_DCR 174 /**< keycode of volume+ */
#define ADU_INC 176 /**< keycode of volume- */

	static const struct HotKey HOT_KEYS[HTK_NUM]; /** all hotkeys supported */
	static const int MAX_VLM; /**< max volume */
	static const float VLM_PER_LVL; /**< volume scale for per key press */

private:

	void InsVlmKey(int cod, KeySym sym);
	void InsLckKey();
	void ChnMapTypSym(int cod);
	int GetUsrHome(char *buf);
	int GetCmd(const char *cfg, char *buf);

	Display *m_pDsp; /**< pointer to X Display */
	XkbDescPtr m_pXkb; /**< pointre to X Keyboard Extension */
	int m_Mixer; /**< fd of sound mixter */
	static int MAX_BRG;	/**< max brightness */
	static char SNG_CLC_CMD[MAX_PATH]; /**< command for single click */
	static char DBL_CLC_CMD[MAX_PATH]; /**< command for double click */
	static char SNG_CLC_HOME[MAX_PATH]; /**< single click configure in home */
	static char DBL_CLC_HOME[MAX_PATH]; /**< double click configure in home */

	static const int MAX_LVL; /**< max volume level */
	static const char *SNG_CLC_ETC; /**< single click configure in etc */
	static const char *DBL_CLC_ETC; /**< double click configure in etc */
	static const char *MIXER_DEV; /**< device node name of sound mixter */
	static const char *DSP_TGG; /**< command for DisplayToggle */
	static const char *USR_STT; /**< command to get user session status */
	static const char *DSK_SWT; /**< command for desktop switcher */
	static const char *SHW_DSK; /**< command for showing desktop */
	static const char *SHW_QCP; /**< command for launch QCP */
};
#endif /* FN_KEY_MON_H */
