/****************************************************************************
Copyright (c) 2008 Intel Corporation.  All rights reserved. 

DISCLAIMER OF WARRANTY
NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR
CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY
OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS
EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR
FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT
THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL
BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON
ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.
SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL
NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,
TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY
UPDATES, ENHANCEMENTS OR EXTENSIONS. 
****************************************************************************/
/**
 * @file VKbdHelper.cpp
 */

#include <assert.h>
#include "VKbdHelper.h"

const char * const VKbdHelper::MODULE_NAME = "Virtual Keyboard Device";
const wchar_t * const VKbdHelper::EVENT_NAME = L"VKbdEvent";
const wchar_t * const VKbdHelper::STARTEVT_NAME = L"StartEvent";
const wchar_t * const VKbdHelper::ENDEVT_NAME = L"EndEvent";

#define PRESS_INTERVAL  300
#define CLICK_INTERVAL  800 
#define MAX_BRIGHTNESS_SCALE 7 

DWORD WINAPI pressFn10Proc(LPVOID lpParameter)
{
	DCS_VKbd_Data FnKeyData;
	DWORD dwRet = WAIT_TIMEOUT;

    while(dwRet == WAIT_TIMEOUT && VKbdHelper::GetInstance().m_iCount <= MAX_BRIGHTNESS_SCALE)
    {
		FnKeyData = FN_BRIGHTNESS_DOWN;
		VKbdHelper::GetInstance().m_pFuncs -> dispatchEvent(DCS_VIRTUAL_KEY,
			VKBD_KEY_EVENT, &FnKeyData, sizeof(DCS_VKbd_Data));
		VKbdHelper::GetInstance().m_iCount ++;
		if(VKbdHelper::GetInstance().m_iCount == 1)
		{
			dwRet = WaitForSingleObject(VKbdHelper::GetInstance().m_hEndEvt, 800);
		}
		else
		{
			dwRet = WaitForSingleObject(VKbdHelper::GetInstance().m_hEndEvt, PRESS_INTERVAL);
		}
	}
	return DCS_SUCCESS;
}

DWORD WINAPI pressFn11Proc(LPVOID lpParameter)
{
	DCS_VKbd_Data FnKeyData;
	DWORD dwRet = WAIT_TIMEOUT;

    while(dwRet == WAIT_TIMEOUT && VKbdHelper::GetInstance().m_iCount <= MAX_BRIGHTNESS_SCALE)
    {
		FnKeyData = FN_BRIGHTNESS_UP;
		VKbdHelper::GetInstance().m_pFuncs -> dispatchEvent(DCS_VIRTUAL_KEY,
			VKBD_KEY_EVENT, &FnKeyData, sizeof(DCS_VKbd_Data));
		VKbdHelper::GetInstance().m_iCount ++;
		if(VKbdHelper::GetInstance().m_iCount == 1)
		{
			dwRet = WaitForSingleObject(VKbdHelper::GetInstance().m_hEndEvt, 800);
		}
		else
		{
			dwRet = WaitForSingleObject(VKbdHelper::GetInstance().m_hEndEvt, PRESS_INTERVAL);
		}
	}
	return DCS_SUCCESS;
}

DWORD WINAPI clickKeyProc(LPVOID lpParameter)
{
	DCS_VKbd_Data FnKeyData;

	Sleep(CLICK_INTERVAL);
	if(VKbdHelper::GetInstance().m_iClkNum == 1)
	{
		FnKeyData = BEZELBUTTON_SINGLE_CLICK;
	}
	else
	{
		FnKeyData = BEZELBUTTON_DOUBLE_CLICK;
	}
	VKbdHelper::GetInstance().m_iClkNum = 0;
	VKbdHelper::GetInstance().m_pFuncs -> dispatchEvent(DCS_VIRTUAL_KEY,
		VKBD_KEY_EVENT, &FnKeyData, sizeof(DCS_VKbd_Data));
	return DCS_SUCCESS;
}

DWORD WINAPI VKbdEventHandler(LPVOID lpParameter)
{
	int data;
	DCS_VKbd_Data FnKeyData;

	assert(NULL != VKbdHelper::GetInstance().m_pFuncs);
	if(!VKbdHelper::GetInstance().IsUserIdEmpty()) 
	{
		return DCS_NOT_SUPPORTED;
	}
	VKbdHelper::GetInstance().m_iClkNum = 0;
	VKbdHelper::GetInstance().m_bFlag = TRUE;
	VKbdHelper::GetInstance().m_iCount = 0;
	SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
	for(;;)
	{
		DWORD dwRet = WaitForSingleObject(VKbdHelper::GetInstance().m_hEvent, 0);
        if(dwRet == WAIT_TIMEOUT)
        {
			if(VKbdHelper::GetInstance().m_iCount > MAX_BRIGHTNESS_SCALE)
			{
				SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				VKbdHelper::GetInstance().m_iCount = 0;
			}
			VKbdHelper::GetInstance().GetVKbdData(data); 
			switch(data)
			{
			case VKBD_KEY_FNF1_PRESS:
				VKbdHelper::GetInstance().m_iKeyData = data;
				FnKeyData = FN_WLAN_SWITCH;
				VKbdHelper::GetInstance().m_pFuncs -> dispatchEvent(DCS_VIRTUAL_KEY,
					VKBD_KEY_EVENT, &FnKeyData, sizeof(DCS_VKbd_Data));
				SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				break;
			case VKBD_KEY_FNF8_PRESS:
				VKbdHelper::GetInstance().m_iKeyData = data;
				FnKeyData = FN_DISPLAY_SWITCH;
				VKbdHelper::GetInstance().m_pFuncs -> dispatchEvent(DCS_VIRTUAL_KEY,
					VKBD_KEY_EVENT, &FnKeyData, sizeof(DCS_VKbd_Data));
				SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				break;
			case VKBD_KEY_FNF10_PRESS:
				SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				VKbdHelper::GetInstance().m_iKeyData = data;
				VKbdHelper::GetInstance().m_iCount = 0;
				ResetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				CreateThread(NULL, 0, pressFn10Proc, NULL, 0, NULL);
				break;
			case VKBD_KEY_FNF10_RELEASE:
				if(VKbdHelper::GetInstance().m_iKeyData == VKBD_KEY_FNF10_PRESS)
				{
					VKbdHelper::GetInstance().m_iKeyData = data;
					SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				}
				break;
			case VKBD_KEY_FNF11_PRESS:
				SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				VKbdHelper::GetInstance().m_iKeyData = data;
				VKbdHelper::GetInstance().m_iCount = 0;
				ResetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				CreateThread(NULL, 0, pressFn11Proc, NULL, 0, NULL);
				break;
			case VKBD_KEY_FNF11_RELEASE:
				if(VKbdHelper::GetInstance().m_iKeyData == VKBD_KEY_FNF11_PRESS)
				{
					VKbdHelper::GetInstance().m_iKeyData = data;
					SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				}
				break;
			case VKBD_KEY_BEZEL_RELEASE:
				if(VKbdHelper::GetInstance().m_iClkNum == 0)
				{
					VKbdHelper::GetInstance().m_iKeyData = data;
				    CreateThread(NULL, 0, clickKeyProc, NULL, 0, NULL);
				}
				VKbdHelper::GetInstance().m_iClkNum ++;
				SetEvent(VKbdHelper::GetInstance().m_hEndEvt);
				break;
			default:
				break;
			}
		}
		else
		{
			break;
		}
	}
	return DCS_SUCCESS;
}

int VKbdHelper::Initialize(DCS_Funcs *pDispatcher)
{
	if(m_hEvent || m_hThread || m_hDevice) 
	{
		return DCS_FAIL_OPERATION;
	}
	m_hEvent = CreateEvent(NULL, TRUE, FALSE, EVENT_NAME);
	if(NULL == m_hEvent) 
	{
		return DCS_FAIL_OPERATION;
	}
	m_hEndEvt = CreateEvent(NULL, TRUE, FALSE, ENDEVT_NAME);
	if(NULL == m_hEndEvt) 
	{
		return DCS_FAIL_OPERATION;
	}
	m_hDevice = CreateFile(L"\\\\.\\VirKbd", GENERIC_READ
		| GENERIC_WRITE, 0, NULL, OPEN_EXISTING, FILE_FLAG_OVERLAPPED, NULL);
	if (INVALID_HANDLE_VALUE == m_hDevice) 
	{
		CloseHandles();
		return DCS_FAIL_OPERATION;
	}
	if (!StartVKbd()) 
	{
		CloseHandles();
		return DCS_FAIL_OPERATION;
	}
	m_pFuncs = pDispatcher;
	m_hThread = CreateThread(NULL, 0, VKbdEventHandler, NULL, 0, NULL);
	if (NULL == m_hThread) 
	{
		CloseHandles();
		return DCS_FAIL_OPERATION;
	}
	return DCS_SUCCESS;
}

BOOL VKbdHelper::StartVKbd()
{
	ULONG  ulLength;

	if(!(DeviceIoControl(m_hDevice, IOCTL_VKBD_START, NULL, 0, NULL, 0,
		&ulLength, NULL))) 
	{
		return FALSE;
	}
	return TRUE;
}

BOOL VKbdHelper::StopVKbd()
{
	ULONG  ulLength;

	if(!(DeviceIoControl(m_hDevice, IOCTL_VKBD_STOP, NULL, 0, NULL, 0,
		&ulLength, NULL))) 
	{
		return FALSE;
	}
	return TRUE;
}

BOOL VKbdHelper::SetVKbdEvent()
{
	ULONG  ulLength;

	if(!(DeviceIoControl(m_hDevice, IOCTL_VKBD_EVENT, NULL, 0, NULL, 0, 
		&ulLength, NULL))) 
	{
		return FALSE;
	}
	return TRUE;
}

BOOL VKbdHelper::GetVKbdData(int &data)
{
	int    scanCode;
	ULONG  ulLength;


	if(!(DeviceIoControl(m_hDevice, IOCTL_VKBD_GET_KEY, NULL, 0,
		&scanCode, sizeof(int), &ulLength, NULL))) 
	{
		return FALSE;
	}
	data = scanCode;
	return TRUE;
}

DCS_Return_Code VKbdHelper::HandleRequest(DCS_RequestData *pRequest)
{
	return DCS_FUNC_NOTEXIST;
}

int VKbdHelper::DestroyClient(int cliId)
{
	RemoveUserId(cliId);
	return DCS_SUCCESS;
}

void VKbdHelper::CloseHandles()
{
	if(m_hEvent) 
	{
		CloseHandle(m_hEvent);
	}
	if(m_hEndEvt) 
	{
		CloseHandle(m_hEndEvt);
	}
	if(m_hThread)     
	{
		CloseHandle(m_hThread);
	}
	if(m_hDevice)     
	{
		CloseHandle(m_hDevice);
	}
}

int VKbdHelper::Cleanup()
{
	SetEvent(m_hEndEvt);
	m_bFlag = FALSE;

	SetEvent(m_hEvent);
	Sleep(1000);
	StopVKbd();
	WaitForSingleObject(m_hThread, 3000);
	TerminateThread(m_hThread, 0);

	CloseHandles();	
	return DCS_SUCCESS;
}

