/*
 * Copyright (C) 2008  Intel Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * In addition, as a special exception, Intel gives permission to link
 * the code of portions of this program with the OpenSSL project's
 * "OpenSSL" library (or with modified versions of it that use the same
 * license as the "OpenSSL" library), and distribute the linked
 * executables.  You must obey the GNU General Public License in all
 * respects for all of the code used other than "OpenSSL".  If you modify
 * this file, you may extend this exception to your version of the file,
 * but you are not obligated to do so.  If you do not wish to do so,
 * delete this exception statement from your version.
 */


/**
 * @file AccelPlugin.cpp
 *
 * Implementation of Accel Plugin functions
 */

#include "plugins/DcsPlugin.h"
#include "plugins/accel/AccelDef.h"
#include "plugins/accel/AccelPlugin.h"
#include "AccelHelper.h"

#define ACCEL_DESCRIPTION "Accel Plugin"

#ifdef WIN32

BOOL WINAPI DllMain(HINSTANCE hInstance, DWORD fdwReason,
					LPVOID lpvReserved) {
	switch (fdwReason) {
	case DLL_PROCESS_ATTACH:
		break;

	case DLL_THREAD_ATTACH:
		break;

	case DLL_THREAD_DETACH:
		break;

	case DLL_PROCESS_DETACH:
		break;
	}

	return TRUE;
}

#endif	/* WIN32 */

DCSAPI int DP_GetModuleID()
{
	return DCS_ACCELEROMETER;
}

DCSAPI const char *DP_GetDescription()
{
	return ACCEL_DESCRIPTION;
}

DCSAPI int DP_Initialize(DCS_Funcs *pDispatcher)
{
	return AccelHelper::GetInstance().Initialize(pDispatcher);
}

DCSAPI int DP_Uninitialize()
{
	return AccelHelper::GetInstance().Cleanup();
}

DCSAPI DCS_Return_Code DP_HandleRequest(DCS_RequestData *pRequest)
{
	return AccelHelper::GetInstance().HandleRequest(pRequest);
}

DCSAPI int DP_DestroyClient(int cliId)
{
	return AccelHelper::GetInstance().DestroyClient(cliId);
}
