/*
* Copyright (C) 2008  Intel Corporation
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License, version 2, as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with this program; if not, write to the Free Software Foundation, Inc.,
* 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*
* In addition, as a special exception, Intel gives permission to link
* the code of portions of this program with the OpenSSL project's
* "OpenSSL" library (or with modified versions of it that use the same
* license as the "OpenSSL" library), and distribute the linked
* executables.  You must obey the GNU General Public License in all
* respects for all of the code used other than "OpenSSL".  If you modify
* this file, you may extend this exception to your version of the file,
* but you are not obligated to do so.  If you do not wish to do so,
* delete this exception statement from your version.
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <syslog.h>
#include <pthread.h>
#include <unistd.h>
#include <fcntl.h>
typedef int BOOL;
#define TRUE 1
#define FALSE 0
static BOOL hiddenCursor=TRUE;
char* TSC_CFG_PATH = "/etc/dcs/";
#define CFG_FILE "TSController.cfg"
#define MAX_PATH 256
extern int Ini_WriteString(char *Section, char *Ident, char *Value, char *FileName);
extern int Ini_ReadString(char *Section, char *Ident, char *Default, char *ret, char *FileName);
BOOL GetCursorStatus();

BOOL CheckMouse()
{//check if the usb mouse is plugined
	int ret = 0;
	ret = system("/usr/bin/dcs/checkmouse.sh");
//	printf("ret = %d\n", ret);
	if (ret > 0)//have mouse
		return TRUE;
	else // no mouse
		return FALSE;

}

void HideCursor()
{
	BOOL ret = CheckMouse();
	if (ret)  //mouse exists, don't hide
		return;
	system("/usr/bin/dcs/hidecursor.sh");
}

void ShowCursor()
{
	system("/usr/bin/dcs/showcursor.sh");
}
BOOL GetCursorStatus()
{
	char str_tmp[MAX_PATH];
	memset(str_tmp,0,MAX_PATH);

	if (access(CFG_FILE,0) ==0 ) //file exist
	{
		Ini_ReadString("TSController","HideCursor","",str_tmp,CFG_FILE);
	}
	
	if (!(strcmp(str_tmp,"FALSE")))
	{
		hiddenCursor = FALSE;
		return FALSE;
	}
	
	hiddenCursor = TRUE;

	return TRUE;
}

int SetCursorStatus(BOOL bStatus)
{
	if (access(TSC_CFG_PATH,F_OK) < 0) // dir not exist
	{	
		return -1;
	}
	hiddenCursor = bStatus;

	char str_tmp[MAX_PATH];
	memset(str_tmp,0,MAX_PATH);
	strcpy(str_tmp,TSC_CFG_PATH);
	strcat(str_tmp,CFG_FILE);

	FILE* file;
	if ( (file=fopen(str_tmp,"w+")) != NULL )
	{
		if (hiddenCursor==TRUE)
			Ini_WriteString("TSController","HideCursor","TRUE",str_tmp);
		else
			Ini_WriteString("TSController","HideCursor","FALSE",str_tmp);
	}
	fclose(file);

	return 0;
}

int main(int argc, char* argv[])
{
	int ret = 0;

	if (argc <= 1)
		return -1;
	
	if (strcmp(argv[1], "TRUE")== 0)
	{
		SetCursorStatus(TRUE);
		HideCursor();
	}
	else
	{
	 	SetCursorStatus(FALSE);
		ShowCursor();
	}
	return 0;
}
