/*
 * Test tool of Virtual Key Driver
 * Copyright (C) 2008  Intel Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License, version 2, as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <time.h>
#include <sys/time.h>
#include <signal.h>

/*
#include <dcs.h>
*/

#define dbg_print(format, arg...) \
	printf("%s " format, __func__, ##arg)

#define FNF1_PRESSED	0x81
#define FNF1_RELEASED	0x91
#define FNF8_PRESSED	0x82
#define FNF8_RELEASED	0x92
#define FNF10_PRESSED	0x83
#define FNF10_RELEASED	0x93
#define FNF11_PRESSED	0x84
#define FNF11_RELEASED	0x94
#define BZBN_PRESSED	0x85
#define BZBN_RELEASED	0x95

#define TEST_SIG	0x80
int test_sig = 0;

#define NO_BZBN_PRESSED		0
#define FIRST_BZBN_PRESSED	1
#define SECOND_BZBN_PRESSED 2

#define	BACKLIGHT_NO		0
#define	BACKLIGHT_DOWN		1
#define BACKLIGHT_UP		2

typedef int __u32;

/** Definition of special key/button events. */
typedef enum DCS_Fn_Key_Event_E {
	BEZELBUTTON_SINGLE_CLICK,
	BEZELBUTTON_DOUBLE_CLICK,
	FN_WLAN,
	FN_MUTE,
	FN_DISPLAY_SWITCH,
	FN_BRIGHTNESS_UP,
	FN_BRIGHTNESS_DOWN
} DCS_Fn_Key_Event;

int bzbn_signal = NO_BZBN_PRESSED;
int backlight_signal = BACKLIGHT_NO;

void test_fun();

void proc_fnkey_msg(__u32 oprt);
void DCS_Fn_key_event_dispatch(DCS_Fn_Key_Event data);

void test_sigalrm_handler(int sig);
void set_timer(int interval, int value);
void bzbn_sigalrm_handler(int sig);
void backlight_sigalrm_handler(int sig);

void set_bzbn_pressed();
void set_bzbn_released();
void set_backlight_down_pressed(void);
void set_backlight_down_released(void);
void set_backlight_up_pressed(void);
void set_backlight_up_released(void);

main()
{
	int fd;
	__u32 oprt;

	fd = open("/proc/acpi/cmpc_vkd", O_RDONLY);

	if(fd != -1)
	{
		while(1)
		{
			read(fd, &oprt, sizeof(__u32));
			printf("The event is 0x%x\n", oprt);
			proc_fnkey_msg(oprt);
		}
	}
	else
	{
		printf("device open failure\n");
	}
}

void proc_fnkey_msg(__u32 oprt)
{
	switch(oprt)
	{
	case TEST_SIG:
		test_fun();
		break;
	case FNF1_PRESSED:
		break;

	case FNF1_RELEASED:
		DCS_Fn_key_event_dispatch(FN_WLAN);
		dbg_print("set wlan status succeed\n");
		break;

	case FNF8_PRESSED:
		break;

	case FNF8_RELEASED:
		DCS_Fn_key_event_dispatch(FN_DISPLAY_SWITCH);
		dbg_print("set display switch succeed\n");
		break;

	case FNF10_PRESSED:
		set_backlight_down_pressed();
		break;
	case FNF10_RELEASED:
		set_backlight_down_released();
		break;
	case FNF11_PRESSED:
		set_backlight_up_pressed();
		break;
	case FNF11_RELEASED:
		set_backlight_up_released();
		break;
	case BZBN_PRESSED:
		set_bzbn_pressed();
		break;
	case BZBN_RELEASED:
		set_bzbn_released();
		break;
	default:
		break;
	}
}

void test_fun()
{
/*	signal(SIGALRM, test_sigalrm_handler);        
	set_timer(1,1);
*/
	if(test_sig%2 == 0)
	{
//		set_bzbn_pressed();
		set_backlight_down_pressed();
		test_sig ++;
	}	
	else
	{
//		set_bzbn_released();
		set_backlight_down_released();
		test_sig ++;
	}
}

void test_sigalrm_handler(int sig)
{
	dbg_print("test timer out\n");
	test_sig ++;

	if(test_sig > 5)
	{
		set_timer(0,0);
		test_sig = 0;
	}
}

void set_timer(int interval, int value)
{        
	struct itimerval itv, oldtv;        
	itv.it_interval.tv_sec = interval;        
	itv.it_interval.tv_usec = 0;        
	itv.it_value.tv_sec = value;        
	itv.it_value.tv_usec = 0;        
	setitimer(ITIMER_REAL, &itv, &oldtv);
}

void bzbn_sigalrm_handler(int sig)
{        
	dbg_print("bzbn timer out\n");
	if(	bzbn_signal == FIRST_BZBN_PRESSED)
	{
		set_timer(0,0);
		bzbn_signal = NO_BZBN_PRESSED;
		dbg_print("bzbn single clicked\n");
		DCS_Fn_key_event_dispatch(BEZELBUTTON_SINGLE_CLICK);
	}
}

void backlight_sigalrm_handler(int sig)
{        
	if(backlight_signal == BACKLIGHT_DOWN)
	{
		DCS_Fn_key_event_dispatch(FN_BRIGHTNESS_DOWN);
		dbg_print("backlight down pressed\n");
	}
	else if(backlight_signal == BACKLIGHT_UP)
	{
		DCS_Fn_key_event_dispatch(FN_BRIGHTNESS_UP);
		dbg_print("backlight up pressed\n");
	}
}

void DCS_Fn_key_event_dispatch(DCS_Fn_Key_Event data)
{
	
}

void set_bzbn_pressed()
{
	dbg_print("bzbn pressed\n");
	if(	bzbn_signal == NO_BZBN_PRESSED)
	{
		bzbn_signal = FIRST_BZBN_PRESSED;
	}	
	else if(bzbn_signal == FIRST_BZBN_PRESSED)
	{
		bzbn_signal = SECOND_BZBN_PRESSED;
		set_timer(0,0);
	}
}

void set_bzbn_released()
{
	dbg_print("bzbn released\n");
	if(	bzbn_signal == FIRST_BZBN_PRESSED)
	{
		signal(SIGALRM, bzbn_sigalrm_handler);        
		set_timer(1,1);
	}
	else if(bzbn_signal == SECOND_BZBN_PRESSED)
	{
		dbg_print("bzbn double clicked\n");
		DCS_Fn_key_event_dispatch(BEZELBUTTON_DOUBLE_CLICK);
	}
}

void set_backlight_down_pressed()
{
	backlight_signal = BACKLIGHT_DOWN;
	dbg_print("backlight down pressed\n");
	DCS_Fn_key_event_dispatch(FN_BRIGHTNESS_DOWN);

	signal(SIGALRM, backlight_sigalrm_handler);        
	set_timer(1,1);	
}

void set_backlight_down_released(void)
{
	dbg_print("backlight down released\n");
	backlight_signal = BACKLIGHT_NO;
	set_timer(0,0);
}

void set_backlight_up_pressed(void)
{
	backlight_signal = BACKLIGHT_UP;
	dbg_print("backlight UP pressed\n");
	DCS_Fn_key_event_dispatch(FN_BRIGHTNESS_UP);

	signal(SIGALRM, backlight_sigalrm_handler);        
	set_timer(1,1);	
}

void set_backlight_up_released(void)
{
	dbg_print("backlight up released\n");
	backlight_signal = BACKLIGHT_NO;
	set_timer(0,0);
}

