/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canonical Ltd
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _LAUNCHER_CATEGORY_H_
#define _LAUNCHER_CATEGORY_H_

#include <glib-object.h>
#include <clutter/clutter.h>
#include "clutter-drag-dest.h"

#include "launcher-menu.h"


#define LAUNCHER_TYPE_CATEGORY (launcher_category_get_type ())

#define LAUNCHER_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	LAUNCHER_TYPE_CATEGORY, LauncherCategory))

#define LAUNCHER_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	LAUNCHER_TYPE_CATEGORY, LauncherCategoryClass))

#define LAUNCHER_IS_CATEGORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	LAUNCHER_TYPE_CATEGORY))

#define LAUNCHER_IS_CATEGORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	LAUNCHER_TYPE_CATEGORY))

#define LAUNCHER_CATEGORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	LAUNCHER_TYPE_CATEGORY, LauncherCategoryClass))

typedef struct _LauncherCategory        LauncherCategory;
typedef struct _LauncherCategoryClass   LauncherCategoryClass;
typedef struct _LauncherCategoryPrivate LauncherCategoryPrivate;
 
struct _LauncherCategory
{
  ClutterDragDest        parent;	

  LauncherCategoryPrivate *priv;
};

struct _LauncherCategoryClass
{
  ClutterDragDestClass   parent_class;

  /*< signals />*/
  void (*category_selected) (LauncherCategory       *cat, 
                             LauncherMenuCategory *category);
  void (*flipped)           (LauncherCategory       *cat);
};

GType          launcher_category_get_type (void) G_GNUC_CONST;

ClutterActor * launcher_category_new      (LauncherMenuCategory *cat);

void           launcher_category_set_active (LauncherCategory *category,
                                             gboolean          active);
gboolean       launcher_category_get_active (LauncherCategory *category);

void           launcher_category_set_flipped(LauncherCategory *cat,
                                             gboolean          flipped);

void           launcher_category_reset_after_drag (LauncherCategory *cat);

#endif /* _LAUNCHER_CATEGORY_H_ */

