/*******************************************************************************
*
*   clutter/gtk+-based offscreen-widget test
*
*   Copyright (C) 2008 Canonical Ltd.
*
*   This program is free software: you can redistribute it and/or modify
*   it under the terms of the GNU General Public License version 3,
*   as published by the Free Software Foundation.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details.
*
*   You should have received a copy of the GNU General Public License
*   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*   author: Mirco Müller <mirco.mueller@ubuntu.com>
*
*   compile with:
*      gcc -g `pkg-config --cflags --libs gtk+-2.0 clutter-0.6 clutter-gtk-0.6`\
*      -lm main.c cairo-utils.c -o clutter-widget-redirection
*
*******************************************************************************/

#ifndef _CAIRO_UTILS_H
#define _CAIRO_UTILS_H

#include <stdlib.h>
#include <math.h>
#include <glib.h>
#include <cairo/cairo.h>

#if G_BYTE_ORDER == G_LITTLE_ENDIAN
#define BYTE_1_OFFSET 0
#define BYTE_2_OFFSET 8
#define BYTE_3_OFFSET 16
#define BYTE_4_OFFSET 24
#else /* G_BIG_ENDIAN */
#define BYTE_1_OFFSET 24
#define BYTE_2_OFFSET 16
#define BYTE_3_OFFSET 8
#define BYTE_4_OFFSET 0
#endif

#define ARGB_A_OFFSET 24
#define ARGB_R_OFFSET 16
#define ARGB_G_OFFSET 8
#define ARGB_B_OFFSET 0

#define ARGB_A_MASK 0xFF << ARGB_A_OFFSET
#define ARGB_R_MASK 0xFF << ARGB_R_OFFSET
#define ARGB_G_MASK 0xFF << ARGB_G_OFFSET
#define ARGB_B_MASK 0xFF << ARGB_B_OFFSET

void
cairo_image_surface_blur (cairo_surface_t* surface,   /* surface to blur    */
			  gint             horzRadius /* horiz. blur-radius */,
			  gint             vertRadius /* vert. blur-radius  */);

void
demultiply_alpha (guint32* buffer, /* assumes width * height * 4 */
                  guint    width,  /* width image in buffer      */
                  guint    height  /* height image in buffer     */);

void
cairo_round_rect (cairo_t* cr,
		  gdouble  aspect,  /* aspect-ratio            */
		  gdouble  x,       /* top-left corner         */
		  gdouble  y,       /* top-left corner         */
		  gdouble  corner,  /* "size" of the corners   */
		  gdouble  width,   /* width of the rectangle  */
		  gdouble  height   /* height of the rectangle */);

#endif /* _CAIRO_UTILS_H */

