/*
 * Copyright (C) 2008 Dell Inc.
 * Copyright (C) 2008 Canoncial
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _HAVE_LAUNCHER_UTIL_H
#define _HAVE_LAUNCHER_UTIL_H

#include <glib.h>
#include <clutter/clutter.h>

#include "launcher-menu.h"

void           _normalize (gchar *string);

GdkPixbuf    * get_icon (const gchar *name, guint size);

gchar       ** launcher_util_exec_to_argv (const gchar *exec);

ClutterActor * launcher_util_texture_new_from_file (const gchar *filename);

ClutterActor * launcher_util_texture_new_from_named_icon (const gchar *name);

GdkPixbuf *    launcher_util_get_pixbuf_from_surface (cairo_surface_t *surface);

void           launcher_util_remove_favorite (LauncherMenuApplication *app);

void           launcher_util_new_shortcut (const gchar *uri,
                                           const gchar *name,
                                           const gchar *category,
                                           const gchar *exec,
                                           const gchar *icon);

void           launcher_util_edit_shortcut (const gchar *uri,
                                            const gchar *category,
                                            const gchar *name,
                                            const gchar *exec,
                                            const gchar *icon);

void           launcher_util_new_category (const gchar *uri,
                                           const gchar *id,
                                           const gchar *name,
                                           const gchar *icon);

void           launcher_util_edit_category (const gchar *uri,
                                            const gchar *name,
                                            const gchar *icon);

void           launcher_util_remove_category (LauncherMenuCategory *category);

void           launcher_util_present_window (GtkWindow *window);

ClutterTimeline * launcher_util_timeline_new_slow   ();
ClutterTimeline * launcher_util_timeline_new_medium ();
ClutterTimeline * launcher_util_timeline_new_fast   ();

void              launcher_util_stop_input ();
void              launcher_util_start_input ();

#endif /* _HAVE_LAUNCHER_UTIL_H */
