/* DuplicityInstance.c generated by valac, the Vala compiler
 * generated from DuplicityInstance.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 2 -*- */
/*
    Déjà Dup
    © 2008,2009 Michael Terry <mike@mterry.name>

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <gio/gio.h>
#include <config.h>
#include <hacks.h>
#include <signal.h>
#include <sys/wait.h>


#define DEJA_DUP_TYPE_DUPLICITY_INSTANCE (deja_dup_duplicity_instance_get_type ())
#define DEJA_DUP_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstance))
#define DEJA_DUP_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstanceClass))
#define DEJA_DUP_IS_DUPLICITY_INSTANCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE))
#define DEJA_DUP_IS_DUPLICITY_INSTANCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DEJA_DUP_TYPE_DUPLICITY_INSTANCE))
#define DEJA_DUP_DUPLICITY_INSTANCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstanceClass))

typedef struct _DejaDupDuplicityInstance DejaDupDuplicityInstance;
typedef struct _DejaDupDuplicityInstanceClass DejaDupDuplicityInstanceClass;
typedef struct _DejaDupDuplicityInstancePrivate DejaDupDuplicityInstancePrivate;
#define _g_io_channel_unref0(var) ((var == NULL) ? NULL : (var = (g_io_channel_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free_g_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_free (var), NULL)))

struct _DejaDupDuplicityInstance {
	GObject parent_instance;
	DejaDupDuplicityInstancePrivate * priv;
};

struct _DejaDupDuplicityInstanceClass {
	GObjectClass parent_class;
	void (*start) (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, GError** error);
};

struct _DejaDupDuplicityInstancePrivate {
	gboolean _verbose;
	guint stanza_id;
	guint watch_id;
	GPid child_pid;
	gint* pipes;
	gint pipes_length1;
	gint pipes_size;
	GIOChannel* reader;
};


static gpointer deja_dup_duplicity_instance_parent_class = NULL;

GType deja_dup_duplicity_instance_get_type (void);
#define DEJA_DUP_DUPLICITY_INSTANCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DEJA_DUP_TYPE_DUPLICITY_INSTANCE, DejaDupDuplicityInstancePrivate))
enum  {
	DEJA_DUP_DUPLICITY_INSTANCE_DUMMY_PROPERTY,
	DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE
};
static void deja_dup_duplicity_instance_set_verbose (DejaDupDuplicityInstance* self, gboolean value);
static void _g_list_free_g_free (GList* self);
static gboolean deja_dup_duplicity_instance_read_stanza (DejaDupDuplicityInstance* self, GIOChannel* channel, GIOCondition cond);
static gboolean _deja_dup_duplicity_instance_read_stanza_gio_func (GIOChannel* source, GIOCondition condition, gpointer self);
static void deja_dup_duplicity_instance_spawn_finished (DejaDupDuplicityInstance* self, GPid pid, gint status);
static void _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func (GPid pid, gint status, gpointer self);
void deja_dup_duplicity_instance_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, GError** error);
static void deja_dup_duplicity_instance_real_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, GError** error);
gboolean deja_dup_duplicity_instance_is_started (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_kill_child (DejaDupDuplicityInstance* self);
void deja_dup_duplicity_instance_cancel (DejaDupDuplicityInstance* self);
gboolean deja_dup_duplicity_instance_get_verbose (DejaDupDuplicityInstance* self);
static void deja_dup_duplicity_instance_process_stanza (DejaDupDuplicityInstance* self, GList* stanza);
static gint deja_dup_duplicity_instance_num_suffix (const char* word, gchar ch, glong start);
static char* deja_dup_duplicity_instance_validated_string (const char* s);
static char* deja_dup_duplicity_instance_compress_string (const char* s_in);
static void deja_dup_duplicity_instance_split_line (const char* line, char*** split, int* split_length1);
static GList* deja_dup_duplicity_instance_grab_stanza_data (DejaDupDuplicityInstance* self, GList* stanza);
static char* deja_dup_duplicity_instance_grab_stanza_text (DejaDupDuplicityInstance* self, GList* stanza);
DejaDupDuplicityInstance* deja_dup_duplicity_instance_new (void);
DejaDupDuplicityInstance* deja_dup_duplicity_instance_construct (GType object_type);
static GObject * deja_dup_duplicity_instance_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void deja_dup_duplicity_instance_finalize (GObject* obj);
static void deja_dup_duplicity_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void deja_dup_duplicity_instance_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static void _g_list_free_g_free (GList* self) {
	g_list_foreach (self, (GFunc) g_free, NULL);
	g_list_free (self);
}


static gboolean _deja_dup_duplicity_instance_read_stanza_gio_func (GIOChannel* source, GIOCondition condition, gpointer self) {
	return deja_dup_duplicity_instance_read_stanza (self, source, condition);
}


static void _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func (GPid pid, gint status, gpointer self) {
	deja_dup_duplicity_instance_spawn_finished (self, pid, status);
}


static void deja_dup_duplicity_instance_real_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, GError** error) {
	GError * _inner_error_;
	char* verbose_str;
	gboolean _tmp0_ = FALSE;
	char** _tmp2_;
	gint myenv_size;
	gint myenv_length1;
	char** _tmp1_;
	char** myenv;
	gint myenv_len;
	guint env_len;
	char** _tmp3_;
	gint real_envp_size;
	gint real_envp_length1;
	char** real_envp;
	gint i;
	char* _tmp8_;
	GList* argv;
	char* cache_dir;
	char* _tmp12_;
	gboolean _tmp13_;
	char* _tmp14_;
	gboolean _tmp15_;
	char* cmd;
	char** _tmp17_;
	gint real_argv_size;
	gint real_argv_length1;
	gint _tmp16_;
	char** real_argv;
	GIOChannel* _tmp22_;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	verbose_str = g_strdup (g_getenv ("DEJA_DUP_DEBUG"));
	if (verbose_str != NULL) {
		_tmp0_ = atoi (verbose_str) > 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		deja_dup_duplicity_instance_set_verbose (self, TRUE);
	}
	if (pipe (self->priv->pipes) != 0) {
		g_signal_emit_by_name (self, "done", FALSE, FALSE);
		_g_free0 (verbose_str);
		return;
	}
	myenv = (_tmp2_ = _tmp1_ = g_listenv (), myenv_length1 = _vala_array_length (_tmp1_), myenv_size = myenv_length1, _tmp2_);
	myenv_len = 0;
	while (TRUE) {
		if (!(myenv[myenv_len] != NULL)) {
			break;
		}
		myenv_len = myenv_len + 1;
	}
	env_len = myenv_len + g_list_length (envp_in);
	real_envp = (_tmp3_ = g_new0 (char*, (env_len + 1) + 1), real_envp_length1 = env_len + 1, real_envp_size = real_envp_length1, _tmp3_);
	i = 0;
	{
		gboolean _tmp4_;
		_tmp4_ = TRUE;
		while (TRUE) {
			char* _tmp5_;
			if (!_tmp4_) {
				i = i + 1;
			}
			_tmp4_ = FALSE;
			if (!(i < myenv_len)) {
				break;
			}
			real_envp[i] = (_tmp5_ = g_strdup_printf ("%s=%s", myenv[i], g_getenv (myenv[i])), _g_free0 (real_envp[i]), _tmp5_);
		}
	}
	{
		GList* env_collection;
		GList* env_it;
		env_collection = envp_in;
		for (env_it = env_collection; env_it != NULL; env_it = env_it->next) {
			char* env;
			env = g_strdup ((const char*) env_it->data);
			{
				char* _tmp7_;
				char* *_tmp6_;
				_tmp6_ = &real_envp[i++];
				(*_tmp6_) = (_tmp7_ = g_strdup (env), _g_free0 ((*_tmp6_)), _tmp7_);
				_g_free0 (env);
			}
		}
	}
	real_envp[i] = (_tmp8_ = NULL, _g_free0 (real_envp[i]), _tmp8_);
	argv = NULL;
	{
		GList* arg_collection;
		GList* arg_it;
		arg_collection = argv_in;
		for (arg_it = arg_collection; arg_it != NULL; arg_it = arg_it->next) {
			char* arg;
			arg = g_strdup ((const char*) arg_it->data);
			{
				argv = g_list_append (argv, g_strdup (arg));
				_g_free0 (arg);
			}
		}
	}
	argv = g_list_append (argv, g_strdup ("--verbosity=9"));
	argv = g_list_append (argv, g_strdup ("--volsize=5"));
	cache_dir = g_strdup (g_get_user_cache_dir ());
	if (cache_dir != NULL) {
		gboolean add_dir;
		GFile* cache_file;
		GFile* _tmp9_;
		add_dir = FALSE;
		cache_file = g_file_new_for_path (cache_dir);
		cache_file = (_tmp9_ = g_file_get_child (cache_file, PACKAGE), _g_object_unref0 (cache_file), _tmp9_);
		{
			gboolean _tmp10_;
			_tmp10_ = hacks_file_make_directory_with_parents (cache_file, &_inner_error_);
			if (_inner_error_ != NULL) {
				if (g_error_matches (_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
					goto __catch39_g_io_error_exists;
				}
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch39_g_io_error;
				}
				goto __finally39;
			}
			if (_tmp10_) {
				add_dir = TRUE;
			}
		}
		goto __finally39;
		__catch39_g_io_error_exists:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				add_dir = TRUE;
				_g_error_free0 (e);
			}
		}
		goto __finally39;
		__catch39_g_io_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("DuplicityInstance.vala:100: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally39:
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (cache_file);
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				return;
			} else {
				_g_object_unref0 (cache_file);
				_g_free0 (verbose_str);
				myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
				real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
				__g_list_free_g_free0 (argv);
				_g_free0 (cache_dir);
				g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		if (add_dir) {
			char* _tmp11_;
			argv = g_list_append (argv, g_strconcat ("--archive-dir=", _tmp11_ = g_file_get_path (cache_file), NULL));
			_g_free0 (_tmp11_);
		}
		_g_object_unref0 (cache_file);
	}
	argv = g_list_append (argv, g_strdup_printf ("--log-fd=%d", self->priv->pipes[1]));
	argv = g_list_prepend (argv, g_strdup ("duplicity"));
	if ((_tmp13_ = (_tmp12_ = g_find_program_in_path ("ionice")) != NULL, _g_free0 (_tmp12_), _tmp13_)) {
		argv = g_list_prepend (argv, g_strdup ("-n7"));
		argv = g_list_prepend (argv, g_strdup ("-c2"));
		argv = g_list_prepend (argv, g_strdup ("ionice"));
	}
	if ((_tmp15_ = (_tmp14_ = g_find_program_in_path ("nice")) != NULL, _g_free0 (_tmp14_), _tmp15_)) {
		argv = g_list_prepend (argv, g_strdup ("nice"));
	}
	cmd = NULL;
	real_argv = (_tmp17_ = g_new0 (char*, (_tmp16_ = g_list_length (argv)) + 1), real_argv_length1 = _tmp16_, real_argv_size = real_argv_length1, _tmp17_);
	i = 0;
	{
		GList* a_collection;
		GList* a_it;
		a_collection = argv;
		for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
			char* a;
			a = g_strdup ((const char*) a_it->data);
			{
				char* _tmp19_;
				char* *_tmp18_;
				_tmp18_ = &real_argv[i++];
				(*_tmp18_) = (_tmp19_ = g_strdup (a), _g_free0 ((*_tmp18_)), _tmp19_);
				if (cmd == NULL) {
					char* _tmp20_;
					cmd = (_tmp20_ = g_strdup (a), _g_free0 (cmd), _tmp20_);
				} else {
					if (a != NULL) {
						char* _tmp21_;
						cmd = (_tmp21_ = g_strdup_printf ("%s %s", cmd, a), _g_free0 (cmd), _tmp21_);
					}
				}
				_g_free0 (a);
			}
		}
	}
	g_spawn_async_with_pipes (NULL, real_argv, real_envp, (((G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD) | G_SPAWN_LEAVE_DESCRIPTORS_OPEN) | G_SPAWN_STDOUT_TO_DEV_NULL) | G_SPAWN_STDERR_TO_DEV_NULL, NULL, NULL, &self->priv->child_pid, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (verbose_str);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free_g_free0 (argv);
			_g_free0 (cache_dir);
			_g_free0 (cmd);
			real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
			return;
		} else {
			_g_free0 (verbose_str);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free_g_free0 (argv);
			_g_free0 (cache_dir);
			_g_free0 (cmd);
			real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	g_debug ("DuplicityInstance.vala:138: Running the following duplicity (%i) command: %s\n", (gint) self->priv->child_pid, cmd);
	self->priv->reader = (_tmp22_ = g_io_channel_unix_new (self->priv->pipes[0]), _g_io_channel_unref0 (self->priv->reader), _tmp22_);
	{
		g_io_channel_set_encoding (self->priv->reader, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_CHANNEL_ERROR) {
				goto __catch40_g_io_channel_error;
			}
			goto __finally40;
		}
	}
	goto __finally40;
	__catch40_g_io_channel_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally40:
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_SPAWN_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (verbose_str);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free_g_free0 (argv);
			_g_free0 (cache_dir);
			_g_free0 (cmd);
			real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
			return;
		} else {
			_g_free0 (verbose_str);
			myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
			real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
			__g_list_free_g_free0 (argv);
			_g_free0 (cache_dir);
			_g_free0 (cmd);
			real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->stanza_id = g_io_add_watch (self->priv->reader, G_IO_IN, _deja_dup_duplicity_instance_read_stanza_gio_func, self);
	close (self->priv->pipes[1]);
	self->priv->watch_id = g_child_watch_add (self->priv->child_pid, _deja_dup_duplicity_instance_spawn_finished_gchild_watch_func, self);
	_g_free0 (verbose_str);
	myenv = (_vala_array_free (myenv, myenv_length1, (GDestroyNotify) g_free), NULL);
	real_envp = (_vala_array_free (real_envp, real_envp_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free_g_free0 (argv);
	_g_free0 (cache_dir);
	_g_free0 (cmd);
	real_argv = (_vala_array_free (real_argv, real_argv_length1, (GDestroyNotify) g_free), NULL);
}


void deja_dup_duplicity_instance_start (DejaDupDuplicityInstance* self, GList* argv_in, GList* envp_in, GError** error) {
	DEJA_DUP_DUPLICITY_INSTANCE_GET_CLASS (self)->start (self, argv_in, envp_in, error);
}


gboolean deja_dup_duplicity_instance_is_started (DejaDupDuplicityInstance* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = ((gint) self->priv->child_pid) > 0;
	return result;
}


void deja_dup_duplicity_instance_cancel (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	if (deja_dup_duplicity_instance_is_started (self)) {
		deja_dup_duplicity_instance_kill_child (self);
	} else {
		g_signal_emit_by_name (self, "done", FALSE, TRUE);
	}
}


static void deja_dup_duplicity_instance_kill_child (DejaDupDuplicityInstance* self) {
	g_return_if_fail (self != NULL);
	kill ((pid_t) self->priv->child_pid, SIGKILL);
}


static gboolean deja_dup_duplicity_instance_read_stanza (DejaDupDuplicityInstance* self, GIOChannel* channel, GIOCondition cond) {
	gboolean result;
	GError * _inner_error_;
	char* line;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (channel != NULL, FALSE);
	_inner_error_ = NULL;
	line = NULL;
	{
		GIOStatus status = 0;
		GList* stanza;
		stanza = NULL;
		while (TRUE) {
			char* _tmp2_;
			GIOStatus _tmp1_;
			char* _tmp0_ = NULL;
			GIOStatus _tmp3_;
			gboolean _tmp4_ = FALSE;
			_tmp3_ = (_tmp1_ = g_io_channel_read_line (channel, &_tmp0_, NULL, NULL, &_inner_error_), line = (_tmp2_ = _tmp0_, _g_free0 (line), _tmp2_), _tmp1_);
			if (_inner_error_ != NULL) {
				__g_list_free_g_free0 (stanza);
				goto __catch41_g_error;
				goto __finally41;
			}
			status = _tmp3_;
			if (status == G_IO_STATUS_NORMAL) {
				_tmp4_ = _vala_strcmp0 (line, "\n") != 0;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				if (self->priv->_verbose) {
					g_print ("DUPLICITY: %s", line);
				}
				stanza = g_list_append (stanza, g_strdup (line));
			} else {
				break;
			}
		}
		if (self->priv->_verbose) {
			g_print ("\n");
		}
		deja_dup_duplicity_instance_process_stanza (self, stanza);
		__g_list_free_g_free0 (stanza);
	}
	goto __finally41;
	__catch41_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("DuplicityInstance.vala:217: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally41:
	if (_inner_error_ != NULL) {
		_g_free0 (line);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	_g_free0 (line);
	return result;
}


static gint deja_dup_duplicity_instance_num_suffix (const char* word, gchar ch, glong start) {
	gint result;
	gint rv;
	g_return_val_if_fail (word != NULL, 0);
	rv = 0;
	if (start < 0) {
		start = ((glong) strlen (word)) - 1;
	}
	{
		glong i;
		i = start;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i = i - 1;
					rv = rv + 1;
				}
				_tmp0_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				if (g_utf8_get_char (g_utf8_offset_to_pointer (word, i)) != ch) {
					break;
				}
			}
		}
	}
	result = rv;
	return result;
}


static char* deja_dup_duplicity_instance_validated_string (const char* s) {
	char* result;
	char* rv;
	const char* p;
	gchar* _tmp0_;
	gint charstr_size;
	gint charstr_length1;
	gchar* charstr;
	g_return_val_if_fail (s != NULL, NULL);
	rv = g_strdup ("");
	p = s;
	charstr = (_tmp0_ = g_new0 (gchar, 6), charstr_length1 = 6, charstr_size = charstr_length1, _tmp0_);
	while (TRUE) {
		gunichar ch;
		gboolean _tmp1_ = FALSE;
		if (!(g_utf8_get_char (g_utf8_offset_to_pointer (p, 0)) != 0)) {
			break;
		}
		ch = g_utf8_get_char_validated (p, -1);
		if (ch == ((guint) (-1))) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = ch == ((guint) (-2));
		}
		if (_tmp1_) {
			char* _tmp2_;
			rv = (_tmp2_ = g_strconcat (rv, "\xef\xbf\xbd", NULL), _g_free0 (rv), _tmp2_);
			p = g_utf8_offset_to_pointer (p, (glong) 1);
		} else {
			char* _tmp3_;
			g_unichar_to_utf8 (ch, (const char*) charstr);
			rv = (_tmp3_ = g_strconcat (rv, (const char*) charstr, NULL), _g_free0 (rv), _tmp3_);
			p = g_utf8_next_char (p);
		}
	}
	result = rv;
	charstr = (g_free (charstr), NULL);
	return result;
}


static char* deja_dup_duplicity_instance_compress_string (const char* s_in) {
	char* result;
	gchar* _tmp1_;
	gint rv_size;
	gint rv_length1;
	gint _tmp0_;
	gchar* rv;
	gchar* _tmp2_;
	gint s_size;
	gint s_length1;
	gchar* s;
	gint i;
	gint j;
	g_return_val_if_fail (s_in != NULL, NULL);
	rv = (_tmp1_ = g_new0 (gchar, _tmp0_ = strlen (s_in) + 1), rv_length1 = _tmp0_, rv_size = rv_length1, _tmp1_);
	s = (_tmp2_ = (gchar*) s_in, s_length1 = -1, s_size = s_length1, _tmp2_);
	i = 0;
	j = 0;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		if (!(s[i] != 0)) {
			break;
		}
		if (s[i] == '\\') {
			_tmp3_ = s[i + 1] != 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gboolean bare_escape;
			bare_escape = FALSE;
			switch (s[i + 1]) {
				case 'b':
				{
					rv[j++] = '\b';
					i = i + 2;
					break;
				}
				case 'f':
				{
					rv[j++] = '\014';
					i = i + 2;
					break;
				}
				case 't':
				{
					rv[j++] = '\t';
					i = i + 2;
					break;
				}
				case 'n':
				{
					rv[j++] = '\n';
					i = i + 2;
					break;
				}
				case 'r':
				{
					rv[j++] = '\r';
					i = i + 2;
					break;
				}
				case 'v':
				{
					rv[j++] = '\013';
					i = i + 2;
					break;
				}
				case 'a':
				{
					rv[j++] = '\007';
					i = i + 2;
					break;
				}
				case 'x':
				{
					gboolean _tmp4_ = FALSE;
					if (s[i + 2] != 0) {
						_tmp4_ = s[i + 3] != 0;
					} else {
						_tmp4_ = FALSE;
					}
					if (_tmp4_) {
						gchar* _tmp5_;
						gint tmpstr_size;
						gint tmpstr_length1;
						gchar* tmpstr;
						gulong val;
						tmpstr = (_tmp5_ = g_new0 (gchar, 3), tmpstr_length1 = 3, tmpstr_size = tmpstr_length1, _tmp5_);
						tmpstr[0] = s[i + 2];
						tmpstr[1] = s[i + 3];
						val = strtoul ((const char*) tmpstr, NULL, 16);
						rv[j++] = (gchar) val;
						i = i + 4;
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				case '0':
				case '1':
				case '2':
				case '3':
				case '4':
				case '5':
				case '6':
				case '7':
				{
					gboolean _tmp6_ = FALSE;
					gboolean _tmp7_ = FALSE;
					if (s[i + 2] != 0) {
						_tmp7_ = s[i + 3] != 0;
					} else {
						_tmp7_ = FALSE;
					}
					if (_tmp7_) {
						_tmp6_ = s[i + 4] != 0;
					} else {
						_tmp6_ = FALSE;
					}
					if (_tmp6_) {
						gchar* _tmp8_;
						gint tmpstr_size;
						gint tmpstr_length1;
						gchar* tmpstr;
						gulong val;
						tmpstr = (_tmp8_ = g_new0 (gchar, 4), tmpstr_length1 = 4, tmpstr_size = tmpstr_length1, _tmp8_);
						tmpstr[0] = s[i + 2];
						tmpstr[1] = s[i + 3];
						tmpstr[2] = s[i + 4];
						val = strtoul ((const char*) tmpstr, NULL, 8);
						rv[j++] = (gchar) val;
						i = i + 5;
						tmpstr = (g_free (tmpstr), NULL);
					} else {
						bare_escape = TRUE;
					}
					break;
				}
				default:
				{
					bare_escape = TRUE;
					break;
				}
			}
			if (bare_escape) {
				rv[j++] = s[i + 1];
				i = i + 2;
			}
		} else {
			rv[j++] = s[i++];
		}
	}
	result = g_strdup ((const char*) rv);
	rv = (g_free (rv), NULL);
	return result;
}


static char* string_chomp (const char* self) {
	char* result;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strchomp (_result_);
	result = _result_;
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


static void deja_dup_duplicity_instance_split_line (const char* line, char*** split, int* split_length1) {
	char** _tmp1_;
	gint firstsplit_size;
	gint firstsplit_length1;
	char** _tmp0_;
	char** firstsplit;
	GList* splitlist;
	gint i = 0;
	gboolean in_group;
	char* group_word;
	char** _tmp13_;
	gint _tmp12_;
	g_return_if_fail (line != NULL);
	firstsplit = (_tmp1_ = _tmp0_ = g_strsplit (line, " ", 0), firstsplit_length1 = _vala_array_length (_tmp0_), firstsplit_size = firstsplit_length1, _tmp1_);
	splitlist = NULL;
	in_group = FALSE;
	group_word = g_strdup ("");
	{
		gboolean _tmp2_;
		i = 0;
		_tmp2_ = TRUE;
		while (TRUE) {
			char* word;
			gboolean _tmp4_ = FALSE;
			if (!_tmp2_) {
				i = i + 1;
			}
			_tmp2_ = FALSE;
			if (!(firstsplit[i] != NULL)) {
				break;
			}
			word = g_strdup (firstsplit[i]);
			if (firstsplit[i + 1] == NULL) {
				char* _tmp3_;
				word = (_tmp3_ = string_chomp (word), _g_free0 (word), _tmp3_);
			}
			if (!in_group) {
				_tmp4_ = g_str_has_prefix (word, "\'");
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				in_group = TRUE;
			}
			if (in_group) {
				gboolean _tmp5_ = FALSE;
				char* _tmp7_;
				if (g_str_has_suffix (word, "\'")) {
					_tmp5_ = (deja_dup_duplicity_instance_num_suffix (word, '\\', ((glong) strlen (word)) - 2) % 2) == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					in_group = FALSE;
				} else {
					if ((deja_dup_duplicity_instance_num_suffix (word, '\\', -1) % 2) == 1) {
						char* _tmp6_;
						word = (_tmp6_ = string_substring (word, (glong) 0, g_utf8_strlen (word, -1) - 2), _g_free0 (word), _tmp6_);
					}
				}
				word = (_tmp7_ = deja_dup_duplicity_instance_compress_string (word), _g_free0 (word), _tmp7_);
				if (_vala_strcmp0 (group_word, "") == 0) {
					char* _tmp8_;
					group_word = (_tmp8_ = g_strdup (word), _g_free0 (group_word), _tmp8_);
				} else {
					char* _tmp10_;
					char* _tmp9_;
					group_word = (_tmp10_ = g_strconcat (group_word, _tmp9_ = g_strconcat (" ", word, NULL), NULL), _g_free0 (group_word), _tmp10_);
					_g_free0 (_tmp9_);
				}
				if (!in_group) {
					char* _tmp11_;
					splitlist = g_list_append (splitlist, string_substring (group_word, (glong) 1, g_utf8_strlen (group_word, -1) - 2));
					group_word = (_tmp11_ = g_strdup (""), _g_free0 (group_word), _tmp11_);
				}
			} else {
				splitlist = g_list_append (splitlist, g_strdup (word));
			}
			_g_free0 (word);
		}
	}
	*split = (_tmp13_ = g_new0 (char*, (_tmp12_ = g_list_length (splitlist)) + 1), *split = (_vala_array_free (*split, *split_length1, (GDestroyNotify) g_free), NULL), *split_length1 = _tmp12_, _tmp13_);
	i = 0;
	{
		GList* s_collection;
		GList* s_it;
		s_collection = splitlist;
		for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
			char* s;
			s = g_strdup ((const char*) s_it->data);
			{
				char* _tmp15_;
				char* *_tmp14_;
				_tmp14_ = &(*split)[i++];
				(*_tmp14_) = (_tmp15_ = g_strdup (s), _g_free0 ((*_tmp14_)), _tmp15_);
				_g_free0 (s);
			}
		}
	}
	firstsplit = (_vala_array_free (firstsplit, firstsplit_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free_g_free0 (splitlist);
	_g_free0 (group_word);
}


static void deja_dup_duplicity_instance_process_stanza (DejaDupDuplicityInstance* self, GList* stanza) {
	gint control_line_size;
	gint control_line_length1;
	char** control_line;
	GList* data;
	char* text;
	g_return_if_fail (self != NULL);
	control_line = (control_line_length1 = 0, NULL);
	deja_dup_duplicity_instance_split_line ((const char*) stanza->data, &control_line, &control_line_length1);
	data = deja_dup_duplicity_instance_grab_stanza_data (self, stanza);
	text = deja_dup_duplicity_instance_grab_stanza_text (self, stanza);
	g_signal_emit_by_name (self, "message", control_line, control_line_length1, data, text);
	control_line = (_vala_array_free (control_line, control_line_length1, (GDestroyNotify) g_free), NULL);
	__g_list_free_g_free0 (data);
	_g_free0 (text);
}


static GList* deja_dup_duplicity_instance_grab_stanza_data (DejaDupDuplicityInstance* self, GList* stanza) {
	GList* result;
	GList* list;
	g_return_val_if_fail (self != NULL, NULL);
	list = NULL;
	stanza = stanza->next;
	{
		GList* line_collection;
		GList* line_it;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			char* line;
			line = g_strdup ((const char*) line_it->data);
			{
				if (!g_str_has_prefix (line, ". ")) {
					char* _tmp0_;
					list = g_list_append (list, deja_dup_duplicity_instance_validated_string (_tmp0_ = string_chomp (line)));
					_g_free0 (_tmp0_);
				}
				_g_free0 (line);
			}
		}
	}
	result = list;
	return result;
}


static char* deja_dup_duplicity_instance_grab_stanza_text (DejaDupDuplicityInstance* self, GList* stanza) {
	char* result;
	char* text;
	g_return_val_if_fail (self != NULL, NULL);
	text = g_strdup ("");
	{
		GList* line_collection;
		GList* line_it;
		line_collection = stanza;
		for (line_it = line_collection; line_it != NULL; line_it = line_it->next) {
			char* line;
			line = g_strdup ((const char*) line_it->data);
			{
				if (g_str_has_prefix (line, ". ")) {
					char** _tmp1_;
					gint split_size;
					gint split_length1;
					char** _tmp0_;
					char** split;
					char* _tmp3_;
					char* _tmp2_;
					split = (_tmp1_ = _tmp0_ = g_strsplit (line, ". ", 2), split_length1 = _vala_array_length (_tmp0_), split_size = split_length1, _tmp1_);
					text = (_tmp3_ = g_strdup_printf ("%s%s", text, _tmp2_ = deja_dup_duplicity_instance_validated_string (split[1])), _g_free0 (text), _tmp3_);
					_g_free0 (_tmp2_);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				}
				_g_free0 (line);
			}
		}
	}
	result = string_chomp (text);
	_g_free0 (text);
	return result;
}


static void deja_dup_duplicity_instance_spawn_finished (DejaDupDuplicityInstance* self, GPid pid, gint status) {
	GError * _inner_error_;
	gboolean _tmp0_ = FALSE;
	gboolean success;
	gboolean cancelled;
	g_return_if_fail (self != NULL);
	_inner_error_ = NULL;
	g_object_ref ((GObject*) self);
	if (self->priv->stanza_id != 0) {
		g_source_remove (self->priv->stanza_id);
	}
	self->priv->stanza_id = (guint) 0;
	self->priv->watch_id = (guint) 0;
	if (WIFEXITED (status)) {
		_tmp0_ = WEXITSTATUS (status) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	success = _tmp0_;
	cancelled = !WIFEXITED (status);
	if (self->priv->reader != NULL) {
		GIOChannel* _tmp1_;
		while (TRUE) {
			GIOCondition cond;
			cond = g_io_channel_get_buffer_condition (self->priv->reader);
			if (cond == G_IO_IN) {
				deja_dup_duplicity_instance_read_stanza (self, self->priv->reader, cond);
			} else {
				break;
			}
		}
		if (WIFEXITED (status)) {
			gint exitval;
			exitval = WEXITSTATUS (status);
			g_debug ("DuplicityInstance.vala:449: duplicity (%i) exited with value %i\n", (gint) pid, exitval);
		} else {
			g_debug ("DuplicityInstance.vala:452: duplicity (%i) process killed\n", (gint) pid);
		}
		{
			g_io_channel_shutdown (self->priv->reader, FALSE, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch42_g_error;
				goto __finally42;
			}
		}
		goto __finally42;
		__catch42_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("DuplicityInstance.vala:458: %s\n", e->message);
				_g_error_free0 (e);
			}
		}
		__finally42:
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->reader = (_tmp1_ = NULL, _g_io_channel_unref0 (self->priv->reader), _tmp1_);
	}
	g_spawn_close_pid (pid);
	self->priv->child_pid = (GPid) 0;
	g_signal_emit_by_name (self, "done", success, cancelled);
	g_object_unref ((GObject*) self);
}


DejaDupDuplicityInstance* deja_dup_duplicity_instance_construct (GType object_type) {
	DejaDupDuplicityInstance * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


DejaDupDuplicityInstance* deja_dup_duplicity_instance_new (void) {
	return deja_dup_duplicity_instance_construct (DEJA_DUP_TYPE_DUPLICITY_INSTANCE);
}


gboolean deja_dup_duplicity_instance_get_verbose (DejaDupDuplicityInstance* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_verbose;
	return result;
}


static void deja_dup_duplicity_instance_set_verbose (DejaDupDuplicityInstance* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_verbose = value;
	g_object_notify ((GObject *) self, "verbose");
}


static GObject * deja_dup_duplicity_instance_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DejaDupDuplicityInstance * self;
	parent_class = G_OBJECT_CLASS (deja_dup_duplicity_instance_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DEJA_DUP_DUPLICITY_INSTANCE (obj);
	{
		GIOChannel* _tmp0_;
		gint* _tmp1_;
		self->priv->reader = (_tmp0_ = NULL, _g_io_channel_unref0 (self->priv->reader), _tmp0_);
		self->priv->pipes = (_tmp1_ = g_new0 (gint, 2), self->priv->pipes = (g_free (self->priv->pipes), NULL), self->priv->pipes_length1 = 2, self->priv->pipes_size = self->priv->pipes_length1, _tmp1_);
		self->priv->pipes[0] = self->priv->pipes[1] = -1;
	}
	return obj;
}


static void deja_dup_duplicity_instance_class_init (DejaDupDuplicityInstanceClass * klass) {
	deja_dup_duplicity_instance_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DejaDupDuplicityInstancePrivate));
	DEJA_DUP_DUPLICITY_INSTANCE_CLASS (klass)->start = deja_dup_duplicity_instance_real_start;
	G_OBJECT_CLASS (klass)->get_property = deja_dup_duplicity_instance_get_property;
	G_OBJECT_CLASS (klass)->set_property = deja_dup_duplicity_instance_set_property;
	G_OBJECT_CLASS (klass)->constructor = deja_dup_duplicity_instance_constructor;
	G_OBJECT_CLASS (klass)->finalize = deja_dup_duplicity_instance_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE, g_param_spec_boolean ("verbose", "verbose", "verbose", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("done", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_BOOLEAN, G_TYPE_BOOLEAN);
	g_signal_new ("message", DEJA_DUP_TYPE_DUPLICITY_INSTANCE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING, G_TYPE_NONE, 4, G_TYPE_STRV, G_TYPE_INT, G_TYPE_POINTER, G_TYPE_STRING);
}


static void deja_dup_duplicity_instance_instance_init (DejaDupDuplicityInstance * self) {
	self->priv = DEJA_DUP_DUPLICITY_INSTANCE_GET_PRIVATE (self);
	self->priv->_verbose = FALSE;
}


static void deja_dup_duplicity_instance_finalize (GObject* obj) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (obj);
	{
		if (self->priv->stanza_id != 0) {
			g_source_remove (self->priv->stanza_id);
		}
		if (self->priv->watch_id != 0) {
			g_source_remove (self->priv->watch_id);
		}
		if (deja_dup_duplicity_instance_is_started (self)) {
			g_debug ("DuplicityInstance.vala:185: duplicity (%i) process killed\n", (gint) self->priv->child_pid);
			deja_dup_duplicity_instance_kill_child (self);
		}
	}
	self->priv->pipes = (g_free (self->priv->pipes), NULL);
	_g_io_channel_unref0 (self->priv->reader);
	G_OBJECT_CLASS (deja_dup_duplicity_instance_parent_class)->finalize (obj);
}


GType deja_dup_duplicity_instance_get_type (void) {
	static GType deja_dup_duplicity_instance_type_id = 0;
	if (deja_dup_duplicity_instance_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DejaDupDuplicityInstanceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) deja_dup_duplicity_instance_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DejaDupDuplicityInstance), 0, (GInstanceInitFunc) deja_dup_duplicity_instance_instance_init, NULL };
		deja_dup_duplicity_instance_type_id = g_type_register_static (G_TYPE_OBJECT, "DejaDupDuplicityInstance", &g_define_type_info, 0);
	}
	return deja_dup_duplicity_instance_type_id;
}


static void deja_dup_duplicity_instance_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE:
		g_value_set_boolean (value, deja_dup_duplicity_instance_get_verbose (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void deja_dup_duplicity_instance_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DejaDupDuplicityInstance * self;
	self = DEJA_DUP_DUPLICITY_INSTANCE (object);
	switch (property_id) {
		case DEJA_DUP_DUPLICITY_INSTANCE_VERBOSE:
		deja_dup_duplicity_instance_set_verbose (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__BOOLEAN_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (gpointer data1, gboolean arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOOLEAN_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOOLEAN_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boolean (param_values + 1), g_value_get_boolean (param_values + 2), data2);
}


static void g_cclosure_user_marshal_VOID__BOXED_INT_POINTER_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (gpointer data1, gpointer arg_1, gint arg_2, gpointer arg_3, const char* arg_4, gpointer data2);
	register GMarshalFunc_VOID__BOXED_INT_POINTER_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BOXED_INT_POINTER_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_boxed (param_values + 1), g_value_get_int (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_string (param_values + 4), data2);
}



