/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <dbusmodel/dbusmodel.h>

typedef struct
{
  DbusModel *model;

} RowsFixture;

static void rows_setup    (RowsFixture *fix, gconstpointer data);
static void rows_teardown (RowsFixture *fix, gconstpointer data);

static void test_rows_allocation (RowsFixture *fix, gconstpointer data);
static void test_rows_clear      (RowsFixture *fix, gconstpointer data);

void
test_model_rows_create_suite (void)
{
#define DOMAIN "/Model/Rows"

  g_test_add (DOMAIN"/Allocation", RowsFixture, 0,
              rows_setup, test_rows_allocation, rows_teardown);
  g_test_add (DOMAIN"/Clear", RowsFixture, 0,
              rows_setup, test_rows_clear, rows_teardown);
}

static void
rows_setup (RowsFixture *fix, gconstpointer data)
{
  fix->model = dbus_model_new ("com.canonical.DbusModel.Tests.Rows",
                               2,
                               G_TYPE_INT,
                               G_TYPE_STRING);

  g_assert (DBUS_IS_MODEL (fix->model));
}

static void
rows_teardown (RowsFixture *fix, gconstpointer data)
{
  g_object_unref (fix->model);
}

static void
test_rows_allocation (RowsFixture *fix, gconstpointer data)
{
  g_assert (DBUS_IS_MODEL (fix->model));
}

static gint n_clear_sigs = 0;

static void
on_clear_row_removed (DbusModel *model, DbusModelIter *iter)
{
  n_clear_sigs++;
}

static void
test_rows_clear (RowsFixture *fix, gconstpointer data)
{
  gint i;

  for (i = 0; i < 1000; i++)
    {
      dbus_model_add (fix->model, 0, 10, 1, "Rooney", -1);
    }

  g_assert_cmpint (1000, ==, dbus_model_get_n_rows (fix->model));

  g_signal_connect (fix->model, "row-removed",
                    G_CALLBACK (on_clear_row_removed), NULL);

  n_clear_sigs = 0;
  dbus_model_clear (fix->model);

  g_assert_cmpint (0, ==, dbus_model_get_n_rows (fix->model));
  g_assert_cmpint (1000, ==, n_clear_sigs);
}
