from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestPower(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestPower, self).setUp()
        self.dbus_interface = "com.canonical.android.power.Power"
        self.s_Changed = "Changed"
        self.m_GetDevices = "GetDevices"
        self.m_GetPrimaryDevice = "GetPrimaryDevice"

    def tearDown(self):
        super(TestPower, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_pow.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_power_s_Changed(self):
        item = self.s_Changed
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_power_m_GetDevices(self):
        item = self.m_GetDevices
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_power_m_GetPrimaryDevice(self):
        item = self.m_GetPrimaryDevice
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
