#!/bin/python

import unittest

import dbus
import gobject
import xml.etree.ElementTree as ET
import threading

from dbus.mainloop.glib import DBusGMainLoop


class BaseIntrospectionTestCase(unittest.TestCase):
    def setUp(self):
        gobject.threads_init()
        DBusGMainLoop(set_as_default=True)

        self.loop = gobject.MainLoop()

        dbus_iface = "org.freedesktop.DBus.Introspectable"

        bus = dbus.SessionBus()
        obj_acc = bus.get_object("com.canonical.Android",
                                 "/com/canonical/android/accounts/Accounts")
        self.proxy_acc = dbus.Interface(obj_acc,
                                        dbus_interface=dbus_iface)

        obj_dt = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/datetime/DateTime")
        self.proxy_dt = dbus.Interface(obj_dt,
                                       dbus_interface=dbus_iface)

        obj_net = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/network/NetworkService")
        self.proxy_net = dbus.Interface(obj_net,
                                        dbus_interface=dbus_iface)

        obj_tele = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/telephony/Telephony")
        self.proxy_tele = dbus.Interface(
            obj_tele,
            dbus_interface=dbus_iface)

        obj_callLog = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/telephony/Telephony")
        self.proxy_callLog = dbus.Interface(
            obj_callLog,
            dbus_interface=dbus_iface)

        obj_bt_man = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/bluetooth/BluetoothManager")
        obj_bt_ad = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/bluetooth/BluetoothAdapter")

        self.proxy_bt_man = dbus.Interface(obj_bt_man,
                                           dbus_interface=dbus_iface)
        self.proxy_bt_ad = dbus.Interface(obj_bt_ad,
                                          dbus_interface=dbus_iface)

        obj_mes = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/messages/Messages")
        self.proxy_mess = dbus.Interface(
            obj_mes, dbus_interface=dbus_iface)

        obj_con = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/contacts/Contacts")
        self.proxy_con = dbus.Interface(obj_con, dbus_interface=dbus_iface)

        obj_lock = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/lockmanager/ScreenLockManager")
        self.proxy_lock = dbus.Interface(obj_lock, dbus_interface=dbus_iface)

        obj_pow = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/power/Power")
        self.proxy_pow = dbus.Interface(obj_pow, dbus_interface=dbus_iface)

        obj_dock = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/dockmonitor/DockMonitor")
        self.proxy_dock = dbus.Interface(obj_dock, dbus_interface=dbus_iface)

        obj_app = bus.get_object(
            "com.canonical.Android",
            "/com/canonical/android/applications/Applications")
        self.proxy_app = dbus.Interface(obj_app, dbus_interface=dbus_iface)

        self.thread = threading.Thread(name='glib mainloop',
                                       target=self.loop.run)

    def parse_xml(self, xml_introspect, dbus_if, method_or_signal_name,
                  s_or_m_type):
        item_found = False
        print xml_introspect
        root = ET.fromstring(xml_introspect)
        for child in root:
            if child.attrib['name'] == dbus_if:
                for sub in child:
                    if (sub.attrib['name'] == method_or_signal_name and
                            sub.tag == s_or_m_type):
                        item_found = True
        return item_found
