function get_device() {
    KNOWN_DEVICES="JF
    MAKO"

    DEVICE="VNC"

    for dev in $KNOWN_DEVICES
    do
        grep -q "$dev$" /proc/cpuinfo
        if [ $? -eq 0 ]; then
            DEVICE=$dev
            break
        fi
    done

    # If you want to force VNC mode replace $DEVICE with "VNC"
    echo $DEVICE
}

function pre-start() {
    DEVICE=`get_device`

    if [ $DEVICE = "JF" ]; then
        am broadcast -a samsung.intent.action.ANDROID_HDMI_START_VFB
    fi

    # Run UfA Compliance Tester tests if present
    if [ -x $UFA_DIR/ufa-test-kernel-config ]; then
        $UFA_DIR/ufa-test-kernel-config
    fi

    if [ -x $UFA_DIR/ufa-test-lxc-binaries ]; then
        $UFA_DIR/ufa-test-lxc-binaries
    fi
}

function post-stop() {
    DEVICE=`get_device`

    if [ $DEVICE = "JF" ]; then
        am broadcast -a samsung.intent.action.ANDROID_HDMI_STOP_VFB
    fi
}

function start_display() {
    DEVICE=`get_device`

    if [ $DEVICE = "VNC" ]; then
        su - ufa -c tightvncserver &
    else
        nudev.py
        fbset -i -fb /dev/graphics/fb3 -g 1920 1080 1920 3240 32
        lightdm -c /etc/lightdm/u4a.conf &
    fi
}
