from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestTelephony(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestTelephony, self).setUp()
        self.dbus_interface = "com.canonical.android.telephony.Telephony"
        self.s_CallDtmfBurstComplete = "CallDtmfBurstComplete"
        self.s_CallStateChanged = "CallStateChanged"
        self.s_CallWaiting = "CallWaiting"
        self.s_IncomingCall = "IncomingCall"
        self.s_MuteSetChanged = "MuteSetChanged"
        self.s_SpeakerSetChanged = "SpeakerSetChanged"
        self.m_acceptCall = "acceptCall"
        self.m_canConference = "canConference"
        self.m_comparePhoneNumbers = "comparePhoneNumbers"
        self.m_createCall = "createCall"
        self.m_getBackgroundCall = "getBackgroundCall"
        self.m_getDefaultPhone = "getDefaultPhone"
        self.m_getForegroundCall = "getForegroundCall"
        self.m_getMute = "getMute"
        self.m_getRingingCall = "getRingingCall"
        self.m_hangup = "hangup"
        self.m_hangupBackgroundCall = "hangupBackgroundCall"
        self.m_hangupConnection = "hangupConnection"
        self.m_hangupForegroundCall = "hangupForegroundCall"
        self.m_isSpeakerOn = "isSpeakerOn"
        self.m_mergeIntoConference = "mergeIntoConference"
        self.m_rejectCall = "rejectCall"
        self.m_restoreSpeakerMode = "restoreSpeakerMode"
        self.m_sendBurstDtmf = "sendBurstDtmf"
        self.m_sendDtmf = "sendDtmf"
        self.m_separateCallFromConference = "separateCallFromConference"
        self.m_setMute = "setMute"
        self.m_startDtmf = "startDtmf"
        self.m_stopDtmf = "stopDtmf"
        self.m_switchHoldingAndActive = "switchHoldingAndActive"
        self.m_turnOnSpeaker = "turnOnSpeaker"

    def tearDown(self):
        super(TestTelephony, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_tele.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_telephony_s_CallDtmfBurstComplete(self):
        item = self.s_CallDtmfBurstComplete
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_telephony_s_CallStateChanged(self):
        item = self.s_CallStateChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_telephony_s_CallWaiting(self):
        item = self.s_CallWaiting
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_telephony_s_IncomingCall(self):
        item = self.s_IncomingCall
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_telephony_s_MuteSetChanged(self):
        item = self.s_MuteSetChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_telephony_s_SpeakerSetChanged(self):
        item = self.s_SpeakerSetChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_telephony_m_acceptCall(self):
        item = self.m_acceptCall
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_canConference(self):
        item = self.m_canConference
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_comparePhoneNumbers(self):
        item = self.m_comparePhoneNumbers
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_createCall(self):
        item = self.m_createCall
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_getBackgroundCall(self):
        item = self.m_getBackgroundCall
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_getDefaultPhone(self):
        item = self.m_getDefaultPhone
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_getForegroundCall(self):
        item = self.m_getForegroundCall
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_getMute(self):
        item = self.m_getMute
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_getRingingCall(self):
        item = self.m_getRingingCall
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_hangup(self):
        item = self.m_hangup
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_hangupBackgroundCall(self):
        item = self.m_hangupBackgroundCall
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_hangupConnection(self):
        item = self.m_hangupConnection
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_hangupForegroundCall(self):
        item = self.m_hangupForegroundCall
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_isSpeakerOn(self):
        item = self.m_isSpeakerOn
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_mergeIntoConference(self):
        item = self.m_mergeIntoConference
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_rejectCall(self):
        item = self.m_rejectCall
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_restoreSpeakerMode(self):
        item = self.m_restoreSpeakerMode
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_sendBurstDtmf(self):
        item = self.m_sendBurstDtmf
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_sendDtmf(self):
        item = self.m_sendDtmf
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_separateCallFromConference(self):
        item = self.m_separateCallFromConference
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_setMute(self):
        item = self.m_setMute
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_startDtmf(self):
        item = self.m_startDtmf
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_stopDtmf(self):
        item = self.m_stopDtmf
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_switchHoldingAndActive(self):
        item = self.m_switchHoldingAndActive
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_telephony_m_turnOnSpeaker(self):
        item = self.m_turnOnSpeaker
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
