from ufaspy.tests.introspection import BaseIntrospectionTestCase


class TestBT(BaseIntrospectionTestCase):
    def setUp(self):
        super(TestBT, self).setUp()
        self.dbus_interface = "org.bluez.Adapter"
        self.m_GetProperties = "GetProperties"
        self.m_SetProperty = "SetProperty"
        self.m_RegisterAgent = "RegisterAgent"
        self.m_UnregisterAgent = "UnregisterAgent"
        self.s_PropertyChanged = "PropertyChanged"

    def tearDown(self):
        super(TestBT, self).tearDown()

    def find_item(self, dbus_if, method_or_signal_name, s_or_m_type):
        item_found = False
        xml = self.proxy_bt_ad.Introspect()
        item_found = self.parse_xml(xml, dbus_if, method_or_signal_name,
                                    s_or_m_type)
        return item_found

    def test_bt_adapter_m_GetProperties(self):
        item = self.m_GetProperties
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_SetProperty(self):
        item = self.m_SetProperty
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_m_RegisterAgent(self):
        item = self.m_RegisterAgent
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)

    def test_bt_adapter_s_PropertyChanged(self):
        item = self.s_PropertyChanged
        item_found = self.find_item(self.dbus_interface, item, "signal")
        self.assertTrue(item_found)

    def test_bt_adapter_m_UnregisterAgent(self):
        item = self.m_UnregisterAgent
        item_found = self.find_item(self.dbus_interface, item, "method")
        self.assertTrue(item_found)
