/*
 *
 *  Universal Protocol Analyzer library
 *
 *  Copyright (C) 2006-2008  Marcel Holtmann <marcel@holtmann.org>
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifndef __UPA_BLUETOOTH_HCI_H__
#define __UPA_BLUETOOTH_HCI_H__

#include <glib-object.h>

#include "upa-packet.h"

G_BEGIN_DECLS

#define UPA_TYPE_BLUETOOTH_HCI (upa_bluetooth_hci_get_type())

#define UPA_BLUETOOTH_HCI(obj) \
	(G_TYPE_CHECK_INSTANCE_CAST((obj),UPA_TYPE_BLUETOOTH_HCI,UpaBluetoothHci))

typedef struct _UpaBluetoothHci UpaBluetoothHci;
typedef struct _UpaBluetoothHciClass UpaBluetoothHciClass;

struct _UpaBluetoothHci {
	UpaPacket packet;

	guint8 type;
};

struct _UpaBluetoothHciClass {
	UpaPacketClass packet_class;
};

GType upa_bluetooth_hci_get_type(void);

UpaPacket *upa_bluetooth_hci_new(guint8 type);
UpaPacket *upa_bluetooth_hci_new_from_data(guint8 type,
						gpointer data, gsize size);

G_END_DECLS

#endif /* __UPA_BLUETOOTH_HCI_H__ */
